package com.cloud.hisavana.sdk.common.http;


import android.util.Log;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.concurrent.TimeUnit;

import okhttp3.Cache;
import okhttp3.OkHttpClient;

/**
 * 广告SDK里面只创建一个 对象
 */
public class ADOkHttpClient {

    private OkHttpClient okHttpClient;
    private static ADOkHttpClient client;

    /**
     * 超时时间 20s
     * 最大缓存容量
     */
    private final int OK_HTTP_TIMEOUT = 20;
    private final long CACHE_MAX_SIZE = 10 * 1024 * 1024;


    // =============================================================================================


    public static ADOkHttpClient getInstance() {
        if (client == null) {
            synchronized (ADOkHttpClient.class) {
                if (client == null) {
                    client = new ADOkHttpClient();
                }
            }
        }
        return client;
    }

    private ADOkHttpClient() {
        try {
            // 反射获取 OkHttpClient
            final String storeOnSqliteClassName = "okhttp3.OkHttpClient";
            final Constructor constructor = Class.forName(storeOnSqliteClassName)
                    .getDeclaredConstructor();
            okHttpClient = (OkHttpClient) constructor.newInstance();

            okHttpClient.newBuilder()
                    .connectTimeout(OK_HTTP_TIMEOUT, TimeUnit.SECONDS)
                    .readTimeout(OK_HTTP_TIMEOUT, TimeUnit.SECONDS)
                    .cache(new Cache(new File(CoreUtil.getContext().getExternalCacheDir().getAbsolutePath()), CACHE_MAX_SIZE))
                    .writeTimeout(OK_HTTP_TIMEOUT, TimeUnit.SECONDS);
        } catch (Exception e) {
            AdLogUtil.Log().e(CommonLogUtil.IMG_TAG,"ADOkHttpClient --> 反射创建OkHttpClient 失败 --> " + Log.getStackTraceString(e));
        }
    }


    // =============================================================================================


    /**
     * @return 返回全局的 client
     */
    protected OkHttpClient getOkHttpClient() {
        return okHttpClient;
    }

}
