package com.cloud.hisavana.sdk.common.ps;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import com.cloud.hisavana.sdk.ad.base.PsPostBody;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.activity.TAdExposureActivity;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.AdPSServerRequest;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.util.PackageUtil;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 请求ps中间类工具类
 */
public class PsRequestManager implements Serializable {
    //是PS广告的标识
    public static final String CLICKURLS_PS_FLAG = "b1CustomAppPage";
    //是gplink的标识
    private static final String CLICKURLS_GPLINK_FLAG = "play.google.com";
    public static final String INTENT_TAG_GPLINK = "gplink";
    public static final String INTENT_TAG_RESPONSEDATA = "responseData";
    private String gpLink;
    private List<String> gpLinkList;
    private List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS;
    private AdsDTO adsDTO;
    private AdPsResponseBody.DataDTO responseData;

    public PsRequestManager(AdsDTO adsDTO) {
        this.adsDTO = adsDTO;
        gpLinkList = new ArrayList<>();
        psLinkListDTOS = new ArrayList<>();
    }

    /**
     * 请求ps素材
     */
    public void getRecommendItemIist() {
        //判断是否满足请求ps素材的条件,不满足直接返回
        if (!isPsAd()) {
            return;
        }
        //请求ps素材埋点
        AthenaTracker.trackSspRequestPs(adsDTO, gpLink);
        //ps发起请求，服务端未返回物料数据
        adsDTO.setAdPsType(Constants.AD_PS_TYPE.PS_MATERIAL_NOT_RETURN);
        //网络请求
        AdPSServerRequest adPsServerRequest = new AdPSServerRequest().setListener(new CommonResponseListener<AdPsResponseBody>() {
            @Override
            protected void onRequestSuccess(int statusCode, AdPsResponseBody response) {
                if (response != null && response.getCode() == Constants.ResponseCode.BUSINESS_SUCCESS_CODE && response.getData() != null) {
                    responseData = response.getData();
                    gpLinkList = response.getData().getGpLinkList();
                    psLinkListDTOS = response.getData().getPsLinkList();
                    //返回ps素材埋点
                    AthenaTracker.trackSspReturnPs(adsDTO, gpLinkList, psLinkListDTOS, null);
                    if (gpLinkList == null || psLinkListDTOS == null || gpLinkList.isEmpty() || psLinkListDTOS.isEmpty() || psLinkListDTOS.size() < 2) {
                        adsDTO.setAdPsType(Constants.AD_PS_TYPE.PS_RECOMMEND_ITEM_IIST_LESS);
                        return;
                    }
                    //初始化需要下载的素材地址
                    List<String> imageUrls = new ArrayList<>();
                    for (String link : gpLinkList) {
                        if (!TextUtils.isEmpty(link)) {
                            imageUrls.add(link);
                        }
                    }
                    for (AdPsResponseBody.PsLinkListDTO psLinkListDTO : psLinkListDTOS) {
                        if (!TextUtils.isEmpty(psLinkListDTO.getIcon())) {
                            imageUrls.add(psLinkListDTO.getIcon());
                        }
                    }
                    //开始下载素材
                    if (imageUrls.size() > 0) {
                        ImageDownloadHelper.preCacheSplashImages(imageUrls, adsDTO, AthenaTracker.M_TYPE_AD_PS, new ImageDownloadHelper.ImageListener() {
                            @Override
                            public void onImagesCached(byte[] data) {
                                AdLogUtil.Log().d(CommonLogUtil.TAG,"*----> psRequest ImageDownload SUCCESS");
                                adsDTO.setAdPsType(Constants.AD_PS_TYPE.PS_MATERIAL_DOWNLOAD_SUCCESS);
                            }

                            @Override
                            public void onImagesFailedToCache(TaErrorCode errorCode) {
                                AdLogUtil.Log().d(CommonLogUtil.TAG,"*----> psRequest ImageDownload FAIL");
                                adsDTO.setAdPsType(Constants.AD_PS_TYPE.PS_MATERIAL_DOWNLOAD_FAIL);
                            }
                        });
                    }
                }else {
                    TaErrorCode taErrorCode;
                    if (response != null) {
                        taErrorCode = new TaErrorCode(response.getCode(), response.getMessage());
                    } else {
                        taErrorCode = new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_1, "response is null");
                    }
                    //返回ps素材埋点
                    AthenaTracker.trackSspReturnPs(adsDTO, gpLinkList, psLinkListDTOS, taErrorCode);
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                //返回ps素材埋点
                AthenaTracker.trackSspReturnPs(adsDTO, gpLinkList, psLinkListDTOS, adError);
                if (null != adError) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "getRecommendItemIist Error=" + adError.getErrorMessage());
                }
            }

        }).setPostBody(new AdPSServerRequest.IAdPostBody() {
            @Override
            public String getPostBody() {
                return PsPostBody.getAdPostBody(gpLink);
            }
        })
                .setDebug(AdManager.isDebug())
                .setUrl(AdxServerConfig.getPsServerUrl() + Constants.HOST.PS_API);
        if (adPsServerRequest != null) {
            adPsServerRequest.netRequestPreExecute();
        }

    }

    /**
     * 判断是否是满足请求ps素材的条件
     * 下载类广告 && 是PS广告 && 安装了PS && clickurls里面有gplink
     */
    public boolean isPsAd() {
        //是PS广告 -- click_urls里面第一个元素设置成标识b1CustomAppPage就是PS广告
        if (TextUtils.isEmpty(adsDTO.getPackageName())
                || adsDTO.getStoreDeeplink() == null
                || adsDTO.getStoreDeeplink().size() == 0
                || !TextUtils.equals(adsDTO.getStoreDeeplink().get(0), CLICKURLS_PS_FLAG)) {
            adsDTO.setAdPsType(Constants.AD_PS_TYPE.NO_PS_AD);
            return false;
        }
        //安装了PS
        if (!PackageUtil.checkExistPS(CoreUtil.getContext())) {
            adsDTO.setAdPsType(Constants.AD_PS_TYPE.PS_NOT_INSTALL);
            return false;
        }
        //clickurls里面有gplink, 包含域名"play.google.com"
        for (String deeplink : adsDTO.getStoreDeeplink()) {
            if (deeplink != null && deeplink.contains(CLICKURLS_GPLINK_FLAG)) {
                gpLink = deeplink;
                break;
            }
        }
        if (TextUtils.isEmpty(gpLink)) {
            adsDTO.setAdPsType(Constants.AD_PS_TYPE.PS_NOT_GPLINK);
            return false;
        }
        return true;
    }

    /**
     * ps中间页弹窗
     */
    public void psAdDialog(final Context context) {
        AdLogUtil.Log().d(CommonLogUtil.TAG,"*----> psAdDialog show");
        Intent intent = new Intent(context,PsAdActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(TAdExposureActivity.TAG_AD,adsDTO);
        intent.putExtra(INTENT_TAG_GPLINK,gpLink);
        intent.putExtra(INTENT_TAG_RESPONSEDATA,responseData);
        context.startActivity(intent);
    }



    /**
     * 给imageview设置图片
     */
    public static void renderImageView(final String url, final ImageView imageView, final ImageView imageView_hori) {
        DownLoadRequest downLoadRequest = new DownLoadRequest().setListener(new DrawableResponseListener() {
            @Override
            public void onRequestSuccess(int statusCode, byte[] data, AdImage adMedia) {
                if (imageView_hori != null && adMedia.getDrawable() != null && adMedia.getDrawable().getIntrinsicWidth() > adMedia.getDrawable().getIntrinsicHeight()) {
                    imageView_hori.setImageDrawable(adMedia.getDrawable());
                    imageView.setVisibility(View.GONE);
                } else {
                    imageView.setImageDrawable(adMedia.getDrawable());
                    if (imageView_hori != null) imageView_hori.setVisibility(View.GONE);
                }
                AdLogUtil.Log().d(CommonLogUtil.TAG, "bind drawable to imageView success");
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "bind drawable to imageView failed, code: " + adError.getErrorCode() + ",message:" + adError.getErrorMessage());
            }
        }).setUrl(url).setAdsDTO(null, AthenaTracker.M_TYPE_AD_PS);
        downLoadRequest.netRequestPreExecute();
    }

}
