package com.cloud.hisavana.sdk.common.tranmeasure;


import static com.cloud.sdk.commonutil.util.CommonLogUtil.MEASURE_TAG;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.AdLogUtil;


/**
 * 利用Handler 做周期事件
 */
public class HandlerMonitor extends Monitor{

    private Handler mHeartHandler = null;
    private boolean mRunningState = false;
    private static final int INTERVAL = 200;
    private ScreenStateManager mStateManager = null;

    private final ScreenStateManager.IState screenStateManagerListener = new ScreenStateManager.IState() {
        @Override
        public void updateState(boolean forground) {
            if(forground){
                sendHeartPkg();
            }else {
                stopHeartPkg();
            }
        }
    };

    protected HandlerMonitor(){
        mStateManager = new ScreenStateManager();
        mStateManager.setStateListener(screenStateManagerListener);
    }

    @Override
    public void start(){
        if(mRunningState && mHeartHandler != null && mHeartHandler.hasMessages(0)){
            AdLogUtil.Log().d(MEASURE_TAG,"monitor is running");
            return;
        }
        AdLogUtil.Log().d(MEASURE_TAG,"start monitor");
        sendHeartPkg();
        // 每次都需要设置 优化熄屏之后曝光监测继续运行
        mStateManager.setStateListener(screenStateManagerListener);
        mStateManager.startMonitor();
    }

    private void sendHeartPkg(){
        mRunningState = true;
        if (mHeartHandler == null) {
            mHeartHandler = new Handler(Looper.getMainLooper());
        }
        mHeartHandler.post(immediateRunnable);
        mHeartHandler.postDelayed(delayRunnable, INTERVAL);
    }

    private void stopHeartPkg(){
        mRunningState = false;
        if (mHeartHandler != null) {
            mHeartHandler.removeCallbacks(delayRunnable);
            mHeartHandler = null;
        }
    }

    /**
     * 这个就是 心跳200ms 需要做的事情
     */
    private final Runnable immediateRunnable = new Runnable() {
        @Override
        public void run() {
            if(mRunningState){
                if (AdManager.isDebug()){
                    Log.e(MEASURE_TAG, " -------- measure ---------");
                }
                MeasureSessionManager.getInstance().measure();
            }
        }
    };
    private final Runnable delayRunnable = new Runnable() {
        @Override
        public void run() {
            if(mRunningState && mHeartHandler != null){
                mHeartHandler.post(immediateRunnable);
                mHeartHandler.postDelayed(delayRunnable, INTERVAL);
            }
        }
    };

    @Override
    public void end(){
        AdLogUtil.Log().d(MEASURE_TAG,"stop monitor");
        mRunningState = false;
        mStateManager.endMonitor();
        stopHeartPkg();
    }

}
