package com.cloud.hisavana.sdk.common.tranmeasure;


import static com.cloud.sdk.commonutil.util.CommonLogUtil.MEASURE_TAG;

import android.app.Activity;
import android.view.View;

import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.sdk.commonutil.util.LifecycleUtil;

import java.util.List;

/**
 * @author xinbing.zhang
 * @date :2022/2/24 16:56
 * @description:
 */
public class SspActivityLifecycleCallbacks {

    /**
     * 注册一下
     */
    public static void measureLifecycleCallbacks() {
        LifecycleUtil.addListener(new LifecycleUtil.LifecycleListener() {
            @Override
            public void onActivityStarted(Activity activity) {
                changeAdViewStatus(activity, false);
            }
            @Override
            public void onActivityStopped(Activity activity) {
                changeAdViewStatus(activity, true);
            }
        });
    }


    /**
     * 修改当前界面广告View的测量状态
     *
     * @param activity       activity
     * @param isActivityStop 当前生命周期状态是否满足关闭监测
     */
    private static void changeAdViewStatus(Activity activity, boolean isActivityStop) {
        // 注册 Activity 的监听 服务端的
        if (!AdManager.isOptimizedMeasure()) {
            return;
        }
        if (null == activity || null == activity.getWindow() || null == activity.getWindow().getDecorView()) {
            return;
        }
        // 监听的AdView是否在当前状态修改的Activity里面
        List<MeasureSession> runningSessions = MeasureSessionManager.getInstance().getRunningSessions();
        if (null == runningSessions) {
            return;
        }
        // 当前stop 状态的 MeasureSession 数量
        int stopCount = 0;
        for (MeasureSession session : runningSessions) {
            if (null != session) {
                View adView = session.getAdView();
                if (null != adView && null != activity.getWindow()) {
                    // Activity的View树中任何节点调用getRootView都是DecorView
                    View rootView = adView.getRootView();
                    View decorView = activity.getWindow().getDecorView();
                    if (rootView == decorView) {
                        // 将当前view的状态置为stoped，判断是否需停止心跳
                        session.setStop(isActivityStop);
                        AdLogUtil.Log().d(MEASURE_TAG, "当前界面有广告 --> 改变状态 --> " + (isActivityStop ? "stop measure" : "start measure"));
                    }
                }
                if (session.isStop()) {
                    stopCount += 1;
                }
            }
        }
        // 开启关闭
        changeMonitorStatus(stopCount == runningSessions.size(), isActivityStop, activity);
    }

    /**
     * 当前是否需要开启、关闭测量监测
     *
     * @param isStop
     * @param isActivityStop
     * @param activity
     */
    private static void changeMonitorStatus(boolean isStop, boolean isActivityStop, Activity activity) {
        // 检查一下 都暂停了 那就停止心跳检测
        if (isStop) {
            AdLogUtil.Log().d(MEASURE_TAG, " activity = " + activity.getLocalClassName() + " measure: 都暂停了 那就停止心跳检测 --> Monitor.getInstance().end();  isStop = " + isActivityStop);
            //修复因为修改了状态到停止心跳监测时间在200ms内，之前的心跳测绘还没有执行到，导致不上报离开事件
            MeasureSessionManager.getInstance().measure();
            Monitor.getInstance().end();
        } else {
            AdLogUtil.Log().d(MEASURE_TAG, " activity = " + activity.getLocalClassName() + " measure: 没有全部暂停 开启心跳 --> Monitor.getInstance().start();  isStop = " + isActivityStop);
            Monitor.getInstance().start();
        }
    }

}
