package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;

import java.util.Set;

public class SensitiveUtil {

    public final static String TAG = "SensitiveUtil";

    /**
     * 广告屏蔽关键字相关
     * @param content
     * @return
     */
    public static boolean isSensitive(String title, String content) {
        if (!TextUtils.isEmpty(content) || !TextUtils.isEmpty(title)) {

            Set<String> keywords = AdxPreferencesHelper.getInstance()
                    .getStringSet(Constants.Config.SENSITIVE_KEYWORDS);
            AdLogUtil.Log().d(TAG, "Sensitive keywords is:=" + keywords);
            if (keywords != null){
                for (String word : keywords) {
                    if(TextUtils.isEmpty(word)) continue;
                    if(filter(content, word)) return true;
                    if(filter(title, word)) return true;
                }
            }
        }
        AdLogUtil.Log().d(TAG, "sensitive check is pass");
        return false;
    }

    public static boolean isWords(String key){
        String regex = "^[a-z0-9A-Z]+$";
        return key.matches(regex);
    }

    public static boolean filter(String content, String key) {
        if(TextUtils.isEmpty(content)) return false;
        key = key.toLowerCase();
        if (!isWords(key)) {
            if (content.toLowerCase().trim().contains(key)) {
                AdLogUtil.Log().d(TAG, "is sensitive ,word is: " + key);
                AdLogUtil.Log().d(TAG, "is sensitive ,content is: " + content);
                return true;
            }
            return false;
        } else {
            String[] strs = content.split("[^a-zA-Z0-9]+");
            for(String str : strs) {
                if(TextUtils.equals(str.toLowerCase(), key)) return true;
            }
            return false;
        }
    }

    /**
     * 广告是否包含屏蔽关键词
     *
     * @param nativeInfo
     * @return
     */
    public static boolean isSensitive(TaNativeInfo nativeInfo) {
        final boolean contentIsSensitive = isSensitive(nativeInfo.getTitle(), nativeInfo.getDescription());
        return contentIsSensitive;
    }
}

