package com.cloud.hisavana.sdk.internal.splash;

import static android.view.View.LAYOUT_DIRECTION_LTR;
import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.UNKNOWN_ERROR_CODE_2;
import static com.cloud.sdk.commonutil.util.CommonLogUtil.SPLASH_TAG;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.AdxSplash;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.common.adapter.ISplash;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.CountTimeView;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.DiskAdBean;
import com.cloud.hisavana.sdk.data.control.AdBodyPersistenceHelper;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.transsion.core.utils.NetUtil;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 广告数据处理类
 * 在这里 请求了广告
 * 从缓存中获取了广告
 */
public class TranSplash {

    private CountTimeView mCountTimeView;
    private OnSkipListener mSkipListener;
    private final ViewGroup mViewGroup;

    private final Context mContext;
    private SplashImage mSplashImage = null;
    protected AdsDTO mAdBean;
    private final ISplash mSplash;  // AdxSplash

    public String mSdkVersion;
    protected String mPlacementId = "";
    public static boolean mIsAllowSkip = true;
    protected boolean mSplashClicked;
    protected AdListener mListener;
    protected AdRequest mAdRequest;
//    protected TaRequest mTaRequest = new TaRequest.TaRequestBuild().build();

    private String currentAdId;  // 当前显示的广告的uuid 用于移除已经显示过的广告
    private boolean isDefaultAd = false; //是否是打底广告
    private int requestType;
    private String mRequestId;

    /**
     * 标识 从缓存中有没有获取数据
     * true 从缓存中获取到了数据
     * false 从缓存中没有获取到数据
     */
    private static Boolean isLoadAd;


    // =============================================================================================


    /**
     * 状态回调
     */
    private final InternalAdListener mInternalListener = new InternalAdListener() {

        @Override
        public void onAdLoaded() {
            if (mListener != null) {
                AdLogUtil.Log().d(SPLASH_TAG,"onAdLoaded");
                mListener.onAdLoaded();
            }
        }

        /**
         * 1.从缓存中获取到数据
         * 2.刚开始没有获取到缓存数据 进行网络请求 获取到数据 回调当前
         * ----------------------
         * 1.从打底广告缓存中获取到数据
         *
         */
        @Override
        public void onSplashCacheGet(List<AdsDTO> adBeans) {
            if (adBeans != null && adBeans.size() > 0) {
                mAdBean = adBeans.get(0);
                if (mAdBean == null) {
                    if (mListener != null) {
                        AdLogUtil.Log().d(SPLASH_TAG,"onError,AdBean is null");
                        mListener.onError(new TaErrorCode(UNKNOWN_ERROR_CODE_2, "AdBean is empty"));
                    }
                    return;
                }
                loadPlatformAd();
            }
        }

        @Override
        public void onAdShow() {
            // 当前获取到的广告数据 将要显示的id
            if (mAdBean != null){
                currentAdId = mAdBean.getUuid();
            }
            AdLogUtil.Log().d(SPLASH_TAG,"*----> onAdShow id currentAdId=" + currentAdId);

            if (mListener != null) {
                mListener.onAdShow();
            }

            // 这条广告显示过了 将他从磁盘中清除
            if (!isDefaultAd) removeAdWithIdAboutDisk(mPlacementId);
        }

        /**
         * 当一个广告展示之后就从本地缓存清除
         *
         * @param key 广告位置id
         */
        private void removeAdWithIdAboutDisk(String key) {

            AdLogUtil.Log().d(SPLASH_TAG,"*----> this ad is showed, remove it from splash pool, mPlacementId=" + key + " currentAdId=" + currentAdId);

            if (TextUtils.isEmpty(currentAdId)) {
                AdLogUtil.Log().d(SPLASH_TAG,"*----> currentAdId==0，no ad show，return");
                return;
            }

            // 获取所有数据
            String jsonStr = AdBodyPersistenceHelper.getInstance().getString(key, null);
            if (!TextUtils.isEmpty(jsonStr)) {
                try {
                    // 数据容器
                    List<AdsDTO> list = new ArrayList<>();
                    // 1.取出数据
                    DiskAdBean diskAdBean = GsonUtil.fromJson(jsonStr, DiskAdBean.class);

                    if (diskAdBean != null && diskAdBean.getList() != null) {
                        List<AdsDTO> object = diskAdBean.getList();
                        AdLogUtil.Log().d(SPLASH_TAG,"*----> ad in splash pool，size=" + object.size());

                        // 2.排除已经显示过的广告数据
                        for (AdsDTO ob : object) {
                            if (!TextUtils.equals(ob.getUuid(),currentAdId)) {
                                list.add(ob);
                            }
                        }
                        AdLogUtil.Log().d(SPLASH_TAG,"*----> remove showed ad from splash pool , ad in splash pool，size=" + list.size());

                        // 4.将检查后的数据保存起来
                        AdxSplash.SplashNetRequest.cacheSplashList(key, list, false);
                    }
                } catch (Throwable e) {
                    AdLogUtil.Log().e(SPLASH_TAG,Log.getStackTraceString(e));
                }
            }
        }

        @Override
        public void onError(TaErrorCode adError) {
            // 动画
            dismissSplash(0L);
            // 回调
            if (mListener != null) {
                AdLogUtil.Log().d(SPLASH_TAG,"onError");
                mListener.onError(adError);
            }
        }

        @Override
        public void onErrorInternal(List<AdsDTO> adBeans, TaErrorCode adError, AdxImpBean adxImpBean) {
            super.onErrorInternal(adBeans, adError, adxImpBean);
            onError(adError);
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {

            // 处理开屏图片点击事件
            boolean isSuccess = mSplash.startLandingPage(mViewGroup.getContext(), mAdBean, pointBean);
            if (isSuccess) {
                mSplashClicked = true;
                if (mListener != null) {
                    AdLogUtil.Log().d(SPLASH_TAG,"onAdClicked");
                    mListener.onAdClicked(pointBean);
                }
            } else {
                AdLogUtil.Log().d(SPLASH_TAG,"splash is not skip// " +
                        "dpl=" + mAdBean.getDeepLinkUrl() + "landingPage=" + mAdBean.getClickUrl()
                        + "isAllow=" + TranSplash.mIsAllowSkip);
            }
        }

        @Override
        public void onAdClosed() {
            dismissSplash(100L);
        }

        @Override
        public void onTimeOut() {
            dismissSplash(100L);
        }
    };

    /**
     * 开屏缓存广告，和Splash View生命周期分开
     */
    private static final SplashRequestListener sRequestCallback = null;

    /**
     * 广告加载的回调 内部弱引用持有 媒体传进来的广告加载回调
     * 当前回调之后 将事件通过弱引用持有的回调将事件传递出去
     */
    private static class SplashRequestListener extends InternalAdListener {

        WeakReference<InternalAdListener> listener;

        long startTime;

        AtomicInteger imageCounter;
        AtomicInteger imageList;

        AdxImpBean adxImpBean;
        SplashRequestListener(AdxImpBean adxImpBean, InternalAdListener mInternalListener) {
            startTime = System.currentTimeMillis();
            this.adxImpBean = adxImpBean;
            listener = new WeakReference<>(mInternalListener);
        }

        @Override
        public void onError(TaErrorCode adError) {
            AdLogUtil.Log().d(SPLASH_TAG,"TranSplash onError adError=" + adError.getErrorMessage());

            // 缓存中没有获取到数据 --> 网络请求 --> 网络请求失败了 --> 回调给媒体处理
            // 错误回调出去给媒体处理
            if (null != listener && listener.get() != null && !isLoadAd) {
                listener.get().onErrorInternal(null,adError,adxImpBean);
                AdLogUtil.Log().w(SPLASH_TAG,"*----> load ad from splash pool error, load from network error, end load splash");
            }
        }

        @Override
        public void onAdResponse(final List<AdsDTO> adBeans) {
            //splash的返回埋点上报
            super.onAdResponse(adBeans);
            // 返回多条数据 的处理  --> 到这里 广告请求的数据返回了
            if (adBeans != null && adBeans.size() > 0) {

                // 记录一下 一共有多少条数据
                imageCounter = new AtomicInteger(adBeans.size());
                imageList = new AtomicInteger();

                AdLogUtil.Log().d(SPLASH_TAG,"*----> request splash ad from network success，adBeans.size()=" + adBeans.size());

                // 循环处理每一条数据 下载每一个素材对应的图片
                for (final AdsDTO adItem : adBeans) {

                    if (adItem == null) {
                        AdLogUtil.Log().d(SPLASH_TAG,"adItem is null,terminate flow");
                        return;
                    }
                    TranSplash.mIsAllowSkip = AdxPreferencesHelper.getInstance().getBoolean(Constants.Config.ALLOW_SKIP_OUT, Constants.Config.ALLOW_SKIP_OUT_DEFAULT);

                    final List<String> imageUrls = new ArrayList<>();
                    final String imageUrl = adItem.getAdImgUrl();
                    imageUrls.add(imageUrl);

                    AdLogUtil.Log().d(SPLASH_TAG,"adItem.uuid =" + adItem.getUuid() + ",download ad material，imageUrl=" + adItem.getAdImgUrl());

                    // 广告数据加载成功之后 开始下载图片 缓存到本地
                    ImageDownloadHelper.preCacheSplashImages(imageUrls, adItem, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
                        @Override
                        public void onImagesCached(byte[] data) {
                            if (adItem != null && null != imageList) {
                                // 设置标识 当前图片缓存成功
                                adItem.setImageIsDownload(true);
                                // 刷新一下 数据源 用于记录当前有多少图片下载成功
                                imageList.incrementAndGet();
                                doAdResponse(adBeans);
                            }
                        }

                        @Override
                        public void onImagesFailedToCache(TaErrorCode errorCode) {
                            // 图片下载失败 整个广告数据都不保存
                            if (null != adItem) {
                                AdLogUtil.Log().d(SPLASH_TAG,"ad data cache success，but ad material cache fail，adItem.uuid = " + adItem.getUuid());
                                // 刷新一下 数据源
                                doAdResponse(adBeans);
                            }
                        }
                    });
                }
            }
        }

        /**
         * 处理广告素材
         *
         * @param adBeans
         */
        private synchronized void doAdResponse(List<AdsDTO> adBeans) {
            int count = imageCounter.decrementAndGet();

            if (adBeans == null) {
                return;
            }

            // 所有的请求都回来了 成功+失败
            if (count == 0) {
                if (imageList.get() > 0) {
                    // 至少一个成功了
                    AdLogUtil.Log().d(SPLASH_TAG,"doAdResponse() - At least one succeeded imageList=" + imageList.get());

                    // 图片下载完成之后 将图片下载成功的 广告数据保存到本地
                    List<AdsDTO> list = new ArrayList<>();
                    for (AdsDTO ad : adBeans) {
                        if (null != ad && ad.getImageIsDownload()) {
                            list.add(ad);
                        }
                    }
                    // 将图片下载成功的数据保存到本地
                    Boolean flag = AdxSplash.SplashNetRequest.cacheSplashList(adxImpBean.pmid, list, true);
                    //true 保存成功 false 保存失败
                    //在加载广告的时候 没有获取到缓存，等网络获取到数据之后在返回
                    if (flag && !isLoadAd && null != listener && null != listener.get()) {
                        //将数据回调出去 通知媒体 数据加载完成
                        AdLogUtil.Log().w(SPLASH_TAG,"*----> doAdResponse() - The ad data cache succeeded，load from splash pool fail ，load from network success，end load splash");
                        listener.get().onSplashCacheGet(list);
                    }

                    //错误回调出去给媒体处理
                    if (null != listener && listener.get() != null && !flag && !isLoadAd) {
                        AdLogUtil.Log().d(SPLASH_TAG,"*----> doAdResponse() - The ad data cache failed，load from splash pool fail ，load from network fail，end load splash");
                        listener.get().onError(new TaErrorCode(101, "cacheSplash is false"));
                    }

                } else {
                    // 失败了
                    if (null != listener && listener.get() != null && !isLoadAd) {
                        AdLogUtil.Log().d(SPLASH_TAG,"doAdResponse() - The ad material cache failed，load from splash pool fail ，load from network fail，end load splash");
                        listener.get().onError(new TaErrorCode(101, ""));
                    } else {
                        AdLogUtil.Log().d(SPLASH_TAG,"doAdResponse() - The ad data cache success，The ad material cache failed，load from splash pool success，end load splash");
                    }
                }
            }

        }

    }


    // =============================================================================================

    /**
     * 构造方法
     *
     * @param context
     * @param
     */
    public TranSplash(Context context, ViewGroup viewGroup, String placementId) {
        this.mViewGroup = viewGroup;
        this.mContext = context;
        this.mPlacementId = placementId;

        // 当前SDK版本号
        mSdkVersion = BuildConfig.VERSION_NAME;

        // 这个才是正真发起请求的对象
        mSplash = new AdxSplash(placementId);
        mSplash.setAdListener(mInternalListener);
    }


    // =============================================================================================


    /**
     * 展示广告item , 目前只支持自有大图和Naive 开屏
     */
    private void loadPlatformAd() {
        mSplashImage = new SplashImage(this);
        // 缓存开屏大图
        mSplashImage.loadImage(Constants.ImageLoadType.IMAGE_DISK_INCLUDED);
    }


    // =============================================================================================


    /**
     * 加载广告
     * 1.本地缓存中获取
     * 2.发起网络请求
     */
    public void loadAd(String requestId) {
        mRequestId = requestId;
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                loadAdInternal();
            }
        });
    }

    public void loadAd(){
        loadAd(DeviceUtil.getUUID());
    }

    private void loadAdInternal() {
        AdLogUtil.Log().d(SPLASH_TAG,"*----> begin load splash ad");

        // 没有网络
        if (!NetUtil.checkNetworkState()) {
            if (mInternalListener != null) {
                // 当前没有网络 回调给媒体
                AdLogUtil.Log().d(SPLASH_TAG,"loadAdInternal - no network callback, NETWORK_ERROR");
                mInternalListener.onError(TaErrorCode.NETWORK_ERROR);
            }
            return;
        }

        // 1. 从本地缓存中加载广告
        isLoadAd = false; // 重置数据

        isLoadAd = mSplash.loadAd(mRequestId,requestType);
        AdLogUtil.Log().d(SPLASH_TAG,"*----> loadAdInternal - from splash pool，isLoadAd = " + isLoadAd);

        if (isDefaultAd) {
            //如果是打底广告，就不需要继续从网络获取
            if (mListener != null && !isLoadAd) {
                mListener.onError(new TaErrorCode(100, "load splash default ad error"));
                AdLogUtil.Log().w(SPLASH_TAG,"*----> loadAdInternal - end load default splash ad");
            }
        } else {
            // 如果本地数据小于等于1条 就发起网络请求
            if (isLoadAd && mSplash.getAdListSize() > 1) {
                AdLogUtil.Log().d(SPLASH_TAG,"*----> ad in splash pool AdListSize() = " + mSplash.getAdListSize() + ",end load splash ad ");
                return;
            }
            // 2.发起网络请求
            AdLogUtil.Log().w(SPLASH_TAG,"*----> loadAdInternal - ad in splash pool AdListSize() = 0，start load splash from network");
            //开屏缓存广告，和Splash View生命周期分开
            AdxImpBean adxImpBean = new AdxImpBean();
            adxImpBean.requestId = mRequestId;
            adxImpBean.adt = Constants.AdType.SPLASH_NATIVE;
            adxImpBean.requestTs = System.currentTimeMillis();
            adxImpBean.pmid = mPlacementId;
            adxImpBean.defaultAd = false;
            adxImpBean.requestType = requestType;
            SplashRequestListener sRequestCallback = new SplashRequestListener(adxImpBean, mInternalListener);
            AdxSplash.SplashNetRequest.loadByNet(mPlacementId, sRequestCallback,mRequestId,requestType);
        }
    }


    // =============================================================================================


    /**
     * 设置广告位id
     */
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mSplash.setPlacementId(placementId);
    }
    /**
     * 设置请求类型
     * @param requestType
     */
    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }
    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        this.isDefaultAd = isDefaultAd;
        mSplash.setDefaultAd(isDefaultAd);
    }

    /**
     * 是否允许跳过
     */
    public void setAllowSkipOut(boolean flag) {
        mIsAllowSkip = flag;
    }

    /**
     * 设置广告的请求
     */
    public void setListener(AdListener listener) {
        this.mListener = listener;
    }

    public void setRequestId(String requestId){
        mRequestId = requestId;
    }

    public void setAdRequest(AdRequest request){
        if (request == null) {
            return;
        }
        this.mAdRequest = request;
        if (!TextUtils.isEmpty(request.getRequestId())) {
            this.mRequestId = request.getRequestId();
        }
        if (!TextUtils.isEmpty(request.getPlacementId())) {
            this.mPlacementId = request.getPlacementId();
        }
        if (request.getListener() != null) {
            this.mListener = request.getListener();
        }
        if (request.getRequestType() != -1) {
            this.requestType = request.getRequestType();
        }
        this.isDefaultAd = request.isDefault();
    }

    public AdRequest getAdRequest(){
        return mAdRequest;
    }

    /**
     * 显示广告 --> 在广告素材加载成功之后调用
     */
    public void show() {
        if (mContext == null || mAdBean == null || mSplashImage == null) {
            AdLogUtil.Log().d(SPLASH_TAG,"contex is null or mAdBean is null");
            return;
        }

        // 显示图片
        mSplashImage.loadImage(Constants.ImageLoadType.IMAGE_RAM_INCLUDED);
    }

    /**
     * 设置"跳过" 监听
     */
    public void setSkipListener(OnSkipListener listener) {
        this.mSkipListener = listener;
    }

    /**
     * 销毁
     */
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mSplashImage != null) {
                    mSplashImage.destroy();
                }
                mSplash.destroy();
                if (mCountTimeView != null) {
                    mCountTimeView.cancel();
                    mCountTimeView.setCountDownTimerListener(null);
                    mCountTimeView = null;
                }
                mViewGroup.removeAllViews();
                mListener = null;
                AdLogUtil.Log().d(SPLASH_TAG,"TranSplash，destroy");
            }
        });
    }

    public Context context() {
        return mContext;
    }

    AdsDTO splashItem() {
        return mAdBean;
    }

    InternalAdListener adListener() {
        return mInternalListener;
    }

    String placementId() {
        return mPlacementId;
    }


    // =============================================================================================


    /**
     * 所有素材准备好了之后 就可以开始显示广告了
     */
    void fillSplash() {
        View renderView = null;
        if (mSplashImage != null) {
            renderView = mSplashImage.getView();
        }
        if (renderView == null) {
            AdLogUtil.Log().d(SPLASH_TAG,"Splash view or bg view is null");
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT,
                FrameLayout.LayoutParams.MATCH_PARENT);
        if (renderView.getParent() != null) {
            ((ViewGroup) renderView.getParent()).removeView(renderView);
        }
        mViewGroup.addView(renderView, layoutParams);
        addAdMark(); //ad 角标
        addAdMark2(); //ad 角标
        mViewGroup.postDelayed(new Runnable() {
            @Override
            public void run() {
                addSkipView();  //skip 标识
            }
        }, 1000);

    }

    /**
     * 添加广告标识
     */
    private void addAdMark() {
        ImageView imageView = new ImageView(mContext);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageView.setId(R.id.splash_ad);
        imageView.setImageResource(R.drawable.hisavana_ad_big);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(
                mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_13),
                mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_12)
        );
        int layoutDirection = imageView.getLayoutDirection();
        if (layoutDirection == LAYOUT_DIRECTION_LTR) {
            layoutParams.setMarginEnd(mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16));
        } else {
            layoutParams.setMarginStart(mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16));
        }
        layoutParams.bottomMargin = mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16);
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_END);
        mViewGroup.addView(imageView, layoutParams);
    }

    /**
     * 先弄个占位的
     */
    private void addAdMark2() {
        mAdBean.setACReady(true);
        AdChoicesView choicesView = mSplash.getAdChoicesView(mContext, mAdBean);
        if (mViewGroup.indexOfChild(choicesView) < 0) {
            if (choicesView != null) {
                RelativeLayout.LayoutParams params;
                if (choicesView.getLayoutParams() != null) {
                    params = (RelativeLayout.LayoutParams) choicesView.getLayoutParams();
                } else {
                    params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                }
                params.height = mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_12);
                params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                int layoutDirection = choicesView.getLayoutDirection();
                if (layoutDirection == LAYOUT_DIRECTION_LTR) {
                    params.addRule(RelativeLayout.START_OF, R.id.splash_ad);
                } else {
                    params.addRule(RelativeLayout.END_OF, R.id.splash_ad);
                }
                params.bottomMargin = mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16);
                mViewGroup.addView(choicesView, params);
            }
        }
    }

    /**
     * 添加跳过按钮
     */
    private void addSkipView() {
        mCountTimeView = new CountTimeView(mContext);
        mCountTimeView.setStartTime(mAdBean.getSplashCountTime());
        mCountTimeView.setCountDownTimerListener(new CountTimeView.CountDownTimerListener() {
            @Override
            public void onStart() {

            }

            @Override
            public void onFinish() {
                if (mSkipListener != null && !mSplashClicked) {
                    mSkipListener.onTimeEnd();
                }
            }

            @Override
            public void onClick() {
                if (mCountTimeView != null) {
                    mCountTimeView.cancel();
                }
                if (mSkipListener != null) {
                    mSkipListener.onClick();
                }
            }
        });
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        int layoutDirection = mCountTimeView.getLayoutDirection();
        if (layoutDirection == LAYOUT_DIRECTION_LTR) {
            layoutParams.setMarginEnd(mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_margin_start));
        } else {
            layoutParams.setMarginStart(mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_margin_start));
        }
        layoutParams.topMargin = mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_margin_top);
        final int width = mContext.getResources().getDimensionPixelSize(R.dimen.ad_skip_view_width);
        final int height = mContext.getResources().getDimensionPixelOffset(R.dimen.ad_skip_view_height);
        layoutParams.width = width;
        layoutParams.height = height;
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_END);
        mViewGroup.addView(mCountTimeView, layoutParams);
    }

    /**
     * ad_close ad
     *
     * @param duration 动画时间
     */
    private void dismissSplash(long duration) {
        final AlphaAnimation localAlphaAnimation = new AlphaAnimation(1.0F, 0.0F);
        localAlphaAnimation.setDuration(duration);
        localAlphaAnimation.start();
        mViewGroup.postDelayed(new Runnable() {
            @Override
            public void run() {
                mViewGroup.removeAllViews();
            }
        }, duration);

    }

    public boolean isAdValid() {
        return AdsConfig.isAdValid(mAdBean);
    }

    public double getBidPrice() {
        if (mAdBean != null) {
            return mAdBean.getFirstPrice();
        }
        return 0;
    }
    public String getDefaultAdRequestId() {
        if (mAdBean != null) {
            return mAdBean.getRid();
        }
        return "";
    }
    public void setSecondPrice(double secondPrice){
        if (mAdBean != null) {
            mAdBean.setSecondPrice(secondPrice);
        }
    }
}
