package com.cloud.hisavana.sdk.sign;

import android.util.Base64;
import android.util.Log;

import com.cloud.hisavana.sdk.common.AdLogUtil;

import java.nio.charset.StandardCharsets;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BasicSigner extends Signer {

    private final String secret;

    public BasicSigner(String secret) {
        this.secret = secret;
    }

    @Override
    public String sign(SignAlgorithm algo, String content) {
        try {
            Mac hmac = Mac.getInstance(algo.name());
            hmac.init(new SecretKeySpec(Base64.decode(secret, Base64.NO_WRAP), algo.name()));
            byte[] md5Result = hmac.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeToString(md5Result, Base64.NO_WRAP);
        } catch (Exception e) {
            e.printStackTrace();
            AdLogUtil.Log().e(Log.getStackTraceString(e));
        }

        return "";
    }
}
