/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.a;
import com.cloud.hisavana.sdk.common.util.BitmapUtil;
import com.cloud.hisavana.sdk.common.util.FileUtil;
import com.cloud.hisavana.sdk.common.util.MD5Utils;
import com.transsion.core.CoreUtil;
import java.io.File;

public class BlurBgUtils {
    private static final String BG_PATH = "ssp_splash_blurBg";

    public static boolean checkBlurBgExist(String url) {
        try {
            return new File(BlurBgUtils.getBlurBgFileName(url)).exists();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static String saveBlurBgToFile(Bitmap bitmap, String url) throws Exception {
        try {
            long start = System.currentTimeMillis();
            Bitmap blurBitmap = BlurBgUtils.doBlur(bitmap);
            long currentTimeMillis = System.currentTimeMillis();
            long blurTime = currentTimeMillis - start;
            File cacheDir = new File(BlurBgUtils.getBlurBgPath());
            String fileName = MD5Utils.toMd5(url);
            FileUtil.saveBitmapToFile(cacheDir, blurBitmap, fileName);
            blurBitmap.recycle();
            a.a().d("ssp", "BlurBgUtils saveBlurBgToFile save success, blur time = " + blurTime + ", save time = " + (System.currentTimeMillis() - currentTimeMillis) + ", url = " + url);
            return BlurBgUtils.getBlurBgPath() + File.separator + fileName;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static boolean deleteBlurBgFromFile(String url) {
        if (BlurBgUtils.checkBlurBgExist(url)) {
            try {
                File file = new File(BlurBgUtils.getBlurBgFileName(url));
                boolean delete = file.delete();
                if (delete) {
                    a.a().d("ssp", "BlurBgUtils deleteBlurBgFromFile delete success, url = " + url);
                }
                return delete;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }

    public static Bitmap doBlur(Bitmap bitmap) {
        return BitmapUtil.doBlur(bitmap, 6, false);
    }

    public static Bitmap getBlurBgBitmap(String url) {
        if (!TextUtils.isEmpty((CharSequence)url) && BlurBgUtils.checkBlurBgExist(url)) {
            a.a().d("ssp", "BlurBgUtils getBlurBgBitmap bitmap exist, no need to blur again, url = " + url);
            return BitmapFactory.decodeFile((String)BlurBgUtils.getBlurBgFileName(url));
        }
        return null;
    }

    public static String getBlurBgFileName(String url) {
        return BlurBgUtils.getBlurBgPath() + MD5Utils.toMd5(url);
    }

    public static String getBlurBgPath() {
        return CoreUtil.getContext().getCacheDir().getAbsolutePath() + File.separator + BG_PATH + File.separator;
    }

    public static interface OnBlurFinishCallback {
        public void onBlurFinish();
    }
}

