package com.cloud.hisavana.sdk.ad.base;
/* Top Secret */

import static com.cloud.hisavana.sdk.common.activity.TAdWebFormsActivity.SUBMIT_COUNT;
import static com.cloud.hisavana.sdk.common.constant.Constants.HTTP_TIME_OUT.TIMEOUT_IN_MILLIONS;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.common.activity.TAdExposureActivity;
import com.cloud.hisavana.sdk.common.activity.TAdWebFormsActivity;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.tracking.TrackingUtil;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.util.SensitiveUtil;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.ViewJson;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.tmc.vuid.VUID;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.cache.IDiskCache;
import com.transsion.http.cache.SafeKeyGenerator;
import com.transsion.http.impl.StringCallback;
import com.transsion.http.util.StorageUtils;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;


/**
 * 广告封装工具类
 *
 * @author $韦明微
 * @data 2016/11/25
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class PlatformUtil {

    private static TaNativeInfo extTAd(AdsDTO adItem) {

        TaNativeInfo nativeInfo = new TaNativeInfo();

        // 埋点用的
        nativeInfo.adItem = adItem;

        if (adItem == null || adItem.getNativeObject() == null) {
            nativeInfo = null;
            return nativeInfo;
        }

        try {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            adItem.setUuid(uuid);
            nativeInfo.uuid = uuid;
            nativeInfo.setSequenceId(String.valueOf(adItem.getId()));
            nativeInfo.setVer(adItem.getNativeObject().getVersion());
            nativeInfo.setCtatext(adItem.getNativeObject().getButtonTxt(adItem.getInstallApk()));
            nativeInfo.setDescription(adItem.getNativeObject().getDescriptionTxt());
            nativeInfo.setTitle(adItem.getNativeObject().getTitleTxt());
            //没用到
            nativeInfo.setPrice(String.valueOf(adItem.getFirstPrice()));
            nativeInfo.setBidPrice(adItem.getFirstPrice());
            nativeInfo.setOfflineAd(adItem.isOfflineAd());
            nativeInfo.setRating(String.valueOf(adItem.getNativeObject().getRating()));
            nativeInfo.setRequestId(adItem.getRid());

            AdImage image = new AdImage();
            if (adItem.getNativeObject().getMainImages() != null
                    && adItem.getNativeObject().getMainImages().size() > 0
                    && adItem.getNativeObject().getMainImages().get(0) != null) {
                image.setH(adItem.getNativeObject().getMainImages().get(0).getHeight());
                image.setW(adItem.getNativeObject().getMainImages().get(0).getWidth());
                image.setImgUrl(adItem.getNativeObject().getMainImages().get(0).getUrl());
            } else {
                image.setH(0);
                image.setW(0);
                image.setImgUrl("");
            }
            nativeInfo.setImage(image);

            //icon
            AdImage icon = new AdImage();
            icon.setH(adItem.getNativeObject().getLogo() == null ? 0 : adItem.getNativeObject().getLogo().getHeight());
            icon.setW(adItem.getNativeObject().getLogo() == null ? 0 : adItem.getNativeObject().getLogo().getWidth());
            icon.setImgUrl(adItem.getNativeObject().getLogo() == null ? "" : adItem.getNativeObject().getLogo().getUrl());
            nativeInfo.setIconImage(icon);

            //adchoice
            nativeInfo.acImageUrl = adItem.getAdChoiceImageUrl() == null ? "" : adItem.getAdChoiceImageUrl();
            nativeInfo.acClickUrl = adItem.getAdChoiceClickUrl() == null ? "" : adItem.getAdChoiceClickUrl();
            //1.5版本  native改成模板渲染
            nativeInfo.advSeatType = adItem.getAdvSeatType();
            nativeInfo.materialStyle = adItem.getMaterialStyle();
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
            nativeInfo = null;
        }
        return nativeInfo;
    }

    /**
     * 查找对应的adBean
     *
     * @param nativeInfo
     * @return AdBean
     */
    public static AdsDTO getAdBean(TaNativeInfo nativeInfo) {
        if (nativeInfo != null) {
            if(nativeInfo.adItem!=null){
                nativeInfo.adItem.setACReady(nativeInfo.isACReady);
            }
            return nativeInfo.adItem;
        }
        return null;
    }

    /**
     * 获取多个Native的信息
     */
    public static List<TaNativeInfo> getTadNativeInfoList(List<AdsDTO> items) {
        if (items == null) {
            return null;
        }
        List<TaNativeInfo> infoList = new ArrayList<>();
        for (AdsDTO adItem : items) {
            if (adItem == null) {
                continue;
            }
            TaNativeInfo nativeInfo = extTAd(adItem);
            if (nativeInfo == null) {
                continue;
            }
            if (SensitiveUtil.isSensitive(nativeInfo)) {
                continue;
            }
            infoList.add(nativeInfo);
        }
        return infoList;
    }

    /**
     * 所有的点击事件都走这一个方法
     * if(下载类应用){
     * if(deelink不是空){
     * 打开deeplink；；
     * }else {
     * 打开目标应用；
     * }
     * }
     * 打开landingpage；
     */
    public static boolean startLandingPage(Context context, AdsDTO adItem, DownUpPointBean pointBean) {

        if (context == null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "context is null");
            return false;
        }
        final boolean newTask = (context == context.getApplicationContext());

        if (adItem == null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "adItem is null");
            return false;
        }

        // 第三方归因服务 两个事件 用一个 clickid
        String clickid = TrackingUtil.getTriggerId();
        adItem.setClickid(clickid);
        String landingUrl = adItem.getClickUrl();
        AdLogUtil.Log().d(CommonLogUtil.TAG, "landing url is : " + landingUrl);

        // 第三方归因服务 只要点击了 就发送请求  adItem 判空 外面已经判断了
        TrackingManager.clickTrackingUrlsExposure(adItem.getClickTrackingUrls(), clickid);
        //判断是否存在viewJson
        ViewJson data = adItem.getViewJsonData();
        if (data != null && data.getDialogType() == 1) {
            ViewJson.DialogJson dialogJson = data.getDialogJson();
            if(adItem.isOfflineAd() && dialogJson!=null && !TextUtils.isEmpty(dialogJson.getUrl())){
                startFormWeb(context, dialogJson.getUrl(), "", adItem, pointBean);
                return true;
            }else{
                if(data.getFormPath()!=null){
                    File file = new File(data.getFormPath());
                    if (dialogJson != null && !TextUtils.isEmpty(dialogJson.getUrl()) && file.exists()) {
                        startFormWeb(context, dialogJson.getUrl(), file.getPath(), adItem, pointBean);
                        return true;
                    }
                }

            }
        }
        //StoreDeeplink不为空
        if (adItem.getStoreDeeplink() != null && adItem.getStoreDeeplink().size() > 0) {
            Intent intent = new Intent();
            for (String linkUrl : adItem.getStoreDeeplink()) {
                if (TextUtils.isEmpty(linkUrl)) continue;
                try {
                    //打开短信编辑页面，带内容，例子：smsto:10086:%E7%A7%8D%E6%96%B9%E6%B3%95
                    if (linkUrl.startsWith(Constants.SMSTO) && linkUrl.split(":").length > 2) {
                        //first-smsto:  number-10086  sms_body-发送内容
                        String first = linkUrl.substring(0, linkUrl.indexOf(":") + 1);
                        String first_remain = linkUrl.substring(linkUrl.indexOf(":") + 1);
                        int index = first_remain.indexOf(":");
                        String number = first_remain.substring(0, index);
                        String sms_body = URLDecoder.decode(first_remain.substring(index + 1), "UTF-8");
                        linkUrl = first + number;
                        intent.putExtra(Constants.SMS_BODY, sms_body);
                        AdLogUtil.Log().d(CommonLogUtil.TAG, "linkUrl:" + linkUrl + ",sms_body:" + sms_body);
                    }
                } catch (Exception e) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "deeplink SMSTO process error");
                }

                Uri content_uri = Uri.parse(linkUrl);
                intent.setData(content_uri);
                intent.setAction("android.intent.action.VIEW");
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                boolean flag = true;
                try {
                    context.startActivity(intent);
                    //设置首次
                    adItem.setDeepLinkUrlFirst(linkUrl);
                } catch (Throwable e) {
                    AdLogUtil.Log().e("deepLinkUrl error - " + Log.getStackTraceString(e));
                    flag = false;
                }
                if (flag) {
                    //上报deeplink事件
                    AthenaTracker.trackDeeplink(adItem);
                    //服务端点击上报
                    TrackingManager.reportServerClick(pointBean, adItem);
                    return true;
                }
            }
        } else {
            if (!TextUtils.isEmpty(adItem.getPackageName())) {
                //deeplink为空，打开目标应用
                if (startApplicationWithPackageName(context, adItem.getPackageName(), newTask)) {
                    return true;
                }
            }
        }
        //当离线广告的时候 无H5链接（包括 form地址 静态页面地址 zip地址） 不再跳转 只展示
        if (adItem.isOfflineAd() && TextUtils.isEmpty(adItem.getOfflineH5Url())) {
            return false;
        }
        //打开landingUrl
        if (!TextUtils.isEmpty(landingUrl) && (landingUrl.startsWith("http") || landingUrl.startsWith("https://"))) {
            if (AdxServerConfig.isForAutoTest()) {
                startPageByBrowser(context, landingUrl);
            } else {
                startPageByWebView(context, adItem, newTask, true, pointBean);
            }
            return true;
        } else {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "Both deepLinkUrl and landing page is null");
            return false;
        }

    }

    /**
     * 通过包名或类名启动另一个APP
     *
     * @param context
     * @param packagename
     */
    private static boolean startApplicationWithPackageName(Context context, String packagename, boolean newTask) {
        try {
            // 通过包名获取此APP详细信息，包括Activities、services、versioncode、name等等
            PackageInfo packageinfo = context.getPackageManager().getPackageInfo(packagename, 0);
            if (packageinfo == null) {
                return false;
            }

            // 创建一个类别为CATEGORY_LAUNCHER的该包名的Intent
            Intent resolveIntent = new Intent(Intent.ACTION_MAIN, null);
            resolveIntent.addCategory(Intent.CATEGORY_LAUNCHER);
            resolveIntent.setPackage(packageinfo.packageName);

            // 通过getPackageManager()的queryIntentActivities方法遍历
            List<ResolveInfo> resolveinfoList = context.getPackageManager()
                    .queryIntentActivities(resolveIntent, 0);
            if (resolveinfoList == null || resolveinfoList.size() == 0) {
                return false;
            }
            ResolveInfo resolveinfo = resolveinfoList.iterator().next();
            if (resolveinfo != null) {
                // packagename = 参数packname
                String packageName = resolveinfo.activityInfo.packageName;
                // 这个就是我们要找的该APP的LAUNCHER的Activity[组织形式：packagename.mainActivityname]
                String className = resolveinfo.activityInfo.name;
                // LAUNCHER Intent
                Intent intent = new Intent(Intent.ACTION_MAIN);
                intent.addCategory(Intent.CATEGORY_LAUNCHER);
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                // 设置ComponentName参数1:packagename参数2:MainActivity路径
                ComponentName cn = new ComponentName(packageName, className);

                intent.setComponent(cn);
                context.startActivity(intent);
                return true;
            }
            return false;
        } catch (Exception e) {
            AdLogUtil.Log().e(CommonLogUtil.TAG, "PlatformUtil" + Log.getStackTraceString(e));
            return false;
        }
    }

    /**
     * 用于adchoices
     */
    public static void startPageByWebView(Context context, AdsDTO adsDTO) {
      //离线广告adchoices不跳转
        if (!adsDTO.isOfflineAd()){
            startPageByWebView(context, adsDTO, true, false, null);
        }
    }

    /**
     * 广告的点击 和 adChoices都用的同一个
     *
     * @param context
     * @param newTask
     * @param isAdClick
     */
    public static void startPageByWebView(Context context, AdsDTO adItem, boolean newTask, boolean isAdClick, DownUpPointBean pointBean) {
        AdLogUtil.Log().d(CommonLogUtil.TAG, "Start page with WebView.");
        try {
            if (adItem != null && !adItem.isOfflineAd()) {
                VUID.Companion.getToken(context);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Intent intent = new Intent(context, TAdExposureActivity.class);
        Bundle bundle = new Bundle();
        bundle.putSerializable(TAdExposureActivity.TAG_AD, adItem);
        if (isAdClick) {
            bundle.putSerializable("pointBean", pointBean);
            bundle.putBoolean("isAdClick", true);
            adItem.setClickUrlTs(System.currentTimeMillis());
        }
        intent.putExtras(bundle);
        if (newTask) {
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }


    /**
     * 用浏览器 打开webView
     *
     * @param context
     * @param url
     */
    public static void startPageByBrowser(Context context, String url) {
        boolean isOk = startPageWithChrome(context, url, true);
        if (!isOk) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "Start page with Chrome Browser failed,Start default Browser.");
            startDefaultBrowser(context, url, true);
        }
    }

    private static boolean startDefaultBrowser(Context context, String landingUrl, boolean newTask) {
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri content_uri = Uri.parse(landingUrl);
            intent.setData(content_uri);
            if (newTask) {
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            }
            context.startActivity(intent);
            return true;
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
            return false;
        }
    }

    /**
     * 开启activity
     *
     * @param context
     * @param landingUrl
     */
    private final static String DEFAULT_BROWSER_PACKAGE = "com.android.chrome";

    private static boolean startPageWithChrome(Context context, String url, boolean newTask) {
        boolean isOk = true;
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            intent.setPackage(DEFAULT_BROWSER_PACKAGE);
            if (newTask) {
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            }
            context.startActivity(intent);
        } catch (Throwable e1) {
            isOk = false;
        }
        return isOk;
    }

    /**
     * 跳转form表单
     *
     * @param context
     * @param formUrl
     */
    private static void startFormWeb(Context context, String formUrl, String formPath, AdsDTO adsDTO, DownUpPointBean pointBean) {
        if (TextUtils.isEmpty(formUrl)) {
            return;
        }
        Intent intent = new Intent(context, TAdWebFormsActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION | Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(TAdWebFormsActivity.AD_FORM_URL, formUrl);
        intent.putExtra(TAdWebFormsActivity.AD_FORM_FILE_PATH, formPath);
        intent.putExtra(TAdWebFormsActivity.AD_FORM_FILE_PATH, formPath);
        intent.putExtra(TAdWebFormsActivity.AD_FORM_DTO, adsDTO);
        intent.putExtra(TAdWebFormsActivity.AD_FORM_POINT, pointBean);
        context.startActivity(intent);
    }

    /**
     * 通过url来获取本地缓存的file
     * 子线程调用
     *
     * @param url
     * @return
     */
    public static String getCacheFilePath(String url, boolean isOfflineAd) {
        if (TextUtils.isEmpty(url)) {
            return "";
        }
        RequestCall requestImgCall = HttpClient.image(CoreUtil.getContext())         //必须方法体，需要传入context
                .cache(true)
                .useOffLineCache(isOfflineAd)
                .url(url)           //必须方法体，传入图片url
                .build();
        IDiskCache iDiskCacheImg = requestImgCall.getDiskCache();
        ImageURL imageURL = new ImageURL(url);
        File file = iDiskCacheImg.get(imageURL);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        return "";
    }

    /**
     * 判断文件是否存在  不耗时
     * @param url
     * @param isOfflineAd
     * @return
     */
    public static boolean isFileExist(String url, boolean isOfflineAd) {
        if (TextUtils.isEmpty(url)) {
            return false;
        }
        //获取广告素材保存的路径
        File directory = isOfflineAd ? StorageUtils.getOfflineCacheDirectory(CoreUtil.getContext(),true)
                : StorageUtils.getCacheDirectory(CoreUtil.getContext());
        if(directory == null){
            return false;
        }
        //根据url获取素材的文件名
        ImageURL imageURL = new ImageURL(url);
        SafeKeyGenerator keyGenerator = new SafeKeyGenerator();
        //命名规则".0"参考代码：DiskLruCache内部类Entry的构造方法
        String fileName = keyGenerator.getSafeKey(imageURL)+".0";
        //判断文件是否存在
        File file = new File(directory,fileName);
        return file.exists();
    }

    /**
     * 下载form类型广告的H5
     *
     * @param nativeInfos
     */
    public static void downLoadFormUrl(List<TaNativeInfo> nativeInfos) {
        if (nativeInfos == null || nativeInfos.isEmpty()) {
            return;
        }
        for (TaNativeInfo nativeInfo : nativeInfos) {
            if (nativeInfo == null || nativeInfo.adItem == null) {
                continue;
            }
            downLoadFormUrl(nativeInfo.adItem);
        }
    }

    /**
     * 下载对应广告的form页面
     *
     * @param adsDTO
     */
    public static void downLoadFormUrl(final AdsDTO adsDTO) {
        if (adsDTO == null) {
            return;
        }
        if (TextUtils.isEmpty(adsDTO.getViewJson())) {
            return;
        }
        try {
            final ViewJson viewJson = adsDTO.getViewJsonData();
            if(viewJson!=null && !TextUtils.isEmpty(viewJson.getFormPath())){
                File file = new File(viewJson.getFormPath());
                if (file.isFile() && file.exists()) {
                    return;
                }
            }
            if (viewJson != null && viewJson.getDialogType() == 1) {
                ViewJson.DialogJson dialogJson = viewJson.getDialogJson();
                if (dialogJson != null && !TextUtils.isEmpty(dialogJson.getUrl())) {
                    new DownLoadRequest().setAdsDTO(adsDTO, AthenaTracker.M_TYPE_AD_WEB)
                            .setUrl(dialogJson.getUrl())
                            .setFetch(true)
                            .setPreCache(Constants.ImageLoadType.IMAGE_DISK_INCLUDED)
                            .setListener(new DrawableResponseListener() {
                                @Override
                                public void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean) {
                                    viewJson.setFormPath(mediaBean == null ? "" : mediaBean.getFilePath());
                                    adsDTO.setViewJson(GsonUtil.toJson(viewJson));
                                }

                                @Override
                                protected void onRequestError(TaErrorCode adError) {

                                }
                            }).netRequestPreExecute();
                }
            }
        } catch (Exception e) {
        }
    }

    /**
     * 在线广告提交离线广告数据
     *
     * @param formParams
     * @param netCount
     */
    public static void submitForm(final String formParams, final int netCount) {
        AdLogUtil.netLog("post json ===>" + formParams);
        AdLogUtil.netLog("post url ===>" + AdxServerConfig.getFormServerUrl() + Constants.HOST.FORM_URL);
        HttpClient.postJson()  //必须方法体
                .log(AdManager.isDebug())
                .sslSocketFactory(null)
                .connectTimeout(TIMEOUT_IN_MILLIONS)   //网络连接超时时间，单位毫秒，非必须默认10s
                .readTimeout(TIMEOUT_IN_MILLIONS)      //读取数据超时时间，单位毫秒，非必须默认10s
                .content(formParams) //必须方法体，上传的String类型的数据文本，目前只提供上传String接口
                .connectTimeout(TIMEOUT_IN_MILLIONS)   //网络连接超时时间，单位毫秒，非必须默认10s
                .readTimeout(TIMEOUT_IN_MILLIONS)      //读取数据超时时间，单位毫秒，非必须默认10s
                .addHeader("Accept-Timezone", "UTC")
                .addHeader("x-tr-devtype","h5")
                .addHeader("x-tr-region","CN")
                .url(AdxServerConfig.getFormServerUrl() + Constants.HOST.FORM_URL)
                .build()
                .execute(new StringCallback(true) {
                             @Override
                             public void onSuccess(final int statusCode, String response) {
                                 AdLogUtil.Log().d(CommonLogUtil.TAG, "sumbit form success----->" + statusCode);
                             }

                             @Override
                             public void onFailure(int statusCode, String response, Throwable throwable) {
                                 AdLogUtil.Log().d(CommonLogUtil.TAG, "sumbit form failure----->code: " + statusCode + "  message: " + response);
                                 int count = netCount + 1;
                                 if (count < SUBMIT_COUNT) {
                                     submitForm(formParams, count);
                                 }
                             }
                         }
                );
    }

    public static AdChoicesView getAdChoicesView(Context context, final AdsDTO adsDTO) {
        if (adsDTO != null && adsDTO.getACReady() != null && adsDTO.getACReady()) {
            AdChoicesView adChoicesView = new AdChoicesView(context);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ScreenUtil.dip2px(12), ScreenUtil.dip2px(12));
            adChoicesView.setLayoutParams(params);
            ImageDownloadHelper.loadImageView(adsDTO.getAdChoiceImageUrl(), adChoicesView, adsDTO, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, null);
            adChoicesView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    PlatformUtil.startPageByWebView(CoreUtil.getContext(), adsDTO);
                }
            });
            return adChoicesView;
        }
        return null;
    }
}
