package com.cloud.hisavana.sdk.api.adx;


import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.internal.interstitial.TranInterstitial;

/**
 * Created by jianbing.yu on 2019/2/22.
 *
 * 媒体入口
 */
public class TInterstitial {

    private static final String TAG = "InterstitialApi";
    protected TranInterstitial mInterstitial = null;

    /**
     * 构造方法
     *
     * @param placementId
     */
    public TInterstitial(String placementId) {
        mInterstitial = new TranInterstitial(placementId);
    }

    /**
     * 设置placementid
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        mInterstitial.setPlacementId(placementId);
    }

    public void setListener(AdListener listener) {
        mInterstitial.setListener(listener);
    }

    public void setRequest(AdRequest aAdRequest){
        mInterstitial.setAdRequest(aAdRequest);
    }


    /**
     * 提供接口告知媒体填充的广告是属于离线还是在线广告
     * @return 1 离线广告 0 在线广告 -1无填充
     */
    public int getFillAdType(){return mInterstitial.getFillAdType();}

    public void loadAd(){
        mInterstitial.loadAd();
    }

    public void show() {
        mInterstitial.show();
    }

    public boolean isReady() {
        return mInterstitial.isReady();
    }

    public void destroy() {
        mInterstitial.destroy();
    }

    /**
     * 设置triggerid，用于埋点
     * @param triggerId
     */
    public void setTriggerId(String triggerId){
        mInterstitial.setTriggerId(triggerId);
    }
}
