package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.View;
import android.view.ViewGroup;

import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.api.view.TNativeView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.internal.native_.TranNative;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/2/22.
 */
public class TNative {

    private static final String TAG = "NativeApi";
    protected final TranNative mNative;


    // =============================================================================================


    public TNative(String placementId) {
        mNative = new TranNative(placementId);
    }


    // =============================================================================================


    public void setPlacementId(String placementId) {
        mNative.setPlacementId(placementId);
    }

    /**
     * 设置一次加载多少条
     *
     * @param adCount
     */
    public void setAdCount(int adCount) {
        mNative.setAdCount(adCount);
    }

    public void setListener(@NonNull AdListener listener) {
        mNative.setListener(listener);
    }

    public void loadAd() {
        mNative.loadAd();
    }

    public boolean isReady(TaNativeInfo nativeInfo){
        return mNative.isReady(nativeInfo);
    }

    /**
     * 给广告相关的View注册监听事件
     */
    public void registerViews(@NonNull ViewGroup view, List<View> adContains, TaNativeInfo taNativeInfo) {
        mNative.registerViews(view, adContains, taNativeInfo);
    }

    /**
     * 媒体端自己定义AdChoicesView的位置
     *
     * @param context
     * @param taNativeInfo
     * @return
     */
    public AdChoicesView getAdChoicesView(Context context, TaNativeInfo taNativeInfo) {
        return mNative.getAdChoicesView(context, taNativeInfo);
    }

    /**
     * 释放资源
     */
    public void destroy() {
        mNative.destroy();
    }
}