package com.cloud.hisavana.sdk.api.adx.innerapi;

import android.content.Context;
import android.util.AttributeSet;

import com.cloud.hisavana.sdk.api.adx.TBannerView;
import com.cloud.hisavana.sdk.api.request.AdRequest;

public class TInnerBannerView extends TBannerView {
    public TInnerBannerView(Context context, String placementId) {
        super(context, placementId);
    }

    public TInnerBannerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TInnerBannerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    /**
     * 设置请求类型
     * @param requestType
     */
    public void setRequestType(int requestType) {
        mBanner.setRequestType(requestType);
    }

    public void setRequest(AdRequest aRequest){
        mBanner.setAdRequest(aRequest);
    }

    public void setScheduleTime(int scheduleTime){
        mBanner.setScheduleTime(scheduleTime);
    }
    public void loadAd(String requestId) {
        mBanner.loadAd(requestId);
    }

    public double getBidPrice(){
        return mBanner.getBidPrice();
    }
    public void setSecondPrice(double secondPrice){
        mBanner.setSecondPrice(secondPrice);
    }

    /**
     * 设置是否是离线请求
     * @param isOfflineAd
     */
    public void setOfflineAd(boolean isOfflineAd){
        mBanner.setOfflineAd(isOfflineAd);
    }

    /**
     * 设置triggerid，用于埋点
     * @param triggerId
     */
    public void setTriggerId(String triggerId){
        mBanner.setTriggerId(triggerId);
    }

    public boolean isAdValid() {
        return mBanner.isAdValid();
    }

}
