package com.cloud.hisavana.sdk.api.config;
/* Top Secret */


import static com.cloud.sdk.commonutil.util.CommonLogUtil.MEASURE_TAG;
import static com.cloud.sdk.commonutil.util.CommonLogUtil.NET_LOG;
import static com.cloud.sdk.commonutil.util.CommonLogUtil.TAG;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.tranmeasure.SspActivityLifecycleCallbacks;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.manager.ConfigManager;
import com.cloud.hisavana.sdk.manager.NetStateManager;
import com.cloud.sdk.commonutil.constant.Constants;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.tmc.vuid.VUID;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;

/**
 * 广告管理器
 *
 * @author peng.sun
 * @date 2016/6/30.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public final class AdManager {

    private static AdConfig adConfig;
    public static String AppId;

    /**
     * 是否是测试广告
     */
    public static boolean isTestRequest() {
        if (adConfig != null) {
            return adConfig.testRequest;
        }
        return false;
    }

    public static boolean isDebug() {
        if (adConfig != null) {
            return adConfig.isDebug;
        }
        return false;
    }

    public static void init(Context context, @NonNull final AdConfig config) {
        CoreUtil.init(context);
        init(config);
    }

    /**
     * 初始化
     *
     * @param config
     */
    public static void init(@NonNull final AdConfig config) {
        Preconditions.checkIsOnMainThread();
        if (adConfig != null || config == null) {
            return;
        }
        //打印网络请求的日志
        if (!config.isDebug) {
            NET_LOG.getBuilder().setLogSwitch(Log.isLoggable("AD_NET_LOG", Log.DEBUG));
        }
        if (!config.isDebug) {
            config.isDebug = Log.isLoggable("TA_SDK", Log.DEBUG) || Log.isLoggable("ADSDK", Log.DEBUG);
        }
        adConfig = config;
        //提前加载gaid
        DeviceUtil.getGAId();
        AthenaTracker.init(adConfig.isDebug,CoreUtil.getContext());
        AdxPreferencesHelper.getInstance().putInt(com.cloud.hisavana.sdk.common.constant.Constants.IS_DEBUG,
                adConfig.isDebug ? com.cloud.hisavana.sdk.common.constant.Constants.InitType.DEBUG
                        : com.cloud.hisavana.sdk.common.constant.Constants.InitType.RELEASE);
        //聚合的日志开关
        AdLogUtil.Log().setLogSwitch(adConfig.isDebug);
//        AdxServerConfig.setAppModle(adConfig.isDebug ? AdxServerConfig.TEST : AdxServerConfig.APP_RELEASE);

        try {
            // 曝光测量 注册
            SspActivityLifecycleCallbacks.measureLifecycleCallbacks();
        } catch (Exception e) {
            AdLogUtil.Log().d(MEASURE_TAG, Log.getStackTraceString(e));
        }

        try {
            if (config.vidAppId != null && !config.vidAppId.isEmpty()) {
                if (CoreUtil.getContext().getApplicationContext() instanceof Application) {
                    Application application = (Application) CoreUtil.getContext().getApplicationContext();

                    new VUID.Builder(application)
                            .setTest(AdxServerConfig.getAppModle() != AdxServerConfig.RELEASE)
                            .setAppId(config.vidAppId)
                            .setPackageName(config.vidPackageName)
                            .build();
                    VUID.Companion.setUID(DeviceUtil.getGAId(), true);
                }
            }
        } catch (Exception e) {
            AdLogUtil.Log().d(TAG,Log.getStackTraceString(e));
        }

        //初始化设置离线的图片缓存大小和时长  在线默认为 100M 10天
        HttpClient.setOfflineCacheSize(Constants.OFFLINE_CACHE_SIZE);
        HttpClient.setOfflineCacheTime(Constants.OFFLINE_CACHE_TIME);
        ConfigManager.getInstance().requestCloudControl(com.cloud.hisavana.sdk.common.constant.Constants.TriggerType.TRIGGER_COLD);
        NetStateManager.registerMonitorBroadcast();
    }

    /**
     * Config 类
     */
    public final static class AdConfig {

        private boolean isDebug;
        //是否是测试广告
        private boolean testRequest = false;
        //vuid对应的appid
        private String vidAppId = "";
        //vuid对应的包名
        private String vidPackageName = "";

        public AdConfig(AdConfigBuilder builder) {
            this.isDebug = builder.isDebug;
            this.testRequest = builder.testRequest;
            this.vidAppId = builder.vidAppId;
            this.vidPackageName = builder.vidPackageName;
        }
    }

    /**
     * ConfigBuilder 类
     */
    public static final class AdConfigBuilder {
        private boolean isDebug = false;
        //是否是测试广告
        private boolean testRequest;

        //vuid对应的appid
        private String vidAppId = "";
        //vuid对应的包名
        private String vidPackageName = "";

        //打开日志
        public AdConfigBuilder setDebug(boolean debug) {
            isDebug = debug;
            CoreUtil.setDebug(isDebug);
            //聚合的日志开关
            AdLogUtil.Log().setLogSwitch(isDebug);
            //打印网络请求的日志
            NET_LOG.getBuilder().setLogSwitch(isDebug);
            return this;
        }

        public AdConfigBuilder testRequest(boolean test) {
            this.testRequest = test;
            return this;
        }

        public AdConfigBuilder setVidAppId(String vidAppId) {
            this.vidAppId = vidAppId;
            return this;
        }

        public AdConfigBuilder setAppId(String appId){
            AdManager.AppId = appId;
            return this;
        }

        public AdConfigBuilder setVidPackageName(String vidPackageName) {
            this.vidPackageName = vidPackageName;
            return this;
        }

        public AdConfig build() {
            return new AdConfig(this);
        }
    }


    // =============================================================================================


    /**
     * 优化版本切换开关 1.3.0 曝光监测优化
     * isOptimizedMeasureServices 服务端控制
     * isOptimizedMeasureClient   客户端控制
     */
    private static boolean isServicesOpenOptimizedMeasure = true;
    private static boolean isClientOpenOptimizedMeasure = false;

    public static boolean isServicesOpenOptimizedMeasure() {
        return isServicesOpenOptimizedMeasure;
    }

    public static void setServicesOpenOptimizedMeasure(boolean isOptimized) {
        AdManager.isServicesOpenOptimizedMeasure = isOptimized;
        AdLogUtil.Log().d(MEASURE_TAG, "服务端 " + (isOptimized ? " 开启 " : " 关闭 ") + " 新版本心跳检测");
    }

    public static boolean isClientOpenOptimizedMeasure() {
        return isClientOpenOptimizedMeasure;
    }

    public static void setClientOpenOptimizedMeasure(boolean isOptimized) {
        AdManager.isClientOpenOptimizedMeasure = isOptimized;
        AdLogUtil.Log().d(MEASURE_TAG, "客户端 " + (isOptimized ? " 开启 " : " 关闭 ") + " 新版本心跳检测");
    }

    /**
     * Ssp SDK 使用判断
     *
     * @return true 开启新版本心跳检测、false 关闭新版本心跳检测
     */
    public static boolean isOptimizedMeasure() {
        return isServicesOpenOptimizedMeasure && isClientOpenOptimizedMeasure;
    }


}
