package com.cloud.hisavana.sdk.api.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;

/**
 * @author Connor Lin
 * @date 2020/4/20
 */
public class TNativeView extends FrameLayout {

    private static final String TAG = TNativeView.class.getSimpleName();
    private MediaView mediaView;
    private View iconView;
    private AdChoicesView adChoicesView;
    private ImageView.ScaleType scaleType = null;
    private DownLoadRequest downLoadMedia;

    public TNativeView(@NonNull Context context) {
        this(context, null);
    }

    public TNativeView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TNativeView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setMediaView(MediaView mediaView) {
        setMediaView(mediaView, null);
    }

    public void setMediaView(MediaView mediaView, ImageView.ScaleType scaleType) {
        this.mediaView = mediaView;
        this.scaleType = scaleType;
    }

    public final void setIconView(View view) {
        this.iconView = view;
    }

    public View getIconView(){
        return iconView;
    }

    public final void setupViews(final TaNativeInfo adInfo) {
        setMediaView(adInfo);
        setIconView(adInfo);
        setAdChoice(adInfo);
    }
    public void setAdChoiceView(AdChoicesView adChoicesView) {
        if (adChoicesView == null) {
            return;
        }
        this.adChoicesView = adChoicesView;
    }
    public void inflateAdChoiceView(TaNativeInfo adInfo){
        setAdChoice(adInfo);
    }
    public void inflateMediaView(TaNativeInfo adInfo){
        setMediaView(adInfo);
    }
    public void inflateIconView(TaNativeInfo adInfo){
        setIconView(adInfo);
    }
    private void setMediaView(final TaNativeInfo adInfo) {
        if (mediaView == null || adInfo == null) {
            return;
        }
        final AdImage image = adInfo.getImage();
        if (image != null) {
            mediaView.init(image.getMime());
            if (!image.isAdImageRecycled()) {
                mediaView.setMediaView(image, scaleType == null ? ImageView.ScaleType.FIT_CENTER : scaleType);
            } else if (!TextUtils.isEmpty(image.getImgUrl())) {
                downLoadMedia = new DownLoadRequest().setListener(new DrawableResponseListener() {
                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data,  AdImage adImage) {
                        if (adImage != null && adImage.getDrawable() != null) {
                            AdLogUtil.Log().d(CommonLogUtil.TAG,"download Image Success.");
                            adInfo.setImage(adImage);
                            mediaView.setMediaView(adImage, scaleType == null ? ImageView.ScaleType.FIT_CENTER : scaleType);
                            if (!TextUtils.isEmpty(adInfo.adItem.getMaterialStyle())){
                                scaleImage(mediaView,adImage);
                            }
                        }
                    }

                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"download Image failed.");
                    }

                }).setUrl(image.getImgUrl()).setAdsDTO(image.adsDTO, AthenaTracker.M_TYPE_LARGE_IMG);
                downLoadMedia.netRequestPreExecute();
            }
        }
    }

    private void setIconView(final TaNativeInfo adInfo) {
        if (iconView == null || adInfo == null) {
            return;
        }

        final AdImage icon = adInfo.getIconImage();
        if (icon != null) {
            if (!icon.isAdImageRecycled()) {
                ((ImageView) iconView).setImageDrawable(icon.getDrawable());
            } else if (!TextUtils.isEmpty(icon.getImgUrl())) {
                DownLoadRequest downLoadRequest_ = new DownLoadRequest().setListener(new DrawableResponseListener() {
                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data,  AdImage adImage) {
                        if (adImage != null && adImage.getDrawable() != null) {
                            AdLogUtil.Log().d(CommonLogUtil.TAG,"download Image Success.");
                            adInfo.setIconImage(adImage);
                            ((ImageView) iconView).setImageDrawable(adImage.getDrawable());
                            if (!TextUtils.isEmpty(adInfo.adItem.getMaterialStyle())){
                                scaleImage(mediaView,adImage);
                            }
                        }
                    }

                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"download Image failed.");
                    }
                }).setUrl(icon.getImgUrl()).setAdsDTO(icon.adsDTO, AthenaTracker.M_TYPE_LOGO);
                downLoadRequest_.netRequestPreExecute();
            }
        }
    }

    private void setAdChoice(TaNativeInfo adInfo) {
        if (adInfo == null) {
            return;
        }
        final AdsDTO adsDTO = PlatformUtil.getAdBean(adInfo);
        if (adsDTO == null){
            return;
        }
        final String adChoiceUrl = adsDTO.getAdChoiceImageUrl();
        if (adChoicesView != null) {
            if (adsDTO.getACReady() != null && adsDTO.getACReady()) {
                ImageDownloadHelper.loadImageView(adChoiceUrl, adChoicesView, adsDTO, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, null);
                adChoicesView.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        PlatformUtil.startPageByWebView(CoreUtil.getContext(), adsDTO);
                    }
                });
            }
        }
    }


    public void destroy() {

        if (downLoadMedia != null) {
            downLoadMedia.cancelRequest();
        }

        if (mediaView != null) {
            mediaView.destroy();
        }
        removeAllViews();
    }

    public MediaView getMediaView() {
        return mediaView;
    }


    /**
     * 模版渲染 动态设置mediaview的大小
     *
     * @param mediaView
     * @param adImage
     */
    private void scaleImage(MediaView mediaView, AdImage adImage) {
        try {
            if (adImage.getDrawable().getIntrinsicWidth() != 0 && adImage.getDrawable().getIntrinsicHeight() != 0) {
                View parent = (View) mediaView.getParent();
                if (parent == null) {
                    return;
                }
                parent = (View) parent.getParent();
                if (parent == null){
                    return;
                }
                int expectedWidth = parent.getMeasuredWidth() - parent.getPaddingLeft() - parent.getPaddingRight();
                int expectedHeight = (int) (adImage.getDrawable().getIntrinsicHeight() * ((float) expectedWidth / adImage.getDrawable().getIntrinsicWidth()));

                if (mediaView.getLayoutParams() != null) {
                    mediaView.getLayoutParams().width = expectedWidth;
                    mediaView.getLayoutParams().height = expectedHeight;
                }
                AdLogUtil.Log().d(TAG, "adImage.getDrawable().getIntrinsicWidth()--" + adImage.getDrawable().getIntrinsicWidth() + "adImage.getDrawable().getIntrinsicHeight()--" + adImage.getDrawable().getIntrinsicHeight());
                AdLogUtil.Log().d(TAG, "expectedWidth--" + expectedWidth + "expectedHeight--" + expectedHeight);
            }
        } catch (Exception e) {
            AdLogUtil.Log().d(TAG, "resize MediaView error --" + e.getMessage());
        }
    }
}
