package com.cloud.hisavana.sdk.common.activity;

import static com.cloud.sdk.commonutil.util.CommonLogUtil.TAG;
import static com.cloud.sdk.commonutil.util.CommonLogUtil.TRACK_TAG;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;

import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.util.FileUtil;
import com.cloud.hisavana.sdk.common.util.UrlUtil;
import com.cloud.hisavana.sdk.common.util.WebResponseUtil;
import com.cloud.hisavana.sdk.data.bean.request.FormBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.cloud.sdk.commonutil.util.AESUtils;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.GPSTracker;
import com.cloud.sdk.commonutil.util.MitNetUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.core.utils.AppUtil;

import java.lang.ref.WeakReference;

/**
 * Created by xuhui.fang ON 2022/5/24
 */
public class TAdWebFormsActivity extends Activity {
    public static final String TAG = "TAdWebFormsActivity";
    public static final int SUBMIT_COUNT = 3;
    public static final String WEB_WINDOW_NAME = "sspWebView";
    public static final String AD_FORM_URL = "ad_web_form_url";
    public static final String AD_FORM_FILE_PATH = "ad_web_form_file_path";
    public static final String AD_FORM_DTO = "ad_web_form_dto";
    public static final String AD_FORM_POINT = "ad_web_form_point";
    public static final String HEIGHT_KEY = "height";
    public static final String FORM_ID_KEY = "formId";
    private final int DEFAULT_HEIGHT = 800;
    private AdsDTO adsDTO;
    private DownUpPointBean pointBean;
    private String formUrl;
    private String formPath;
    private int formId;
    private WebView webView;
    private FrameLayout flContent;
    private SspWebWindow mSspWebWindow;
    private long start;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        setTitle(null);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_t_ad_web_forms);
        AdLogUtil.Log().d(TAG, "展示form表单页面");
        getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        this.setFinishOnTouchOutside(false);
        flContent = findViewById(R.id.fl_content);
        start = System.currentTimeMillis();
        initData();
        initView();
        initWeb();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (flContent != null) {
            flContent.removeAllViews();
        }
        if (webView != null) {
            webView.stopLoading();
            webView.removeJavascriptInterface("");
            webView.getSettings().setJavaScriptEnabled(false);
            webView.setWebChromeClient(null);
            webView.setWebViewClient(null);
            webView.clearHistory();
            try {
                webView.freeMemory();
                webView.destroy();
            } catch (Exception e) {
            }
            webView = null;
        }
    }

    private void initData() {
        formUrl = getIntent().getStringExtra(AD_FORM_URL);
        formPath = getIntent().getStringExtra(AD_FORM_FILE_PATH);
        adsDTO = (AdsDTO) getIntent().getSerializableExtra(AD_FORM_DTO);
        pointBean = (DownUpPointBean) getIntent().getSerializableExtra(AD_FORM_POINT);
        if (TextUtils.isEmpty(formUrl)) {
            finish();
        }
        if (adsDTO!=null && !adsDTO.isOfflineAd() && TextUtils.isEmpty(formPath)) {
            finish();
        }
    }

    private void initView() {
        int height;
        String result = UrlUtil.getParamValue(HEIGHT_KEY, formUrl);
        try {
            formId = Integer.parseInt(UrlUtil.getParamValue(FORM_ID_KEY, formUrl));
            height = Integer.parseInt(result);
            height = height == 0 ? DEFAULT_HEIGHT : dip2px(height);
            height = Math.min(height, (CoreUtil.getContext().getResources().getDisplayMetrics().heightPixels) * 4 / 5);
        } catch (NumberFormatException e) {
            height = DEFAULT_HEIGHT;
        }
        FrameLayout.LayoutParams params =
                (FrameLayout.LayoutParams) flContent.getLayoutParams();
        params.width = (CoreUtil.getContext().getResources().getDisplayMetrics().widthPixels) * 4 / 5;
        params.height = height;
        params.gravity = Gravity.CENTER;
        flContent.setLayoutParams(params);
    }

    private void initWeb() {
        webView = new WebView(this);
        webView.setVisibility(View.VISIBLE);
        webView.setBackgroundColor(Color.TRANSPARENT);
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            //适配5.0不允许http和https混合使用情况
            webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
        //自动加载图片
        webSettings.setLoadsImagesAutomatically(true);
        //多窗口
        webSettings.setSupportMultipleWindows(false);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        //设置编码格式
        webSettings.setDefaultTextEncodingName("UTF-8");
        //当webview调用requestFocus时为webview设置节点
        webSettings.setNeedInitialFocus(true);
        //隐藏原生的缩放控件
        webSettings.setDisplayZoomControls(false);
        //适配移动端的页面
        webSettings.setUseWideViewPort(true);
        // 缩放至屏幕的大小
        webSettings.setLoadWithOverviewMode(true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT && AdManager.isDebug()) {
            WebView.setWebContentsDebuggingEnabled(true);
        }
        mSspWebWindow = new SspWebWindow(this, formId);
        webView.addJavascriptInterface(mSspWebWindow, WEB_WINDOW_NAME);
        webView.setWebViewClient(webViewClient);
        webView.setWebChromeClient(webChromeClient);
        webView.setLayoutParams(new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT));
        flContent.addView(webView);
        load();
        //webView.loadUrl("file:///android_asset/form.html");
    }

    /**
     * web form表单跳转
     */
    private void load() {
       TrackingManager.reportServerClick(pointBean,adsDTO);
        TranssionPoolManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                if(adsDTO.isOfflineAd()){
                    formPath = PlatformUtil.getCacheFilePath(formUrl,adsDTO.isOfflineAd());
                }
                if(TextUtils.isEmpty(formPath)){
                    finish();
                    return;
                }
                final String data = FileUtil.getStrFile(formPath);
                if (TextUtils.isEmpty(data)) {
                    finish();
                    return;
                }
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (webView != null) {
                            webView.loadDataWithBaseURL(
                                    formUrl,
                                    data,
                                    "text/html; charset=utf-8",
                                    "utf-8",
                                    null
                            );
                        } else {
                            finish();
                        }
                    }
                });
            }
        });
    }


    /**
     * 提交form信息
     *
     * @param formParams
     */
    public void submitForm(String formParams) {
        AdLogUtil.Log().d(CommonLogUtil.TAG, "SspWebWindow-----> submitForm    " + formParams);
        FormBean formBean = null;
        try {
            formBean = GsonUtil.fromJson(formParams, FormBean.class);
            formBean.setGaid(DeviceUtil.getGAId());
            formBean.setFormId(formId);
            formBean.setIpAddress(DeviceUtil.getIp());
            if (adsDTO != null && adsDTO.isOfflineAd()) {
                AthenaTracker.trackFormInfoSet(adsDTO, formBean);
            } else {
                PlatformUtil.submitForm(GsonUtil.toJson(formBean), 0);
            }
        } catch (GsonUtil.GsonParseException e) {
            e.printStackTrace();
            AdLogUtil.Log().d(CommonLogUtil.TAG, "SspWebWindow-----> submitForm    " + e.getMessage());
        }
    }

    /**
     * dip 转 px
     *
     * @param dpValue
     * @return
     */
    private int dip2px(float dpValue) {
        final float scale = getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }

    public WebViewClient webViewClient = new WebViewClient() {

        @Override
        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            AdLogUtil.Log().d(TAG,"shouldInterceptRequest URL== "+url);
            WebResourceResponse webResourceResponse = WebResponseUtil.onInterceptOkRequest(url);
            if(webResourceResponse != null && adsDTO != null && adsDTO.isOfflineAd() ){
                long webDuration = System.currentTimeMillis() - start;
                AthenaTracker.offLineWebComplete(adsDTO, webDuration);
                return webResourceResponse;
            }
            return super.shouldInterceptRequest(view, url);
        }

        @Override
        public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
            if (Build.VERSION.SDK_INT > Build.VERSION_CODES.O) {
                return false;
            }
            // 仅对我们自己的 webview 做处理
            if (view == webView) {
                // 获取 webview 所在父布局
                ViewGroup parent = (ViewGroup) webView.getParent();
                ViewGroup.LayoutParams params = webView.getLayoutParams();
                // 把无效不可用的 webview 从布局中移除
                parent.removeView(webView);
                return true;
            }
            return super.onRenderProcessGone(view, detail);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
        }
    };

    public WebChromeClient webChromeClient = new WebChromeClient();

    public static class SspWebWindow {
        private WeakReference<Activity> activityWeakReference;
        private int formId;
        private AdsDTO adsDTO;

        public SspWebWindow(Activity activity, int formId) {
            activityWeakReference = new WeakReference(activity);
            this.formId = formId;
        }

        @JavascriptInterface
        public void close() {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "SspWebWindow-----> close");
            if (activityWeakReference != null && activityWeakReference.get() != null) {
                activityWeakReference.get().finish();
            }
        }

        @JavascriptInterface
        public void submitForm(String formParams) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "SspWebWindow-----> submitForm");
            TAdWebFormsActivity activity = (TAdWebFormsActivity) activityWeakReference.get();
            if (activity != null) {
                activity.submitForm(formParams);
            }
        }
    }
}
