package com.cloud.hisavana.sdk.common.callback;

import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/3/25.
 */

public abstract class InternalAdListener extends AdListener {

    public void onAdResponse(List<AdsDTO> adBeans) {
        if (adBeans != null && adBeans.size() > 0 && adBeans.get(0)!=null && !adBeans.get(0).isOfflineAd()) {
            AthenaTracker.trackSspReturn(adBeans, null, null);
        }
    }

    public void onSplashCacheGet(List<AdsDTO> adBeans) {

    }

    public void onErrorInternal(List<AdsDTO> adBeans, TaErrorCode adError, AdxImpBean adxImpBean) {
        if (adxImpBean != null && adxImpBean.offlineAd) {
            return;
        }
        if (adBeans != null && adBeans.size() > 0) {
            AthenaTracker.trackSspReturn(adBeans, adError, adxImpBean);
        } else {
            AthenaTracker.trackSspReturn(null, adError, adxImpBean);
        }

    }

    public void onMediaDownloaded(TaNativeInfo adInfo) {

    }
}
