package com.cloud.hisavana.sdk.common.constant;

/**
 * @author: wenjing.luo
 * @date: 2021/08/09
 * ==================================
 * Copyright (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class Constants {

    public interface ResponseCode {
        /**
         * 业务成功
         * a
         */
        int BUSINESS_SUCCESS_CODE = 0;
    }

    public interface HOST {
        //TEST环境
        String ADN_TEST_SERVER_ADDRESS = "http://api.test.hisavana.com";
        //DEV环境
        String ADN_DEV_SERVER_ADDRESS = "https://api-fat0101.eagllwin.com";
        //MOCK数据地址
        String ADN_MOCK_SERVER_ADDRESS = "http://mock-tmc.shalltry.com/mock/61810a476f76570a70b2098d";
        //RELEASE环境
        String ADN_RELEASE_SERVER_ADDRESS = "https://api.hisavana.com";
        //FAT环境
        String ADN_FAT_SERVER_ADDRESS = "http://api.fat1.hisavana.com";

        String API = "/isavana/trafficdispatch/v1/consumer-not-login/addispatch/query/getAdData";
        String CONFIG_API = "/hisavana/traffic-dispatch/v1/consumer-not-login/cloudcontrol/query/getCloudControlDataOffline";

        //1.3.0服务端曝光新增
        String ADN_FAT_SERVER_IMPRESSSION = "api.fat1.eagllwin.com";
        String ADN_TEST_SERVER_IMPRESSSION = "api.test.eagllwin.com";
        String ADN_PRE_SERVER_IMPRESSSION = "api.pre.eagllwin.com";
        String ADN_RELEASE_SERVER_IMPRESSSION = "api.eagllwin.com";

        //1.4.0 请求ps素材地址
        String ADN_PS_UAT_SERVER_ADDRESS = "https://uat-loan.palmplaystore.com";//uat环境
        String ADN_PS_RELEASE_SERVER_ADDRESS = "https://coins-api.palmplaystore.com";//爱尔兰生产环境
        String PS_API = "/coins/loan/getRecommendItemIist";

        // 上传form信息的地址
        String SUMBIT_FORM_RELEASE_HOST = "https://api.eagllwin.com";// 生产环境
        String SUMBIT_FORM_DEV_HOST = "https://api.test.eagllwin.com";// 生产环境
        String SUMBIT_FORM_FAT_HOST = "https://api.fat1.eagllwin.com";//fat1 环境
        String FORM_URL = "/eagllwin/clue/consumer-not-login/clue/cmd/submitClue";//请求地址
    }


    public static int adChoiceViewSize = 9;
    public static String AD_SOURCE = "0";
    //clickUrls调起短信编辑页
    public static String SMSTO = "smsto:";
    public static String SMS_BODY = "sms_body";

    //代码位类型，1 native，2 banner，3插屏， 4 开屏
    public interface AdType {
        /**
         * Banner广告类型
         */
        int BANNER = 2;
        /**
         * 插屏广告类型
         */
        int INTERSTITIAL = 3;
        /**
         * Native广告类型
         */
        int NATIVE = 1;
        /**
         * Splash-Native广告类型
         */
        int SPLASH_NATIVE = 4;
    }
    //展现上报时机类型
    public interface SHOW_REPORT_TIME_TYPE {
        /**
         * 展现时上报
         */
        int TYPE_SHOW = 1;
        /**
         * 达标时上报
         */
        int TYPE_UP_TO_STANDARD = 2;
        /**
         * 离开时上报
         */
        int TYPE_LEAVE = 3;
    }

    //曝光，点击上报 是否安装推广应用1.非下载类广告 2. 已安装目标下载应用 3.未安装目标下载应用
    public interface INSTALL_APK_STATUS {
        /**
         * 异常情况，android11+因为隐私保护，无法根据包名在安装列表中找到对应app
         */
        int ERROR_SITUATION = -1;
        /**
         * 非下载类广告
         */
        int NON_DOWNLOAD_AD = 1;
        /**
         * 已安装目标下载应用
         */
        int DOWNLOAD_APP_INSTALLED = 2;
        /**
         * 未安装目标下载应用
         */
        int DOWNLOAD_APP_NOT_INSTALLED = 3;
    }
    public static String ACTION_INTERSTITIAL_PREIMP = "_pre_imp";
    public static String ACTION_INTERSTITIAL_SHOW = "_show";
    public static String ACTION_INTERSTITIAL_ERROR = "_error";
    public static String ACTION_INTERSTITIAL_CLOSE = "_close";
    public static String ACTION_INTERSTITIAL_CLICK = "_click";
    /**
     * 约定无缓存是返回1
     */
    public static final long NO_CACHE_EXPIRA_TIME = 1;

    public interface LoadType {

        int CACHE = 0;
        int NET = 1;
    }

    /**
     * Media类型
     */
    public interface MIME {

        int IMG = 1;
        int GIF = 2;
        int VIDEO = 3;
    }

    public static final String JAVASCRIPT_INTERFACE = "VideoLoadInterface";
    /**
     * 离线广告请求处理逻辑线程名
     */
    public static final String WORK_THREAD_NAME = "h_work_thread";

    /**
     * MediaView Tag
     */
    public interface ImageTag {

        String IMAGE_WEBVIEW = "image_webview";

        String ADX_CHOICE = "adxAdChoice";

        String DEFULT_BG = "#000000";
    }


    /**
     * MediaView Tag
     */
    public interface ImageLoadType {

        // 1 no cache/memory || 2 cache no memory || 3 cache memory

        int IMAGE_RAM_INCLUDED = 1;

        int IMAGE_PARSE = 2;

        int IMAGE_DISK_INCLUDED = 3;
    }

    public interface Config {
        String ALLOW_SKIP_OUT = "isAllowSkipOut";
        boolean ALLOW_SKIP_OUT_DEFAULT = true;
        String SENSITIVE_KEYWORDS = "sensitive_keywords";
    }

    public final static String PREF_NEW_CLOUD_CONTROL_VERSION = "new_config_ver";
    public final static String CLOUD_CONTROL_VERSION = "cloudControlVersion";
    public final static String CLOUD_CONTROL_HISAVANA_VERSION = "cloudControlOfflineVersion";
    public final static String PREF_NEW_HISAVANA_CLOUD_CONTROL_VERSION = "new_hisavana_ver";
    public final static String HISAVANA_CLOUD_CONTROL_VERSION = "hisavanaCurrentCloudControlVersion";
    public final static String REQUEST_CONFIG_TIME = "requestConfigTime";
    public final static String IS_DEBUG = "IS_DEBUG";

    /**
     * 初始化类型  0：debug 1： release -1：未初始化
     */
    public interface InitType {
        int DEBUG = 0;
        int RELEASE = 1;
        int NOT_INIT = -1;
    }
    /**
     * 保存 手机本地时间戳和 服务器差值
     */
    public final static String SERVICES_TIME_DIFFERENCE_VALUE="services_time_difference_value";

    /**
     * Banner 样式
     */
    public static final String BANNER_MATERIAL_STYLE_B3201 = "B3201";
    public static final String BANNER_MATERIAL_STYLE_B20301 = "B20301";
    public static final String BANNER_MATERIAL_STYLE_B20302 = "B20302";
    public static final String BANNER_MATERIAL_STYLE_B20303 = "B20303";
    public static final String BANNER_MATERIAL_STYLE_B20304 = "B20304";

    /**
     * 插屏样式
     */
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1101 = "I1101";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1102 = "I1102";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1103 = "I1103";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1106 = "I1106";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1107 = "I1107";
    public static final String INTERSTITIAL_MATERIAL_STYLE_FA14 = "FA14";

    /**
     * 插屏广告 数据还原
     */
    public final static String INTERSTITIAL_APP_ID = "interstitial_app_id";


    /**
     * pslink下载情况
     * 1.非pslink广告
     * 2.pslink广告 - 未安装ps
     * 3.pslink广告 - 无GPlink
     * 4.pslink广告 - 推荐应用小于2
     * 5.pslink广告 - 未完成下载
     * 6.pslink广告 - 已完成下载
     * 7.pslink广告 - 发起请求，服务端未返回物料数据
     */
    public interface AD_PS_TYPE {
        int NO_PS_AD = 1;
        int PS_NOT_INSTALL = 2;
        int PS_NOT_GPLINK = 3;
        int PS_RECOMMEND_ITEM_IIST_LESS = 4;
        int PS_MATERIAL_DOWNLOAD_FAIL = 5;
        int PS_MATERIAL_DOWNLOAD_SUCCESS = 6;
        int PS_MATERIAL_NOT_RETURN = 7;
    }

    /**
     * 点击的内容类型
     * 1. GP下载按钮
     * 2. PS推荐应用下载按钮
     * 3.关闭按钮
     */
    public interface CLICK_CONTENT_TYPE {
        int CLICK_GPLINK = 1;
        int CLICK_PSLINK = 2;
        int CLICK_CLOSE = 3;
    }

    /**
     * 区分普通广告还是pslink广告
     * 1. 非pslink广告
     * 2. pslink广告
     */
    public interface IS_PSLINK_AD {
        int NO_IS_PSLINK_AD = 1;
        int IS_PSLINK_AD = 2;
    }

    /**
     * 区分普通广告还是adm广告
     * 1.非adm广告
     * 2.adm广告
     */
    public interface IS_ADM_AD {
        int NO_ADM_AD = 1;
        int ADM_AD = 2;
    }

    /**
     * 被调起的url类型
     * 1. gplink
     * 2. pslink
     * 3. clickurls
     */
    public interface CALLED_URL_TYPE {
        int GPLINK = 1;
        int PSLINK = 2;
        int CLICKURLS = 3;
    }

    /**
     * banner广告比例
     */
    public interface BANNER_SCALE{
        String BANNER_SCALE_203 = "20:3";
        String BANNER_SCALE_32 = "3:2";
    }

    /**
     * 加载物料的时候 try-catch 了
     */
    public static final int DOWNLOAD_IMG_ERROR_CATCH_CODE = 101;


    /**
     * 142 新增需求  ssp广告接口，增加一个header， 字段名：defaultAd，取值 1，表示打底，其他取值表示非打底
     */
    public static final String REQUEST_HEADER_DEFAULT_AD_2 = "2";

    /**
     * 142新增 native广告的类型
     */
    public interface AdSeatType {
        String TYPE_LOCK_SCREEN = "LockScreen";
        String TYPE_FEEDS = "Feeds";
        String TYPE_HOT_APPS = "Hotapps";
    }

    public interface HTTP_TIME_OUT{
        int TIMEOUT_IN_MILLIONS = 15*1000;
        int READ_TIMEOUT_IN_MILLIONS = 15*1000;
    }

    /**
     * content provider 数据传输key
     */
    public static final String CONTENT_CLOUD_CONFIG = "CloudConfig";
    public static final String CONTENT_ADS_DATA = "AdsData";

    /**
     * 云控触发时机
     */
    public interface TriggerType {
        int TRIGGER_COLD = 1;
        int TRIGGER_NET_CHANGE = 2;
        int TRIGGER_AD_RETURN = 3;
    }
    /**
     * 广告请求时机
     */
    public interface RequestType {
        int REQUEST_MEDIA_LOAD = 1;
        int REQUEST_COLD = 5;
        int REQUEST_NET_CHANGE = 6;
        int REQUEST_AD_RETURN = 7;
    }
    /**
     * 填充来源"1.有网触发实时请求 2.有网触发离线填充 3. 无网触发离线填充"
     */
    public interface FillingSource {
        int REQUEST_AD = 1;
        int ONLINE_CACHE_AD = 2;
        int OFFLINE_CACHE_AD = 3;
    }
    /**
     * 填充结果1填充成功,2填充失败
     */
    public interface FillingResult {
        int FILL_SUCCESS = 1;
        int FILL_FAIL = 2;
    }
    /**
     * 媒体调用请求，0有网请求，1无网请求
     */
    public interface TriggerNetState {
        int TRIGGER_NET = 0;
        int TRIGGER_NO_NET = 1;
    }
    /**
     * 一天ms数
     */
    public static final long DAY_TIME_MS = 24 * 60 * 60 * 1000;
}
