package com.cloud.hisavana.sdk.common.http;


import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.impl.HttpCallbackImpl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


/**
 * Created by peng.sun on 2017/6/19.
 */

public class DownLoadRequest extends RequestBase<DrawableResponseListener> {

    public static boolean IS_HAD_AD_CHOICE = false;
    private static final int HTTP_CACHE_SUCCESS = 250;
    private static final int HTTP_CACHE_FAIL = 256;

    /***资源大小*/
    long fileSize = 0L;
    /***cdn 请求头获取*/
    String cdn = "";
    /***请求开始时间*/
    long startTime = 0L;
    /***网路请求错误代码*/
    int errorCode = -1;
    /***当前下载方式*/
    int downloadWay = AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION;

    /*** 用于埋点*/
    private AdsDTO adsDTO;
    //  物料类型 1=logo 2=大图 int
    private int mType;
    /***1. 从网络获取；2. 从本地缓存获取*/
    private int requestType = 1;
    private boolean isFetch = false;
    private boolean isOffline = false;
    private boolean isUsePool = true;

    public DownLoadRequest setAdsDTO(AdsDTO ads, int type) {
        this.adsDTO = ads;
        if(ads!=null){
            this.isOffline =ads.isOfflineAd();
        }
        this.mType = type;
        return this;
    }

    private String url = "";
    private int isPreCache = Constants.ImageLoadType.IMAGE_RAM_INCLUDED;

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    public DownLoadRequest setFetch(boolean isFectch) {
        this.isFetch = isFectch;
        return this;
    }

//    public DownLoadRequest setOffline(boolean isOffline) {
//        this.isOffline = isOffline;
//        return this;
//    }

    public DownLoadRequest setUsePool(boolean usePool) {
        isUsePool = usePool;
        return this;
    }

    /**
     * 前期执行检查网络
     */
    @Override
    public void netRequestPreExecute() {
//        20211014 1.0版本暂时去除
//        if (ADOkHttpClient.getInstance().getOkHttpClient() != null) {
//            SLogUtil.Log().d(AdLogUtil.TAG,IMG_TAG,"媒体使用了 Okhttp");
//            try {
//                switchOkhttp();
//            }catch (Exception e){
//                SLogUtil.Log().d(AdLogUtil.TAG,IMG_TAG,"媒体使用 Okhttp 异常 " + e.getMessage());
//                mListener.onServerRequestFailure(new TaErrorCode(0, "Okhttp - " + e.getMessage()));
//            }
//            return;
//        }
//
//        SLogUtil.Log().d(IMG_TAG,"媒体没有使用 Okhttp 正常走流程 ");

        /**
         * 分发网络请求
         */
//        SLogUtil.Log().d(TAG, "netRequestPreExecute");
        if (TextUtils.isEmpty(url)) {
            AdLogUtil.Log().e(CommonLogUtil.TAG, "url is empty");
            return;
        }
        netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        try {
            RequestCall requestCall = HttpClient.image(CoreUtil.getContext())
                    .log(false)
                    .cache(true)
                    .fetchFilePath(isFetch)
                    .useOffLineCache(isOffline)
                    .connectTimeout(TIMEOUT_IN_MILLIONS)
                    .readTimeout(20 * 1000)
                    .url(url)
                    .build();
            // 用于计算网络请求耗时
            startTime = System.currentTimeMillis();
            ImageURL imageURL = new ImageURL(url);
            String md5Url = imageURL.toMD5();
            AdLogUtil.Log().d("DownLoadRequest",md5Url);
            requestCall.execute(new HttpCallbackImpl(isUsePool) {
                @Override
                public void onSuccess(int statusCode, byte[] data) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "DownLoadRequest --> onSuccess statusCode " + statusCode + " url " + url);
                    requestType = statusCode == HTTP_CACHE_SUCCESS ? 2 : 1;
                    if (mListener != null && mListener instanceof DrawableResponseListener) {
                        mListener.onServerRequestSuccess(isPreCache, statusCode, data, null);
                    }
                    if (null != data) {
                        fileSize = data.length;
                    }
                    if (mType == AthenaTracker.M_TYPE_AD_CHOICE_VIEW) {
                        IS_HAD_AD_CHOICE = true;
                    }
                    downloadTrack(AthenaTracker.M_STATUS_SUCCESS);
                }

                @Override
                public void onResponseHeader(Map<String, List<String>> map) {
                    super.onResponseHeader(map);
                    //AdLogUtil.Log().d(CommonLogUtil.TAG,"DownLoadRequest --> onResponseHeader");
                    // 如果是客户端读取的应该是x-response-cdn
                    // 如果是服务端应该是拿x-request-cdn
                    if (null != map && !map.isEmpty()) {
                        List<String> strings = map.get("x-response-cdn");
                        if (null != strings && !strings.isEmpty()) {
                            cdn = strings.get(0);
                        }
                    }
                }

                @Override
                public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "DownLoadRequest --> onFailure statusCode " + statusCode + " e" + throwable + " url " + url);
                    requestType = statusCode == HTTP_CACHE_FAIL ? 2 : 1;
                    if (mListener != null) {
                        mListener.onServerRequestFailure(statusCode, bytes, throwable);
                    }
                    errorCode = statusCode;
                    downloadTrack(AthenaTracker.M_STATUS_ERROR);
                }

                @Override
                public void onSuccess(int statusCode, byte[] responseBody, final String filePath) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "DownLoadRequest --> onSuccess statusCode " + statusCode + " filePath " + filePath + " url" + url);
                    requestType = statusCode == HTTP_CACHE_SUCCESS ? 2 : 1;
                    if (mListener != null && mListener instanceof DrawableResponseListener) {
                        mListener.onServerRequestSuccess(isPreCache, statusCode, responseBody, filePath);
                    }
                    if (null != responseBody) {
                        fileSize = responseBody.length;
                    }
                    if (mType == AthenaTracker.M_TYPE_AD_CHOICE_VIEW) {
                        IS_HAD_AD_CHOICE = true;
                    }
                    downloadTrack(AthenaTracker.M_STATUS_SUCCESS);
                }
            });
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
            // 上报下载失败
            errorCode = Constants.DOWNLOAD_IMG_ERROR_CATCH_CODE;
            downloadTrack(AthenaTracker.M_STATUS_ERROR);
        }
    }


    // =============================================================================================


    /**
     * 开始下载 下载成功 下载失败 日志上报
     * info 广告详情
     * requestType 请求方式 1. 从网络获取；2. 从本地缓存获取
     * downloadWay 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * mStatus     下载状态 1.开始下载 2.下载成功 3.下载失败
     * errorCode   错误信息
     * mType       资源类型
     * cdn         资源来源
     * timeConsuming 耗时
     * fileSize   文件大小
     */
    private void downloadTrack(int mStatus) {

        // 142 资源类型是 adchoice 不上报物料下载埋点事件
        if (mType == AthenaTracker.M_TYPE_AD_CHOICE_VIEW) {
            return;
        }

        AthenaTracker.trackImageDownload(adsDTO,
                requestType,
                downloadWay,
                mStatus,
                errorCode,
                mType,
                cdn,
                System.currentTimeMillis() - startTime,
                getSize(fileSize),
                isOffline ? 1 : 0);
    }

    /**
     * file_size 单位转换成 KB 上传
     *
     * @param byteSize byte size
     * @return
     */
    public static int getSize(long byteSize) {
        int size = 0;
        try {
            BigDecimal sizeNew = new BigDecimal(byteSize);
            size = sizeNew.divide(BigDecimal.valueOf(1024), 0, BigDecimal.ROUND_HALF_UP).intValue();
        } catch (Exception e) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, Log.getStackTraceString(e));
        }
        return size;
    }


}
