package com.cloud.hisavana.sdk.common.http.listener;


import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.PARSE_BITMAP_ERROR;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;

import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.transsion.core.CoreUtil;

import pl.droidsonroids.gif.GifDrawable;


/**
 * Created by peng.sun on 2017/6/21.
 */

public abstract class DrawableResponseListener extends ResponseBaseListener {
    protected DrawableResponseListener() {
        super();
    }

    protected DrawableResponseListener(boolean usePool) {
        super(usePool);
    }

    /**
     * 成功回调
     *
     * @param statusCode
     * @param
     */
//    public abstract void onRequestSuccess(int statusCode, byte[] data);

    public abstract void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean);


    /**
     * 解析方法
     *
     * @param statusCode
     * @param data
     * @param isPreCache
     */
    public final void onServerRequestSuccess(int isPreCache,final int statusCode, final byte[] data,final String filePath) {
        if(isPreCache == Constants.ImageLoadType.IMAGE_DISK_INCLUDED){
            if (this.handler != null) {
                this.handler.post(new Runnable() {
                    @Override
                    public void run() {
                        onRequestSuccess(statusCode, data, new AdImage(Constants.MIME.IMG, null, filePath));
                    }
                });
            } else {
                onRequestSuccess(statusCode, data,null);
            }
        }
        else {
            Drawable drawable = null;
            int mime = -1;
            try {
                if (data[0] == 0x47) {
                    drawable = new GifDrawable(data);
                    mime = Constants.MIME.GIF;
                } else {
                    Bitmap bitmap = BitmapFactory.decodeByteArray(data, 0, data.length);
                    drawable = new BitmapDrawable(CoreUtil.getContext().getResources(), bitmap);
                    mime = Constants.MIME.IMG;
                }
            } catch (Throwable e) {
                AdLogUtil.Log().e(Log.getStackTraceString(e));
            }
            final Drawable finalDrawable = drawable;
            final int finalMime = mime;
            if (this.handler != null) {
                this.handler.post(new Runnable() {
                    @Override
                    public void run() {
                        if(finalMime == -1){
                            onRequestError(new TaErrorCode(PARSE_BITMAP_ERROR,"parse bitmap error."));
                        }
                        else {
                            onRequestSuccess(statusCode, new byte[]{}, new AdImage(finalMime,finalDrawable,filePath));
                        }
                    }
                });
            } else {
                if(finalMime == -1){
                    onRequestError(new TaErrorCode(PARSE_BITMAP_ERROR,"parse bitmap error."));
                }
                else {
                    onRequestSuccess(statusCode, new byte[]{}, new AdImage(finalMime,finalDrawable,filePath));
                }
            }
        }
    }
}
