package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;
import android.util.SparseArray;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

/**
 * Created by xuhui.fang ON 2022/5/24
 */
public class UrlUtil {

    /**
     * 通过url获取其中的参数
     * @param key 目前的key
     * @param url
     * @return
     */
    public static String getParamValue(String key,String url){
        Map<String, String> mapRequest = getParamMap(url);
        if(mapRequest ==null || mapRequest.isEmpty()){
            return "";
        }
        String result = mapRequest.get(key);
        return TextUtils.isEmpty(result)?"":result;
    }

    /**
     * 解析出url参数中的键值对
     * @param url url地址
     * @return url请求参数部分
     */
    private static Map<String, String> getParamMap(String url) {
        Map<String, String> mapRequest = new HashMap<String, String>();
        String[] arrSplit = null;
        String strUrlParam = getUrlParams(url);
        if (strUrlParam == null) {
            return mapRequest;
        }
        //每个键值为一组 www.2cto.com
        arrSplit = strUrlParam.split("[&]");
        for (String strSplit : arrSplit) {
            String[] arrSplitEqual = null;
            arrSplitEqual = strSplit.split("[=]");

            //解析出键值
            if (arrSplitEqual.length > 1) {
                //正确解析
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);

            } else {
                if (arrSplitEqual[0] != "") {
                    //只有参数没有值，不加入
                    mapRequest.put(arrSplitEqual[0], "");
                }
            }
        }
        return mapRequest;
    }

    /**
     * 去掉url中的路径，留下请求参数部分
     *
     * @param strURL url地址
     * @return url请求参数部分
     */
    private static String getUrlParams(String strURL) {
        String strAllParam = null;
        String[] arrSplit = null;
        strURL = strURL.trim();
        arrSplit = strURL.split("[?]");
        if (strURL!=null && strURL.length() > 1) {
            if (arrSplit!=null && arrSplit.length > 1) {
                if (arrSplit[1] != null) {
                    strAllParam = arrSplit[1];
                }
            }
        }

        return strAllParam;
    }
}
