package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.webkit.WebResourceResponse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Created  ON 2022/7/26
 *
 * @author :fangxuhui
 */
public class WebResponseUtil {

    public static final String INTERCEPT = "_tmc_load_ok.png";
    public static final String OK_DATABASE = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAA" +
            "BCAAAAAA6fptVAAAACklEQVQYV2P4DwABAQEAWk1v8QAAAABJRU5ErkJggg==";

    public static WebResourceResponse onInterceptOkRequest(String assetsUrl) {
        if (!TextUtils.isEmpty(assetsUrl) && assetsUrl.endsWith(INTERCEPT)) {
            try {
                InputStream webAssetStream = new ByteArrayInputStream(OK_DATABASE.getBytes());
                if (webAssetStream != null) {
                    String fileExtensionFromUrl = MimeTypeMap.getSingleton().getFileExtensionFromUrl(assetsUrl);
                    if (!TextUtils.isEmpty(fileExtensionFromUrl)) {
                        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtensionFromUrl);
                        WebResourceResponse resourceResponse =
                                new WebResourceResponse(mimeType, "UTF-8", webAssetStream);
                        return resourceResponse;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
