package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.common.AdLogUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * Created ON 2022/7/11
 *
 * @author xuhui.fang
 * 压缩文件工具类
 */
public class ZipUtil {
    public static final String TAG = "ZIP";

    /**
     * 解压zip到指定的路径
     *
     * @param zipFileString ZIP的路径
     * @param outPathString 要解压缩路径
     * @throws Exception
     */
    public static synchronized boolean decompressZipFolder(String zipFileString, String outPathString) {
        if (TextUtils.isEmpty(zipFileString) || TextUtils.isEmpty(outPathString)) {
            return false;
        }
        String temporaryPath = outPathString + System.currentTimeMillis();
        ZipInputStream inZip = null;
        try {
            inZip = new ZipInputStream(new FileInputStream(zipFileString));
            ZipEntry zipEntry;
            while ((zipEntry = inZip.getNextEntry()) != null) {
                String szName = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    AdLogUtil.Log().d(TAG, "directory name === "+temporaryPath + File.separator + szName);
                    File folder = new File(temporaryPath + File.separator + szName);
                    folder.mkdirs();
                } else {
                    AdLogUtil.Log().d(TAG, "file name === "+temporaryPath + File.separator + szName);
                    File file = new File(temporaryPath + File.separator + szName);
                    if (!file.exists()) {
                        AdLogUtil.Log().d(TAG, "Create the file:" + temporaryPath + File.separator + szName);
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                    }
                    // 获取文件的输出流
                    FileOutputStream out = new FileOutputStream(file);
                    int len;
                    byte[] buffer = new byte[1024];
                    // 读取（字节）字节到缓冲区
                    while ((len = inZip.read(buffer)) != -1) {
                        // 从缓冲区（0）位置写入（字节）字节
                        out.write(buffer, 0, len);
                        out.flush();
                    }
                    out.close();
                }
            }
            File temporaryFile = new File(temporaryPath);
            File outFile = new File(outPathString);
            if (temporaryFile.exists()) {
                temporaryFile.renameTo(outFile);
            }
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        } finally {
            if (inZip != null) {
                try {
                    inZip.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    /**
     * 返回ZIP中的文件列表（文件和文件夹）
     *
     * @param zipFileString  ZIP的名称
     * @param bContainFolder 是否包含文件夹
     * @param bContainFile   是否包含文件
     * @return
     * @throws Exception
     */
    public static List<File> GetFileList(String zipFileString, boolean bContainFolder, boolean bContainFile) throws Exception {
        List<File> fileList = new ArrayList<File>();
        ZipInputStream inZip = new ZipInputStream(new FileInputStream(zipFileString));
        ZipEntry zipEntry;
        String szName = "";
        while ((zipEntry = inZip.getNextEntry()) != null) {
            szName = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                // 获取部件的文件夹名
                szName = szName.substring(0, szName.length() - 1);
                File folder = new File(szName);
                if (bContainFolder) {
                    fileList.add(folder);
                }
            } else {
                File file = new File(szName);
                if (bContainFile) {
                    fileList.add(file);
                }
            }
        }
        inZip.close();
        return fileList;
    }
}
