package com.cloud.hisavana.sdk.config;
/* Top Secret */

import com.cloud.hisavana.sdk.common.constant.Constants;

public class AdxServerConfig {

    public static final int RELEASE = 0;
    public static final int DEV = 2;
    public static final int TEST = 1;
    public static final int MOCK = 3;
    public static final int FAT = 4;

    private static int app_Modle = RELEASE;

    public static int getAppModle() {
        return app_Modle;
    }

    //release版本关闭此接口
    public static void setAppModle(int app_Modle) {
        AdxServerConfig.app_Modle = app_Modle;
    }

    public static String getServerUrl() {
        switch (getAppModle()) {
            case AdxServerConfig.RELEASE:
                return Constants.HOST.ADN_RELEASE_SERVER_ADDRESS;
            case AdxServerConfig.TEST:
                return Constants.HOST.ADN_TEST_SERVER_ADDRESS;
            case AdxServerConfig.DEV:
                return Constants.HOST.ADN_DEV_SERVER_ADDRESS;
            case AdxServerConfig.MOCK:
                return Constants.HOST.ADN_MOCK_SERVER_ADDRESS;
            case AdxServerConfig.FAT:
                return Constants.HOST.ADN_FAT_SERVER_ADDRESS;
            default:
                return Constants.HOST.ADN_TEST_SERVER_ADDRESS;
        }
    }

    public static String getServerApi() {
         return Constants.HOST.API;
    }

    public static String getConfigApi() {
        return Constants.HOST.CONFIG_API;
    }

    private static boolean FOR_AUTO_TEST = false;

    public static boolean isForAutoTest() {
        return FOR_AUTO_TEST;
    }

    /**
     * 设置是广告落地页跳转 true 跳转到浏览器 false跳转到webview 跑自动化tctp需要设置成true
     * @param forAutoTest
     */
    public static void setForAutoTest(boolean forAutoTest) {
        FOR_AUTO_TEST = forAutoTest;
    }


    /**
     * 获取请求Ps素材的地址
     * @return
     */
    public static String getPsServerUrl() {
        switch (getAppModle()) {
            case AdxServerConfig.RELEASE:
                return Constants.HOST.ADN_PS_RELEASE_SERVER_ADDRESS;
            default:
                return Constants.HOST.ADN_PS_UAT_SERVER_ADDRESS;
        }
    }

    /**
     * 上传form表单数据
     * @return
     */
    public static String getFormServerUrl() {
        switch (getAppModle()) {
            case  AdxServerConfig.RELEASE:
                return Constants.HOST.SUMBIT_FORM_RELEASE_HOST;
            case  AdxServerConfig.FAT:
                return Constants.HOST.SUMBIT_FORM_FAT_HOST;
            default:
                return Constants.HOST.SUMBIT_FORM_DEV_HOST;
        }
    }
}
