package com.cloud.hisavana.sdk.internal.base;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.TrackingUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.ConfigCodeSeatDTO;
import com.cloud.hisavana.sdk.internal.detach.AdInfoTransfer;
import com.cloud.hisavana.sdk.manager.ConfigManager;
import com.cloud.hisavana.sdk.manager.ConfigProviderManager;
import com.cloud.hisavana.sdk.manager.OfflineProviderManager;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.sdk.commonutil.util.RunTimer;
import com.transsion.core.utils.NetUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by jianbing.yu on 2019/3/29.
 * <p>
 * 插屏 Banner native
 */
public abstract class BaseAd {

    protected String mPlacementId;
    protected int requestType = Constants.RequestType.REQUEST_MEDIA_LOAD;
    protected int scheduleTime = 60 * 1000;//default 60s
    /**
     * 超时相关
     */
    private final RunTimer runTimer = new RunTimer();

    protected boolean isTimeout = false; // 超时标志 --> 即使后面请求回来了 也不执行后面的业务逻辑了
    protected AdListener mListener;
    protected String mRid = "";
    protected AdRequest adRequest;

    protected boolean isLoading = false;
    public String mSdkVersion = "";

    protected boolean mLoaded = false; // load成功
    protected boolean mShowed = false; // show成功
    public boolean mClicked = false; // click成功

    protected boolean oneByOne = false;
    protected String mRequestId;
    protected String mTriggerId;
    protected boolean isOfflineAd;
    protected int mTriggerNetState;//1无网 0有网

    protected AtomicInteger adShowCount = new AtomicInteger(1);
    protected int adCount = 1;
    protected boolean isLoadedOffline = false;

    public void setAdRequest(AdRequest request) {
        if (request == null) {
            return;
        }
        this.adRequest = request;
        if (!TextUtils.isEmpty(request.getRequestId())) {
            this.mRequestId = request.getRequestId();
        }
        if (!TextUtils.isEmpty(request.getPlacementId())) {
            this.mPlacementId = request.getPlacementId();
        }
        if (request.getListener() != null) {
            this.mListener = request.getListener();
        }
        if (request.getScheduleTime() > 0) {
            this.scheduleTime = request.getScheduleTime();
        }
        if (request.getRequestType() != -1) {
            this.requestType = request.getRequestType();
        }
    }

    public void setScheduleTime(int scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public AdRequest getAdRequest() {
        return adRequest;
    }

    /**
     * 这个 监听器 设置给了 Adx 去请求广告 --> 拿到广告之后回调
     */
    protected InternalAdListener mInternalListener = new InternalAdListener() {

        @Override
        public void onAdResponse(List<AdsDTO> adBeanList) {
            if (adBeanList != null && adBeanList.size() > 0 && adBeanList.get(0) != null &&
                    adBeanList.get(0).getImpBeanRequest() != null) {
                adBeanList.get(0).getImpBeanRequest().isTimeOut = isTimeout ? 1 : 0;
                // 遍历广告集合设置source
                for (AdsDTO adsDTO : adBeanList) {
                    setAdSource(adsDTO);
                    adsDTO.setTriggerId(mTriggerId);
                }
            }
            super.onAdResponse(adBeanList);
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (adBeanList == null && adBeanList.size() <= 0) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "adList is empty");
                return;
            }
            onAdResponseStub(adBeanList);
            //Adx Tracker, load ad success
            if (adBeanList.get(0) != null) {
                mRid = adBeanList.get(0).getRid();
            }
        }

        @Override
        public void onSplashCacheGet(List<AdsDTO> adBeans) {
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            onSplashCacheGetStub(adBeans);
        }

        @Override
        public void onAdLoaded() {
            isLoading = false;
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (runTimer != null) {
                runTimer.resetTimerTask();
            }
            onAdLoadedStub();
            mLoaded = true;
            AthenaTracker.trackAdFillingResult(getAdBean(), mTriggerId, mTriggerNetState);
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdLoaded");
                mListener.onAdLoaded();
            }
            ConfigManager.getInstance().requestCloudControl(Constants.TriggerType.TRIGGER_AD_RETURN);
        }

        @Override
        public void onAdLoaded(List<TaNativeInfo> nativeInfos) {
            isLoading = false;
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (runTimer != null) {
                runTimer.resetTimerTask();
            }
            onAdLoadedStub(nativeInfos);

            StringBuilder icon = new StringBuilder();
            StringBuilder image = new StringBuilder();
            for (TaNativeInfo nativeInfo : nativeInfos) {
                if (nativeInfo != null) {
                    icon.append(nativeInfo.getIconImage() != null && nativeInfo.getIconImage().isCached() ? "1" : "0");
                    image.append(nativeInfo.getImage() != null && nativeInfo.getImage().isCached() ? "1" : "0");
                    String mime = nativeInfo.getImage() != null ? nativeInfo.getImage().getMime() + "" : "1";
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "Track_native_fill=" + mime);
                }
            }
            mLoaded = true;
            if (mListener != null && nativeInfos != null) {
                AthenaTracker.trackAdFillingResult(getAdBean(), mTriggerId, mTriggerNetState);
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdLoaded TadNativeInfos size is:=" + nativeInfos.size());
                List<TaNativeInfo> adInfos = AdInfoTransfer.getAdInfo(nativeInfos);
                if (adInfos != null && nativeInfos.size() > 0) {
                    mListener.onAdLoaded(adInfos);
                }
            }
            ConfigManager.getInstance().requestCloudControl(Constants.TriggerType.TRIGGER_AD_RETURN);
        }

        @Override
        public void onError(TaErrorCode adError) {
            isLoading = false;
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (runTimer != null) {
                runTimer.resetTimerTask();
            }
            onErrorStub(adError);
            AthenaTracker.trackAdFillingResult(null, mTriggerId, mTriggerNetState);
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "adError：=" + adError.getErrorMessage());
                mListener.onError(adError);
            }
        }

        @Override
        public void onErrorInternal(List<AdsDTO> adBeans, TaErrorCode adError, AdxImpBean adxImpBean) {
            adxImpBean.isTimeOut = isTimeout ? 1 : 0;
            super.onErrorInternal(adBeans, adError, adxImpBean);
            if (isLoadedOffline) {
                onError(adError);
            } else {
                loadOfflineAd();
            }

        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
            onAdClickStub();
            mClicked = true;
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdClicked");
                mListener.onAdClicked(pointBean);
            }
        }

        @Override
        public void onAdClosed() {
            onAdClosedStub();
            AthenaTracker.trackSspCloseAd(getAdBean());
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdClosed");
                mListener.onAdClosed();
            }
        }

        @Override
        public void onAdShow() {
            onAdShowStub();
            adShowCount.decrementAndGet();
            if (mListener != null && !mShowed) {
                mShowed = adShowCount.get() <= 0;
                CommonLogUtil.Log().d(CommonLogUtil.TAG, "onAdShow");
                mListener.onAdShow();
            }
        }

        @Override
        public void onTimeOut() {
            onAdTimeoutStub();
        }

        @Override
        public void onMediaDownloaded(TaNativeInfo adInfo) {
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onMediaDownloaded");
                mListener.onMediaDownloaded(adInfo);
            }
        }
    };


    /**
     * 定义一套回调 给子类使用
     * 网络请求回来之后 回调给子类
     */
    protected void onAdClickStub() {
    }

    protected void onAdLoadedStub() {
    }

    protected void onAdLoadedStub(List<TaNativeInfo> nativeInfos) {
    }

    protected void onAdClosedStub() {
    }

    protected void onAdTimeoutStub() {
        isTimeout = true;
        if (mListener != null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "onTimeOut");
            mListener.onTimeOut();
        }
    }

    protected void onSplashCacheGetStub(List<AdsDTO> adBeans) {
    }

    protected void onErrorStub(TaErrorCode adError) {
    }

    protected void onAdShowStub() {
    }

    protected void onAdResponseStub(List<AdsDTO> adBeanList) {

    }


    // =============================================================================================


    public BaseAd(int adType, String placementId) {
        this.mPlacementId = placementId;
        mSdkVersion = BuildConfig.VERSION_NAME;
    }


    // =============================================================================================


    public abstract void setPlacementId(String placementId);

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public void setOfflineAd(boolean isOfflineAd) {
        this.isOfflineAd = isOfflineAd;
    }

    public void setTriggerId(String triggerId) {
        this.mTriggerId = triggerId;
    }

    /**
     * 加载广告 各自子类实现加载 --> Adx 加载
     *
     * @return
     */
    protected abstract boolean loadPolyAd();

    //获取广告类型
    public abstract int getAdType();

    public String placementId() {
        return mPlacementId;
    }

    public InternalAdListener adListener() {
        return mInternalListener;
    }

    public void setListener(AdListener listener) {
        this.mListener = listener;
    }

    // =============================================================================================

    public void loadAd(String requestId) {
        this.mRequestId = requestId;
        if (TextUtils.isEmpty(mTriggerId)) {
            this.mTriggerId = TrackingUtil.getTriggerId();
        }
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                loadAdInternal();
            }
        });
    }

    public void loadAd() {
        if(isLoading){
            return;
        }
        this.mTriggerId = TrackingUtil.getTriggerId();
        mRequestId = DeviceUtil.getUUID();
        loadAd(mRequestId);
    }

    public void loadAdInternal() {
        isLoading = true;
        ConfigProviderManager.getInstance().getConfigById(mPlacementId, new ConfigProviderManager.ConfigCachedListener() {
            @Override
            public void onConfigLoad(ConfigCodeSeatDTO codeSeatDTO) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "loadAdInternal ");
                if (codeSeatDTO == null) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "当前代码位不存在 ----->" + mPlacementId);
                    mInternalListener.onError(TaErrorCode.CONFIG_IS_NOT_EXIT_ERROR);
                    isLoading = false;
                    return;
                }
                if (codeSeatDTO.getAdShowCountLimit() > -1 && codeSeatDTO.getCurrentShowTimes() >= codeSeatDTO.getAdShowCountLimit()) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "当前代码位展示次数达到上限 ----- 已展示次数=" + codeSeatDTO.getCurrentShowTimes() + "  展示上限=" + codeSeatDTO.getAdShowCountLimit());
                    mInternalListener.onError(TaErrorCode.CONFIG_SHOW_COUNT_LIMIT_ERROR);
                    isLoading = false;
                    return;
                }
                if (!NetUtil.checkNetworkState() || isOfflineAd) {
                    resetFlag();
                    runTimerTask();
                    loadOfflineAd();
                    //媒体调用请求埋点
                    mTriggerNetState = Constants.TriggerNetState.TRIGGER_NO_NET;
                    AthenaTracker.trackMediaCallRequest(getAdType(), mTriggerId, mPlacementId, adCount, mTriggerNetState);
                    return;
                }
                //媒体调用请求埋点
                mTriggerNetState = Constants.TriggerNetState.TRIGGER_NET;
                AthenaTracker.trackMediaCallRequest(getAdType(), mTriggerId, mPlacementId, adCount, mTriggerNetState);
                if (loadPolyAd()) {
                    resetFlag();
                    runTimerTask();
                }
            }
        });
    }

    public void setShowCount(int showCount) {
        if (showCount == 0) {
            showCount = 1;
        }
        if (adShowCount != null) {
            adShowCount.set(showCount);
        }
    }

    public void setOneByOne(boolean oneByOne) {
        this.oneByOne = oneByOne;
    }

    protected void onLoaded() {
        resetTimerTask();
        mLoaded = true;
    }

    private void resetFlag() {
        isTimeout = false;
        mLoaded = false;
        mShowed = false;
        mClicked = false;
        isLoadedOffline = false;
    }

    /**
     * 启动定时器
     */
    protected void runTimerTask() {
        if (runTimer != null) {
            isTimeout = false;
            runTimer.resetTimerTask();
            runTimer.setTimeOutCallback(timeOutCallback);
            runTimer.setScheduleTime(scheduleTime);
            runTimer.runTimerTask();
        }
    }

    protected void resetTimerTask() {
        if (runTimer != null) {
            runTimer.resetTimerTask();
        }
    }

    /**
     * 加载离线广告
     */
    protected void loadOfflineAd() {
        isLoadedOffline = true;
        OfflineProviderManager.getInstance().getAdByCodeSeatId(mPlacementId, new OfflineProviderManager.LoadAdListener() {
            @Override
            public void onAdLoadFromDisk(AdsDTO adsDTO) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "当前离线广告 == " + GsonUtil.toJson(adsDTO));
                final List<AdsDTO> adsDTOList = new ArrayList<>();
                adsDTOList.add(adsDTO);
                if (adsDTO == null || adsDTOList.isEmpty()) {
                    mInternalListener.onError(TaErrorCode.NO_AD);
                } else {
                    mInternalListener.onAdResponse(adsDTOList);
                }
            }
        });
    }

    /**
     * 超时回调
     */
    private final RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback() {
        @Override
        public void isTimeOut() {
            isLoading = false;
            if (mInternalListener != null) {
                mInternalListener.onTimeOut();
            }
        }
    };

    public void destroy() {
        resetTimerTask();
        resetFlag();
        mListener = null;
    }

    protected abstract AdsDTO getAdBean();

    /**
     * 提供接口告知媒体填充的广告是属于离线还是在线广告
     *
     * @return 1 离线广告 0 在线广告 -1无填充
     */
    public int getFillAdType() {
        if (getAdBean() != null && getAdBean().getImpBeanRequest() != null) {
            return getAdBean().getImpBeanRequest().offlineAd ? 1 : 0;
        }
        return -1;
    }

    /**
     * 设置广告source
     *
     * @param adsDTO
     */
    private void setAdSource(AdsDTO adsDTO) {
        if (adsDTO == null) {
            return;
        }
        int source;
        if (mTriggerNetState == 1) {
            source = Constants.FillingSource.OFFLINE_CACHE_AD;
        } else {
            source = adsDTO.isOfflineAd() ? Constants.FillingSource.ONLINE_CACHE_AD : Constants.FillingSource.REQUEST_AD;
        }
        adsDTO.setSource(source);
    }
}
