package com.cloud.hisavana.sdk.internal.interstitial;

import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.PARSE_BITMAP_ERROR;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.activity.TAdInterstitialActivity;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.TadmWebView;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.AppUtil;
import com.transsion.core.utils.NetUtil;

import java.io.ByteArrayInputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

/**
 * Created by jianbing.yu on 2019/3/27.
 */
public class InterstitialGemini {

    private InterstitialAdBroadcastReceiver receiver;
    private final TranInterstitial mInterstitial;
    private AdsDTO mAdBean;
    private WebView webView;
    //请求adm开始时间
    long startTime = 0L;

    // =============================================================================================


    public InterstitialGemini(TranInterstitial interstitial) {
        this.mInterstitial = interstitial;
    }

    /**
     * 插屏广告是一个独立的Activity 这里用广播通讯
     */
    private static class InterstitialAdBroadcastReceiver extends BroadcastReceiver {

        private final WeakReference<InterstitialGemini> weakReference;
        private final WeakReference<AdListener> listener;

        InterstitialAdBroadcastReceiver(InterstitialGemini gemini, AdListener tAdListener) {
            weakReference = new WeakReference<>(gemini);
            listener = new WeakReference<>(tAdListener);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                InterstitialGemini gemini = weakReference.get();
                if (gemini != null) {
                    if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLICK)) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"receive interstitial click");
                        if (weakReference.get() != null) {
                            DownUpPointBean pointBean = (DownUpPointBean) intent.getSerializableExtra("pointBean");
                            AdsDTO adsDTO = (AdsDTO) intent.getSerializableExtra("mAdBean");
                            if (adsDTO != null){
                                gemini.mAdBean = adsDTO;
                            }
                            weakReference.get().clickToLandingPage(pointBean);
                        }

                        if (listener.get() != null) {
                            DownUpPointBean pointBean = (DownUpPointBean) intent.getSerializableExtra("pointBean");
                            listener.get().onAdClicked(pointBean);
                        }

                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLOSE)) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"receive interstitial ad_close");
                        if (listener.get() != null) {
                            listener.get().onAdClosed();
                            gemini.unRegisterInterstitalAdReceiver();
                            gemini.receiver = null;
                        }
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ERROR)) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"receive interstitial error");
                        if (listener.get() != null) {
                            listener.get().onError(new TaErrorCode(intent.getIntExtra(TAdInterstitialActivity.ERROR_CODE, TaErrorCode.UNKNOWN_ERROR_CODE_2),
                                    intent.getStringExtra(TAdInterstitialActivity.ERROR_MSG)));
                        }
                        gemini.unRegisterInterstitalAdReceiver();
                        gemini.receiver = null;
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_SHOW)) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"receive interstitial show");
                        if (listener.get() != null) {
                            listener.get().onAdShow();
                        }
                        //gemini.mInterstitial.polyInterstitial().impressionTrack(gemini.mAdBean);
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_PREIMP)) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"receive interstitial pre impression");
                    } /*else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK)) {
                        SLogUtil.Log().d(AdLogUtil.TAG,"receive interstitial adchocie click");
//                        if (listener.get() != null) listener.get().onAdChoiceClick();
                    }*/
                }
            }
        }
    }

    private void clickToLandingPage(DownUpPointBean pointBean) {
        PlatformUtil.startLandingPage(CoreUtil.getContext(), mAdBean, pointBean);
    }

    public void loadAd() {
        mAdBean = mInterstitial.adBean();
        if (mAdBean != null) {
            if (TextUtils.isEmpty(mAdBean.getAdm())) {
                loadNormalAd();
            } else {
                loadAdmAd();
            }
        } else {
            if (mInterstitial.adListener() != null) {
                mInterstitial.adListener().onError(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_2, "mAdBean is null"));
            }
        }
    }

    private void loadNormalAd(){
        AdLogUtil.Log().d(CommonLogUtil.TAG,"interstitial loadNormalAd");
        //图片插屏 1.5 版本之后 取值调整 加载主图片
        if (!TextUtils.isEmpty(mAdBean.getAdImgUrl())) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"imageView impression");
            ImageDownloadHelper.downloadImage(mAdBean.getAdImgUrl(),
                    Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean,
                    AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {

                        @Override
                        public void onImagesCached(byte[] data) {
                            if (mInterstitial.adListener() != null) {
                                mInterstitial.adListener().onAdLoaded();
                                PlatformUtil.downLoadFormUrl(mAdBean);
                            }
                        }

                        @Override
                        public void onImagesFailedToCache(TaErrorCode errorCode) {
                            if (mInterstitial.adListener() != null) {
                                mInterstitial.adListener().onError(errorCode);
                            }
                        }
                    });
        } else {
            if (mInterstitial.adListener() != null) {
                mInterstitial.adListener().onError(TaErrorCode.INVALID_CRVT_TYPE);
            }
        }
    }

    private void loadAdmAd() {
        AdLogUtil.Log().d(CommonLogUtil.TAG, "interstitial loadAdmAd");
        if (!NetUtil.checkNetworkState()) {
            return;
        }
        if (mAdBean == null) {
            return;
        }
        String adm = mAdBean.getAdm();
        webView = new TadmWebView(CoreUtil.getContext());
        webView.setWebViewClient(new WebViewClient() {
            boolean isRequestFailed = false;

            @Override
            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                if (null == url){
                    return super.shouldInterceptRequest(view,url);
                }
                if (url.contains(TrackingManager.AUCTION_PRICE)
                        && (url.startsWith("http") || url.startsWith("https"))) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG,"InterstitialGemini shouldInterceptRequest,show url is " + url);
                    if (mAdBean.getShowTrackingUrls() == null){
                        mAdBean.setShowTrackingUrls(new ArrayList<String>());
                    }
                    mAdBean.getShowTrackingUrls().add(url);
                    WebResourceResponse webResourceResponse = new WebResourceResponse("text/html", "utf-8",new ByteArrayInputStream("".getBytes()));
                    return webResourceResponse;
                }
                return super.shouldInterceptRequest(webView,url);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                //onPageFinished有可能在重定向的时候多次调用，
                //&& view!=null && view.getProgress() == 100
                if (mInterstitial.adListener() != null && view!=null && view.getProgress() == 100) {
                    if (isRequestFailed) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG, "InterstitialGemini onPageFinished isRequestFailed");
                        mInterstitial.adListener().onError(new TaErrorCode(PARSE_BITMAP_ERROR,
                                "download resource error"));
                        AthenaTracker.trackImageDownload(mAdBean,AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,AthenaTracker.M_STATUS_ERROR,"",AthenaTracker.M_TYPE_LARGE_IMG,System.currentTimeMillis() - startTime);
                    } else {
                        mInterstitial.adListener().onAdLoaded();
                        AdLogUtil.Log().d(CommonLogUtil.TAG, "InterstitialGemini onPageFinished");
                        AthenaTracker.trackImageDownload(mAdBean,AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,AthenaTracker.M_STATUS_SUCCESS,"",AthenaTracker.M_TYPE_LARGE_IMG,System.currentTimeMillis() - startTime);
                    }
                }
            }

            @Override
            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                isRequestFailed = true;
                if (null != request) {
                    AdLogUtil.Log().e(CommonLogUtil.TAG,
                            "InterstitialGemini onReceivedHttpError " + request.getUrl());
                } else {
                    AdLogUtil.Log().e(CommonLogUtil.TAG,
                            "InterstitialGemini onReceivedHttpError,request is null");
                }
            }

            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                isRequestFailed = true;
                if (null != request) {
                    AdLogUtil.Log().e(CommonLogUtil.TAG,
                            "InterstitialGemini onReceivedError " + request.getUrl());
                } else {
                    AdLogUtil.Log().e(CommonLogUtil.TAG,
                            "InterstitialGemini onReceivedError,request is null");
                }

            }
        });
        String html = adm.replace("<img", "<img style=\"max-width:100%;max-height: 100%;\"");
        webView.loadData(html, "text/html", "utf-8");
        startTime = System.currentTimeMillis();
    }
    public void show() {
        if (mAdBean==null){
            AdLogUtil.Log().d(CommonLogUtil.TAG,"show() --> mAdBean == null");
            return;
        }
        if (TextUtils.isEmpty(mAdBean.getAdm())){
            showNormalAd();
        }else {
            showAdmAd();
        }
    }

    private void showNormalAd() {
        AdLogUtil.Log().d(CommonLogUtil.TAG,"interstitial showNormalAd");
        if (receiver == null) {
            receiver = new InterstitialAdBroadcastReceiver(InterstitialGemini.this, mInterstitial.adListener());
        }
        registerInterstitialAdReceiver();

        // 1.5版本新增 广告位类型
        Intent intent = new Intent(CoreUtil.getContext(), TAdInterstitialActivity.class);

        intent.setFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION | Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("mAdBean", mAdBean);
        intent.putExtra("BroadCastPrefix", getBroadCastPrefix());
        CoreUtil.getContext().startActivity(intent);
    }

    private void showAdmAd() {
        AdLogUtil.Log().d(CommonLogUtil.TAG,"interstitial showAdmAd");
        if (receiver == null) {
            receiver = new InterstitialAdBroadcastReceiver(InterstitialGemini.this, mInterstitial.adListener());
        }
        registerInterstitialAdReceiver();
        TAdInterstitialActivity.webView = webView;
        Intent intent = new Intent(CoreUtil.getContext(), TAdInterstitialActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION | Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra("mAdBean", mAdBean);
        intent.putExtra("BroadCastPrefix", getBroadCastPrefix());
        CoreUtil.getContext().startActivity(intent);
    }
    private void registerInterstitialAdReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLICK);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLOSE);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_SHOW);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_PREIMP);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ERROR);
        CoreUtil.getContext().registerReceiver(receiver, intentFilter);
        AdLogUtil.Log().d(CommonLogUtil.TAG,"registerInterstitialAdReceiver");
    }

    public void destroy() {
        unRegisterInterstitalAdReceiver();
        AdLogUtil.Log().d(CommonLogUtil.TAG,"destroy");
    }

    private String getBroadCastPrefix() {
        if (mAdBean != null) {
            return AppUtil.getPkgName() + "_adx_" + mAdBean.getId(); //例如：com.transsion.hilauncher_adx_1_show
        }
        return null;
    }

    private void unRegisterInterstitalAdReceiver() {
        if (receiver != null) {
            CoreUtil.getContext().unregisterReceiver(receiver);
            receiver = null;
        }
    }
}
