package com.cloud.hisavana.sdk.manager;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.ad.base.PostBody;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.AdServerRequest;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.response.ConfigCodeSeatDTO;
import com.cloud.hisavana.sdk.data.bean.response.ConfigResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.ConfigTotalDTO;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.transsion.core.utils.NetUtil;

import java.util.Collection;
import java.util.Map;

public class ConfigManager {
    private static final String TAG = "ConfigManager";
    private static volatile ConfigManager sInstance;
    private boolean isConfigRequesting;
    private String curVersion;
    private long lastRequestTime;
    private static final long THREE_DAYS_TIME = 3 * 24 * 60 * 60 * 1000;

    private ConfigManager() {
    }

    public static ConfigManager getInstance() {
        if (sInstance == null) {
            synchronized (ConfigManager.class) {
                if (sInstance == null) {
                    sInstance = new ConfigManager();
                }
            }
        }
        return sInstance;
    }

    public void requestCloudControl(final int type) {
        AdLogUtil.Log().d(TAG, "requestCloudControl type " + type);
        final String requestId = DeviceUtil.getUUID();
        if (!NetUtil.checkNetworkState() || isConfigRequesting) {
            //无网络条件不请求云控
            //正在请求中 不请求云控
            AdLogUtil.Log().e(TAG, "requestCloudControl net is not available,or is requesting");
            return;
        }
        if (curVersion == null) {
            curVersion = AdxPreferencesHelper.getInstance().getString(Constants.HISAVANA_CLOUD_CONTROL_VERSION, null);
        }
        if (curVersion == null) {
            WorkThread.getInstance().post(new Runnable() {
                @Override
                public void run() {
                    request(type, requestId);
                }
            });
            return;
        }
        String newVersion = AdxPreferencesHelper.getInstance().getString(Constants.PREF_NEW_HISAVANA_CLOUD_CONTROL_VERSION);
        if (TextUtils.equals(newVersion, curVersion)) {
            if (lastRequestTime == 0) {
                lastRequestTime = AdxPreferencesHelper.getInstance().getLong(Constants.REQUEST_CONFIG_TIME, 0);
            }
            long current = System.currentTimeMillis();
            if (current - lastRequestTime > THREE_DAYS_TIME) {
                WorkThread.getInstance().post(new Runnable() {
                    @Override
                    public void run() {
                        request(type, requestId);
                    }
                });
            } else {
                AdLogUtil.Log().e(TAG, "time is not ready");
                WorkThread.getInstance().post(new Runnable() {
                    @Override
                    public void run() {
                        Map<String, ConfigCodeSeatDTO> map = ConfigProviderManager.getInstance().getAllConfigAtSubThread();
                        if (map != null && !map.isEmpty()) {
                            downLoadAdOrMaterial(map.values(), type);
                        }
                    }
                });
            }
        } else {
            WorkThread.getInstance().post(new Runnable() {
                @Override
                public void run() {
                    request(type, requestId);
                }
            });
        }
    }


    private void request(final int type, final String requestId) {
        if(isConfigRequesting){
            AdLogUtil.Log().d(TAG, "config is requesting");
            return;
        }
        AdLogUtil.Log().d(TAG, "request type " + type);
        isConfigRequesting = true;
        AthenaTracker.trackConfigRequest(type, requestId);
        final long startTime = System.currentTimeMillis();
        AdServerRequest adServerRequest = new AdServerRequest().setListener(new CommonResponseListener<ConfigResponseBody>() {
            @Override
            protected void onRequestSuccess(int statusCode, final ConfigResponseBody response) {
                final long interval = System.currentTimeMillis() - startTime;
                isConfigRequesting = false;
                AdLogUtil.Log().d(TAG, "onRequestSuccess statusCode " + statusCode);
                //保存请求云控成功时间
                lastRequestTime = System.currentTimeMillis();
                AdxPreferencesHelper.getInstance().putLong(Constants.REQUEST_CONFIG_TIME, lastRequestTime);
                if (response != null && response.getCode() == Constants.ResponseCode.BUSINESS_SUCCESS_CODE) {
                    ConfigTotalDTO data = response.getData();
                    AthenaTracker.trackConfigResponse(type, requestId, (int) interval, 0, "", curVersion);
                    if (response.getData() != null && response.getData().getCodeSeats() != null && response.getData().getCodeSeats().size() > 0) {
                        boolean insertResult = ConfigProviderManager.getInstance().insertAtSubThread(response.getData().getCodeSeats());
                        if (insertResult){
                            curVersion = data.getCloudControlVersion();
                            //保存hisavana云控版本
                            AdxPreferencesHelper.getInstance().putString(Constants.HISAVANA_CLOUD_CONTROL_VERSION, curVersion);
                        }
                        downLoadAdOrMaterial(response.getData().getCodeSeats(), type);
                    }
                } else {
                    AthenaTracker.trackConfigResponse(type, requestId, (int) interval, 1, "response is null or responseCode is wrong", "");
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                long interval = System.currentTimeMillis() - startTime;
                AthenaTracker.trackConfigResponse(type, requestId, (int) interval, 1, adError == null ? "request error" : adError.getErrorMessage(), "");
                isConfigRequesting = false;
            }

        }).setPostBody(new AdServerRequest.IAdPostBody() {
            @Override
            public String getPostBody() {
                return PostBody.getConfigPostBody();
            }
        }).setDebug(AdManager.isDebug())
                .setUrl(AdxServerConfig.getServerUrl() + AdxServerConfig.getConfigApi());
        if (adServerRequest != null) {
            adServerRequest.netRequestPreExecute();
        }
    }

    private void downLoadAdOrMaterial(Collection<ConfigCodeSeatDTO> list, int type) {
        OfflineAdManager.getInstance().startDownloadAd(list, type);
    }
}
