package com.cloud.hisavana.sdk.manager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.sdk.commonutil.util.MitNetUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;

public class NetStateManager {
    private static BroadcastReceiver sMonitorReceiver;
    private static long lastReceiverTs = 0;
    private static final int PROTECTION_TIME = 10 * 1000;
    private static final String TAG = "NetStateManager";

    /**
     * 网络链接广播监听
     */
    static final class MonitorReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            if (ConnectivityManager.CONNECTIVITY_ACTION.equals(intent.getAction())) {
                AdLogUtil.Log().d(TAG,"onReceive ");
                //网络监听，注册后会立马收到广播，对于这种广播丢弃
                long current = System.currentTimeMillis();
                if (Math.abs(current - lastReceiverTs) > PROTECTION_TIME) {
                    if (MitNetUtil.isNetworkAvailable(CoreUtil.getContext())) {
                        lastReceiverTs = current;
                        AdLogUtil.Log().d(TAG, "receive Network connected...");
                        ConfigManager.getInstance().requestCloudControl(Constants.TriggerType.TRIGGER_NET_CHANGE);
                    }
                }
            }
        }
    }

    /**
     * 注册网络状态 广播
     */
    public static void registerMonitorBroadcast() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            if (sMonitorReceiver == null) {
                sMonitorReceiver = new MonitorReceiver();
                CoreUtil.getContext().registerReceiver(sMonitorReceiver, new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
                lastReceiverTs = System.currentTimeMillis();
                AdLogUtil.Log().d(TAG, "register Network broadcast...");
            }
        }
    }
}
