package com.cloud.hisavana.sdk.manager;


import static com.cloud.hisavana.sdk.common.constant.Constants.WORK_THREAD_NAME;

import android.os.Handler;
import android.os.HandlerThread;

public class WorkThread {
    private static volatile WorkThread sInstance;
    private Handler mWorkHandler;
    private WorkThread() {
        HandlerThread workThread = new HandlerThread(WORK_THREAD_NAME);
        workThread.start();
        mWorkHandler = new Handler(workThread.getLooper());
    }

    public void post(Runnable runnable){
        if(mWorkHandler != null){
            mWorkHandler.post(runnable);
        }
    }

    public static WorkThread getInstance() {
        if (sInstance == null) {
            synchronized (WorkThread.class) {
                if (sInstance == null) {
                    sInstance = new WorkThread();
                }
            }
        }
        return sInstance;
    }
}
