package com.cloud.hisavana.sdk.ad;



import static com.cloud.sdk.commonutil.util.CommonLogUtil.SPLASH_TAG;

import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.ad.base.OnlineAdFetch;
import com.cloud.hisavana.sdk.ad.base.PostBody;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.AdServerRequest;
import com.cloud.hisavana.sdk.common.http.ServicesTimeUtil;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.DiskAdBean;
import com.cloud.hisavana.sdk.data.control.AdBodyPersistenceHelper;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jianbing.yu on 2019/3/7.
 */
public class OnlineSplashFetch extends OnlineAdFetch {
    public OnlineSplashFetch(String placementId) {
        super(placementId, Constants.AdType.SPLASH_NATIVE);
    }

    private int adListSize = 0; // 当前缓存的广告条数  用于判断是否需要网络请求更多的数据

    public int getAdListSize() {
        return adListSize;
    }

// =============================================================================================


    /**
     * 重写父类的方法
     *
     * @return
     */
    @Override
    public boolean loadAd(final String requestId,int requestType,final String triggerId) {
        AdsDTO adItem = null;
        adListSize = 0;
        // 从缓存中获取广告数据
        adItem = getSplashItem(mPlacementId);
        if (adItem != null) {
            // 使用当前创建的 request_id 覆盖下载的时候的request_id
            AdxImpBean impBeanRequest = adItem.getImpBeanRequest();
            if (null != impBeanRequest){
                impBeanRequest.requestId = requestId;
                impBeanRequest.triggerId = triggerId;
            }
            List<AdsDTO> adBeanList = new ArrayList<>();
            adBeanList.add(adItem);
            // 从缓存中获取到数据
            AdLogUtil.Log().d(SPLASH_TAG,"*----> loadAd() - from splash cache success," +
                    " mPlacementId = " + mPlacementId +
                    " getSplashItem --> adItem=" + adItem);
            mBridgeListener.onSplashCacheGet(adBeanList);
            return true;
        }
        return false;
    }


    // =============================================================================================


    public AdsDTO getSplashItem(String key) {
        String jsonStr = AdBodyPersistenceHelper.getInstance().getString(key, null);

        if (!TextUtils.isEmpty(jsonStr)) {
            try {
                // 数据容器
                List<AdsDTO> list = new ArrayList<>();
                // 1.取出数据
                DiskAdBean diskAdBean = GsonUtil.fromJson(jsonStr, DiskAdBean.class);
                // 判空
                if (diskAdBean == null || diskAdBean.getList() == null || diskAdBean.getList().size() == 0) {
                    return null;
                }
                List<AdsDTO> dtoList = diskAdBean.getList();
                // 2.过期排查
                for (AdsDTO ob : dtoList) {
                    if (ob == null) {
                        continue;
                    }
                    if (isAdValid(ob)) {
                        AdLogUtil.Log().d(SPLASH_TAG,"*----> AdxSplash - getSplashItem() - ad in splash pool, ad id=" + ob.getId());
                        list.add(ob);
                    }
                }

                // 5.保存一下 当前全局的广告素材的数量
                adListSize = list.size();
                AdLogUtil.Log().d(SPLASH_TAG,"*----> AdxSplash -getSplashItem()，ad in splash pool, adListSize=" + adListSize);

                // 优化
                if (list.size() == dtoList.size()) {
                    AdLogUtil.Log().d(SPLASH_TAG,"No expiration，directly returns the first data");
                    return list.get(0);
                }

                // 4.将检查后的数据保存起来
                if (SplashNetRequest.cacheSplashList(key, list, false)) {
                    AdLogUtil.Log().d(SPLASH_TAG,"getSplashItem()，Save the checked data，remove the expired data，overwrite and save");
                    return list.get(0);
                }

            } catch (Throwable e) {
                e.printStackTrace();
                AdLogUtil.Log().e("getSplashItem(),Parsing exception mag=" + Log.getStackTraceString(e));
            }
        }
        return null;
    }

    /**
     * 广告有效
     */
    private boolean isAdValid(AdsDTO adItem) {
        return AdsConfig.isAdValid(adItem);
    }


    // =============================================================================================


    /**
     * 内部类 请求网络+获取本地缓存
     */
    public static class SplashNetRequest {

        private static AdServerRequest sAdServerRequest = null;

        /**
         * 缓存 List 数据
         *
         * @param placementId
         * @param adItem
         * @return
         */
        public static boolean cacheSplashList(String placementId, List<AdsDTO> adItem, boolean isNetwork) {
            boolean flag = true;

            if (adItem != null) {
                try {
                    DiskAdBean diskAdBean = new DiskAdBean();
                    // 如果是 网络请求追加的话 先获取原始数据 追加之后在保存
                    if (isNetwork) {
                        String jsonStr = AdBodyPersistenceHelper.getInstance().getString(placementId, null);
                        if (!TextUtils.isEmpty(jsonStr)) {
                            try {
                                //DiskAdBean diskAdBean2 = Tson.fromJson(jsonStr, DiskAdBean.class);
                                DiskAdBean diskAdBean2 = GsonUtil.fromJson(jsonStr, DiskAdBean.class);
                                List<AdsDTO> object = diskAdBean2.getList();
                                // 追加
                                if (object != null) {
                                    AdLogUtil.Log().d(SPLASH_TAG,"*----> cacheSplashList - data cache before - ad in splash pool list=" + object.size());
                                    object.addAll(adItem);
                                    //diskAdBean.list=object;
                                    diskAdBean.setList(object);
                                } else {
                                    diskAdBean.setList(adItem);
                                    //diskAdBean.list=adItem;
                                }
                            } catch (Throwable e) {
                                AdLogUtil.Log().e(SPLASH_TAG,"cacheSplashList --> getSplashItem --> Parsing exception msg=" + Log.getStackTraceString(e));
                                diskAdBean.setList(adItem);
                            }
                        } else {
                            diskAdBean.setList(adItem);
                            //diskAdBean.list = adItem;
                        }

                    } else {
                        //diskAdBean.list = adItem;
                        diskAdBean.setList(adItem);
                    }
                    AdLogUtil.Log().d(SPLASH_TAG,"*----> ad in splash pool list=" + diskAdBean.getList().size());
                    // 将数据保存到磁盘
                    //String jsonStr = Tson.toJson(diskAdBean);//JsonHelper.parseObjectToJsonStr(ad);
                    String jsonStr = GsonUtil.toJson(diskAdBean);//JsonHelper.parseObjectToJsonStr(ad);

                    AdBodyPersistenceHelper.getInstance().putString(placementId, jsonStr);
                } catch (Throwable e) {
                    e.printStackTrace();
                    flag = false;
                    AdLogUtil.Log().e(SPLASH_TAG,"cacheSplashList - data cache fail --> msg=" + Log.getStackTraceString(e));
                }
            } else {
                AdLogUtil.Log().d(SPLASH_TAG,"cacheSplashList - The data to be cached is empty");
            }
            return flag;
        }

        /**
         * 广告网络请求
         *
         * @param splashListener
         * @return
         */
        public static boolean loadByNet(final InternalAdListener splashListener, final AdxImpBean adxImpBean) {
            if (sAdServerRequest != null) {
                AdLogUtil.Log().d(SPLASH_TAG,"Splash ad is being request,current request will be drop");
                return false;
            }
            sAdServerRequest = new AdServerRequest().setListener(new CommonResponseListener<AdResponseBody>() {
                @Override
                protected void onRequestSuccess(int statusCode, AdResponseBody response) {

                    // 保存服务器时间
                    ServicesTimeUtil.saveServicesTime(response);

                    /**
                     * 业务成功
                     */
                    if (response != null && response.getCode() == Constants.ResponseCode.BUSINESS_SUCCESS_CODE) {
                        if (response.getData() != null && response.getData().getAds() != null && response.getData().getAds().size() > 0) {
                            List<AdsDTO> mAdBeans = response.getData().getAds();
                            for (AdsDTO adBean : mAdBeans) {
                                if (adBean != null) {
                                    adBean.setFill_ts(System.currentTimeMillis());
                                    adBean.setCacheTime(response.getData().getCacheTime());
                                    adBean.setAbTest(response.getData().getAbTest());
                                    adBean.setExtInfo(response.getData().getExtInfo());
                                    adBean.setImpBeanRequest(adxImpBean);
                                }
                            }
                            if (splashListener != null) {
                                // 网络请求成功
                                splashListener.onAdResponse(mAdBeans);
                            }
                        } else {
                            //没有AD数据
                            AdLogUtil.Log().d(SPLASH_TAG,"AdxSplash，no ad return，RESPONSE_AD_IS_EMPTY，a ds list is empty ");

                            if (splashListener != null) {
                                splashListener.onError(TaErrorCode.RESPONSE_AD_IS_EMPTY);
                            }
                        }
                    } else {

                        //业务错误
                        AdLogUtil.Log().d(SPLASH_TAG,"AdxSplash，Business error ");
                        AdLogUtil.Log().d(SPLASH_TAG,response != null ? "error,response code is :" + response.getCode() + "," + "response msg is " + response.getMessage() : "error, response is null");

                        if (splashListener != null) {
                            if (response != null) {
                                splashListener.onError(new TaErrorCode(response.getCode(), response.getMessage()));
                            } else {
                                splashListener.onError(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_1, "response is null"));
                            }
                        }
                    }
                    sAdServerRequest = null;
                }

                @Override
                public void onRequestError(TaErrorCode adError) {
                    AdLogUtil.Log().d(SPLASH_TAG,"load splash ad from network fail，adError=" + adError);

                    if (splashListener != null) {
                        splashListener.onError(adError);
                    }
                    sAdServerRequest = null;
                }

            }).setPostBody(new AdServerRequest.IAdPostBody() {
                @Override
                public String getPostBody() {
                    return PostBody.getAdPostBody(adxImpBean);
                }
            })
                    .setDebug(AdManager.isDebug())
                    .setUrl(AdxServerConfig.getServerUrl() + AdxServerConfig.getServerApi())
                    .setPlacementId(adxImpBean.pmid)
            .setAdxImpBean(adxImpBean);
            if (sAdServerRequest != null) {
                sAdServerRequest.netRequestPreExecute();
            }
            return true;
        }

    }

}

