package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.hisavana.sdk.internal.banner.TranBanner;
import com.cloud.sdk.commonutil.util.CommonLogUtil;

/**
 * Created by jianbing.yu on 2019/2/22.
 */

public class TBannerView extends RelativeLayout {

    protected final TranBanner mBanner;


    // =============================================================================================

    public TBannerView(Context context, String placementId) {
        super(context);
        mBanner = new TranBanner(context, this, placementId);
    }

    /**
     * 构造方法
     *
     * @param context
     * @param attrs
     */
    public TBannerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /**
     * 构造方法
     *
     * @param context
     * @param attrs
     * @param defStyleAttr
     */
    public TBannerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        String placementId = null;
        TypedArray types = context.obtainStyledAttributes(attrs, R.styleable.AdBannerView);

        for (int n = 0; n < types.getIndexCount(); n++) {
            int attr = types.getIndex(n);
            if (attr == R.styleable.AdBannerView_placementId) {
                placementId = types.getString(attr);
            }
        }

        if (types.getIndexCount() > 0) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "placementId=" + placementId);
        }

        types.recycle();
        mBanner = new TranBanner(context, this, placementId);
    }


    // =============================================================================================

    /**
     * 广告是否离线
     *
     * @return
     */
    public boolean isOfflineAd() {
        return mBanner == null ? false : mBanner.isOfflineAd();
    }

    /**
     * 广告是否可用
     *
     * @return
     */
    @Deprecated
    public int  getAdStatus() {
        return mBanner == null || !isReady()? Constants.AdStatus.AD_IS_FAILED : Constants.AdStatus.AD_IS_AVAILABLE;
    }

    /**
     * 设置是否是离线请求
     *
     * @param isOfflineAd
     */
    public void setOfflineAd(boolean isOfflineAd) {
        mBanner.setOfflineAd(isOfflineAd);
    }

    /**
     * 广告的价格
     *
     * @return
     */
    public double getBidPrice() {
        return mBanner.getBidPrice();
    }

    /**
     * 竞价
     */
    public void retrieveBid() {
        mBanner.loadAd(true);
    }

    /**
     * 下载素材
     */
    public void loadAd(BidInfo bidInfo) {
        if (mBanner != null) {
            mBanner.loadPlatformAd(bidInfo);
        }
    }

    /**
     * 设置placementId
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        mBanner.setPlacementId(placementId);
    }

    public void show() {
        mBanner.show();
    }

    public void setListener(AdListener listener) {
        mBanner.setListener(listener);
    }

    public boolean isReady() {
        return mBanner.isReady();
    }

    public boolean isLoaded() {
        return mBanner.isLoaded();
    }

    public void loadAd() {
        mBanner.loadAd(false);
    }

    public void destroy() {
        mBanner.destroy();
    }

    /**
     * 提供接口告知媒体填充的广告是属于离线还是在线广告
     *
     * @return 1 离线广告 0 在线广告 -1无填充
     */
    public int getFillAdType() {
        return mBanner.getFillAdType();
    }

}
