package com.cloud.hisavana.sdk.api.adx;


import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.hisavana.sdk.internal.interstitial.TranInterstitial;

/**
 * Created by jianbing.yu on 2019/2/22.
 *
 * 媒体入口
 */
public class TInterstitial {

    private static final String TAG = "InterstitialApi";
    protected TranInterstitial mInterstitial = null;

    /**
     * 构造方法
     *
     * @param placementId
     */
    public TInterstitial(String placementId) {
        mInterstitial = new TranInterstitial(placementId);
    }

    /**
     * 广告是否离线
     *
     * @return
     */
    public boolean isOfflineAd() {
        return mInterstitial == null ? false : mInterstitial.isOfflineAd();
    }

    /**
     * 广告是否可用
     */
    @Deprecated
    public int  getAdStatus() {
        return mInterstitial == null || !mInterstitial.isReady()? Constants.AdStatus.AD_IS_FAILED : Constants.AdStatus.AD_IS_AVAILABLE;
    }

    /**
     * 设置是否是离线请求
     * @param isOfflineAd
     */
    public void setOfflineAd(boolean isOfflineAd){
        mInterstitial.setOfflineAd(isOfflineAd);
    }

    /**
     *  广告的价格
     * @return
     */
    public double getBidPrice() {
        return  mInterstitial.getBidPrice();
    }


    /**
     * 竞价
     */
    public void retrieveBid() {
       mInterstitial.loadAd(true);
    }

    /**
     * 下载素材
     */
    public void loadAd(BidInfo bidInfo) {
        if (mInterstitial != null) {
            mInterstitial.loadPlatformAd(bidInfo);
        }
    }

    /**
     * 设置placementid
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        mInterstitial.setPlacementId(placementId);
    }

    public void setListener(AdListener listener) {
        mInterstitial.setListener(listener);
    }

    public void setRequest(AdRequest aAdRequest){
        mInterstitial.setAdRequest(aAdRequest);
    }


    /**
     * 提供接口告知媒体填充的广告是属于离线还是在线广告
     * @return 1 离线广告 0 在线广告 -1无填充
     */
    public int getFillAdType(){return mInterstitial.getFillAdType();}

    public void loadAd(){
        mInterstitial.loadAd(false);
    }

    public void show() {
        mInterstitial.show();
    }

    public boolean isReady() {
        return mInterstitial.isReady();
    }

    public void destroy() {
        mInterstitial.destroy();
    }

    /**
     * 设置triggerid，用于埋点
     * @param triggerId
     */
    public void setTriggerId(String triggerId){
        mInterstitial.setTriggerId(triggerId);
    }
}
