package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.hisavana.sdk.internal.splash.TranSplash;
import com.cloud.sdk.commonutil.util.Preconditions;

/**
 * ADX开屏对外提供的接口
 * 仅仅提供容器的能力 不参与数据处理
 */
public class TSplashView extends RelativeLayout {

    /**
     * 这个对象里面 解决了 数据哪里来的问题
     */
    protected TranSplash mSplash = null;

    private RelativeLayout mSplashLayout = null;


    // =============================================================================================


    public TSplashView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TSplashView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, "");
    }

    public TSplashView(Context context, String placementId) {
        super(context, null);
        init(context, placementId);
    }

    /**
     * 初始化 创建了容器
     * 数据处理对象
     */
    private void init(Context context, String placementId) {
        mSplashLayout = new RelativeLayout(this.getContext());
        this.addView(mSplashLayout, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mSplash = new TranSplash(context, mSplashLayout, placementId);
    }


    // =============================================================================================

    /**
     * 广告是否离线
     *
     * @return
     */
    public boolean isOfflineAd() {
        return mSplash == null ? false : mSplash.isOfflineAd();
    }

    /**
     * 广告是否可用
     */
    @Deprecated
    public int getAdStatus() {
        return !isReady() ? Constants.AdStatus.AD_IS_FAILED : Constants.AdStatus.AD_IS_AVAILABLE;
    }

    /**
     * 设置是否是离线请求
     *
     * @param isOfflineAd
     */
    public void setOfflineAd(boolean isOfflineAd) {
        mSplash.setOfflineAd(isOfflineAd);
    }

    /**
     * 广告的价格
     *
     * @return
     */
    public double getBidPrice() {
        return mSplash.getBidPrice();
    }

    /**
     * 竞价
     */
    public void retrieveBid() {
        mSplash.loadAd(true);
    }

    /**
     * 下载素材
     */
    public void loadAd(BidInfo bidInfo) {
        if (mSplash != null) {
            mSplash.loadPlatformAd(bidInfo);
        }
    }


    /**
     * 判断广告是否准备好
     *
     * @return
     */
    public boolean isReady() {
        AdLogUtil.Log().e("SplashView ", "isReady " + mSplash.isReady());
        return mSplash != null ? mSplash.isReady() : false;
    }

    /**
     * 设置广告位id
     */
    public void setPlacementId(String placementId) {
        mSplash.setPlacementId(placementId);
    }

    /**
     * 设置跳过的监听器
     */
    public void setSkipListener(OnSkipListener listener) {
        mSplash.setSkipListener(listener);
    }

    public void setListener(AdListener adListener) {
        mSplash.setListener(adListener);
    }

    /**
     * 加载广告
     */
    public void loadAd() {
        mSplash.loadAd(false);
    }

    /**
     * 显示广告 --> 在广告加载完成之后显示
     */
    public void show() {
        Preconditions.checkIsOnMainThread();
        mSplash.show();
    }

    /**
     * 在调用界面销毁的时候调用
     */
    public void destroy() {
        mSplash.destroy();
    }

    /**
     * 提供接口告知媒体填充的广告是属于离线还是在线广告
     *
     * @return 1 离线广告 0 在线广告 -1无填充
     */
    public int getFillAdType() {
        return mSplash.getFillAdType();
    }
}

