package com.cloud.hisavana.sdk.api.adx.innerapi;

import com.cloud.hisavana.sdk.api.adx.TNative;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;

public class TInnerNative extends TNative {

    public TInnerNative(String placementId) {
        super(placementId);
    }

    /**
     * 设置请求类型
     *
     * @param requestType 请求时机
     */
    public void setRequestType(int requestType) {
        mNative.setRequestType(requestType);
    }

    public void loadAd(String requestId) {
        mNative.loadAd(requestId);
    }

    /**
     * 设置当前的广告类型 hotApps
     *
     * @param adSeatType native广告类型
     */
    public void setAdSeatType(String adSeatType) {
        mNative.setAdSeatType(adSeatType);
    }

    /**
     * 设置是否是离线请求
     *
     * @param isOfflineAd 是否离线广告
     */
    public void setOfflineAd(boolean isOfflineAd) {
        mNative.setOfflineAd(isOfflineAd);
    }

    /**
     * 设置triggerid，用于埋点
     *
     * @param triggerId triggerId
     */
    public void setTriggerId(String triggerId) {
        mNative.setTriggerId(triggerId);
    }

    public boolean isAdValid(TaNativeInfo taNativeInfo) {
        return mNative.isAdValid(taNativeInfo);
    }

    public boolean isLoading() {
        return mNative.isLoading();
    }
}
