package com.cloud.hisavana.sdk.api.config;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.util.CommonLogUtil;

/**
 * @author Connor Lin
 * @date 2020/4/24
 */
public final class AdsConfig {

    public int fillType;
    public int adCount;

    public AdsConfig(int fillType, int adCount) {
        this.fillType = fillType;
        this.adCount = adCount;
    }

    public interface FillType {
        int IMAGE = 0;
        int ALL = 1;
        int ICON = 2;
    }

    public interface DownloadType {
        int SINGLE = 0;
        int UNIFIED = 1;
        int ADCHOICE = 2;
        int MEDIA = 3;
    }

    /**
     * https://transsioner.feishu.cn/docs/doccnNuK5iU5eMCeAPaglqDaPrf#
     * @param adBean
     * @return
     */
    public static boolean isAdValid(AdsDTO adBean) {
        if (adBean == null){
            return false;
        }
        if(adBean.isOfflineAd()){
            return true;
        }
        if (adBean != null) {
            boolean isAdValid = System.currentTimeMillis() - adBean.getFill_ts() <= adBean.getCacheTime() * 60 * 1000;
            AdLogUtil.Log().d(CommonLogUtil.TAG,"isAdValid-" + isAdValid + " -now-" + System.currentTimeMillis() + "-load-" + adBean.getFill_ts() + "-cachetime-" + adBean.getCacheTime() * 60 * 1000);
            return isAdValid;
        }
        return false;
    }
}
