package com.cloud.hisavana.sdk.api.request;

import com.cloud.hisavana.sdk.api.listener.AdListener;

public class AdRequest {
    private String requestId = null;
    private String placementId = null;
    private int requestType = -1;
    private AdListener mListener = null;
    private int scheduleTime = 0;

    private AdRequest() {

    }

    public AdListener getListener() {
        return mListener;
    }

    public void setListener(AdListener mListener) {
        this.mListener = mListener;
    }

    public int getScheduleTime() {
        return scheduleTime;
    }

    public void setScheduleTime(int scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getPlacementId() {
        return placementId;
    }

    public void setPlacementId(String placementId) {
        this.placementId = placementId;
    }

    public int getRequestType() {
        return requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public static class Builder {
        private final AdRequest aAdRequest;

        public Builder() {
            aAdRequest = new AdRequest();
        }

        public AdRequest.Builder setRequestId(String requestId) {
            aAdRequest.setRequestId(requestId);
            return this;
        }

        public AdRequest.Builder setPlacementId(String placementId) {
            aAdRequest.setPlacementId(placementId);
            return this;
        }

        public AdRequest.Builder setRequestType(int requestType) {
            aAdRequest.setRequestType(requestType);
            return this;
        }
        public AdRequest.Builder setAdListener(AdListener listener){
            aAdRequest.setListener(listener);
            return this;
        }

        public AdRequest.Builder setScheduleTime(int scheduleTime){
            aAdRequest.setScheduleTime(scheduleTime);
            return this;
        }

        public AdRequest build() {
            return aAdRequest;
        }
    }
}
