package com.cloud.hisavana.sdk.common.athena;

import static com.cloud.hisavana.sdk.common.constant.Constants.IS_ADM_AD.ADM_AD;
import static com.cloud.hisavana.sdk.common.constant.Constants.IS_ADM_AD.NO_ADM_AD;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.request.FormBean;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.athena.AthenaUtil;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.athenacust.AthenaCust;
import com.transsion.ga.AthenaAnalytics;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class AthenaTracker {


    // 下载途径
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;

    // 下载状态
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;

    // 下载类型
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;
    //1.4.0 ps素材
    public static final int M_TYPE_AD_PS = 4;
    public static final int M_TYPE_AD_WEB = 5;
    private static boolean isInited = false;

    public static void init(boolean isDebug, Context context) {
        /**
         *
         * Athena初始化方法，建议在宿主应用的application.onCreate方法中调用，否则可能影响Athena功能
         * @param context 上下文
         * @param channel 渠道号 用户统计的维度(比如OS，GP等)，不确定可以填写应用名称
         * @param appId   appId tid/eid的前4位整数区分不同app，只能传四位整数
         * @param isDebug 开启日志
         * @param isHost  开启Crash/日活上报。如果是Application调用初始化函数，需要设置isHost为true。如果是library(比如广告、支付、推送等功能性SDK），需要设置isHost为false。对于isHost为true的模块，Athena SDK会自动采集并上报Crash信息（appid+7998/7999），日活信息(appid+9999)。
         */
        if (!isInited) {
            AthenaAnalytics.init(context, "SSP", PostConstant.TID, isDebug, false);
            AthenaAnalytics.setTest(isDebug);
            isInited = true;
        }
    }

    /**
     * @return 获取公参
     */
    public static Bundle getBundle(Bundle bundle) {
        return AthenaUtil.getBundle(bundle);
    }


    /**
     * 展示上报新开一个子线程
     *
     * @param info
     */
    public static void trackShow(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackShow(info);
            }
        });
    }

    /**
     * deeplink应用拉起成功上报
     *
     * @param info
     */
    public static void trackDeeplink(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackDeeplink(info);
            }
        });
    }

    /**
     * SSP SDK 物料加载日志
     *
     * @param info          广告详情
     * @param requestType   请求方式 1. 从网络获取；2. 从本地缓存获取
     * @param downloadWay   下载方式 1.HttpUrlConnection 2.Okhttp  int
     * @param mStatus       下载状态 1.开始下载 2.下载成功 3.下载失败
     * @param errorCode     错误信息
     * @param mType         资源类型
     * @param cdn           资源来源
     * @param timeConsuming 耗时
     * @param fileSize      文件大小
     */
    public static void trackImageDownload(final AdsDTO info,
                                          final int requestType,
                                          final int downloadWay,
                                          final int mStatus,
                                          final int errorCode,
                                          final int mType,
                                          final String cdn,
                                          final long timeConsuming,
                                          final int fileSize,
                                          final int isOfflineAd) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackImageDownload(info, requestType, downloadWay, mStatus, errorCode, mType, cdn, timeConsuming, fileSize, isOfflineAd);
            }
        });
    }

    /**
     * Adm 调用
     */
    public static void trackImageDownload(final AdsDTO info, final int download_way, final int m_status, final String errorcode, final int m_type, final long timeConsuming) {
        trackImageDownload(info, 1, download_way, m_status, 1, m_type, "", timeConsuming, 1, 0);
    }

    /**
     * ssp云控请求埋点
     *
     * @param triggerType 请求时机
     * @param requestId   requestId
     */
    public static void trackConfigRequest(final int triggerType, final String requestId) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackConfigRequest(triggerType, requestId);
            }
        });
    }

    /**
     * ssp云控返回埋点
     *
     * @param triggerType 请求时机
     * @param requestId   requestId
     * @param requestTime 请求耗时
     * @param code        请求结果
     * @param message     状态信息
     * @param version     云控版本
     */
    public static void trackConfigResponse(final int triggerType, final String requestId,
                                           final int requestTime, final int code,
                                           final String message, final String version) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackConfigResponse(triggerType, requestId, requestTime, code, message, version);
            }
        });
    }


    /**
     * 请求广告埋点
     *
     * @param info
     */
    public static void trackSspRequest(final AdxImpBean info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequest(info);
            }
        });
    }

    /**
     * 返回广告埋点
     */
    public static void trackSspReturn(final List<AdsDTO> infos, final TaErrorCode adError, final AdxImpBean adxImpBean) {
        final List<AdsDTO> adsDTOs = new ArrayList();
        if (infos != null) {
            for (AdsDTO adsDTO : infos) {
                adsDTOs.add(adsDTO);
            }
        }
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturn(adsDTOs, adError, adxImpBean);
            }
        });
    }

    /**
     * 请求ps素材广点
     */
    public static void trackSspRequestPs(final AdsDTO info, final String gplink) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequestPs(info, gplink);
            }
        });
    }

    /**
     * 返回ps素材埋点
     */
    public static void trackSspReturnPs(final AdsDTO info, final List<String> gplinks, final List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS, final TaErrorCode adError) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturnPs(info, gplinks, psLinkListDTOS, adError);
            }
        });
    }

    /**
     * ps弹窗展现
     */
    public static void trackPsPopupImp(final AdsDTO info, final List<String> gplinks, final List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupImp(info, gplinks, psLinkListDTOS);
            }
        });
    }

    /**
     * ps弹窗点击
     */
    public static void trackPsPopupClick(final AdsDTO info, final int clickContentType) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupClick(info, clickContentType);
            }
        });
    }

    /**
     * webview重定向的埋点
     *
     * @param info
     */
    public static void trackWebViewRedirect(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackWebViewRedirect(info);
            }
        });
    }

    /**
     * form表单 离线提交
     *
     * @param info
     * @param formBean
     */
    public static void trackFormInfoSet(final AdsDTO info, final FormBean formBean) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackFormInfoSet(info, formBean);
            }
        });
    }

    /**
     * 离线的落地页点击埋点
     * @param eventDataSet
     */
    public static void trackOfflineWebClick(final String eventDataSet) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackOfflineWebClick(eventDataSet);
            }
        });
    }
    /**
     * 媒体调用请求
     */
    public static void trackMediaCallRequest(final int adType,final String mTriggerId,final String mPlacementId,final int adCount,final int triggerNetState) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackMediaCallRequest(adType,mTriggerId,mPlacementId,adCount,triggerNetState);
            }
        });
    }
    /**
     * 填充结果
     */
    public static void trackAdFillingResult(final AdsDTO info,final String triggerId,final int mTriggerNetState) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackAdFillingResult(info,triggerId,mTriggerNetState);
            }
        });
    }

    /**
     * 关闭广告
     */
    public static void trackSspCloseAd(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspCloseAd(info);
            }
        });
    }

    /**
     * 离线广告的web加载完成埋点
     */
    public static void offLineWebComplete(final AdsDTO info, final long webDuration) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.offLineWebComplete(info, webDuration);
            }
        });
    }

    private static class AthenaTrackerInvoker {
        /**
         * ad_ssp_show上报
         *
         * @param info
         */
        public static void trackShow(AdsDTO info) {
            if (info == null) {
                return;
            }
            AdLogUtil.Log().d(CommonLogUtil.TAG, "currentThread().getId()" + Thread.currentThread().getId());
            Bundle bundle = new Bundle();
            bundle.putDouble("price", info.getFirstPrice());
            //20220117 二价扣费
            bundle.putString("new_price", info.getNewPrice());
            //推广应用安装状态 1.非下载类广告 2. 已安装目标下载应用 3.未安装目标下载应用"
            bundle.putInt("popularize_app_install_status", info.getInstallApk());
            //曝光时长
            bundle.putLong("show_duration", info.getActualShowTime());
            //曝光面积
            bundle.putString("show_area", info.getShowArea());
            //展现上报时机类型1. 展现时上报 2. 达标时上报 3. 离开时上报
            bundle.putLong("show_report_time_type", info.getShowReportTimeType());
            //区分是普通广告还是adm广告
            bundle.putInt("is_adm_ad", TextUtils.isEmpty(info.getAdm()) ? NO_ADM_AD : ADM_AD);
            //1.4.2 新增
            List<String> adCreateIds = new ArrayList<>();
            adCreateIds.add(info.getAdCreativeId() + "");
            bundle.putString("ad_creative_ids", GsonUtil.toJson(adCreateIds));
            if(info.isOfflineAd()){
                bundle.putLong("ad_expire_time", info.getOfflineAdExpireTime());//广告过期时间
            }
            bundle.putInt("show_times", info.getShowNum());//本创意当天第几次展现
            bundle.putInt("source", info.getSource());//填充来源"1.有网触发实时请求 2.有网触发离线填充 3. 无网触发离线填充"
            if (info.getImpBeanRequest() != null) {
                bundle.putString("trigger_id", info.getImpBeanRequest().triggerId);
            }
            bundle.putInt("image_width", info.getAdImageWidth());
            bundle.putInt("image_height", info.getAdImageHeight());
            bundle.putString("package_name", info.getPackageName());
            bundle.putString("click_url", info.getClickUrl());
            bundle.putInt("is_default_ad", 0);
            bundle.putInt("is_default_ad_first_show", 0);
            new AthenaCust(PostConstant.EVENT, PostConstant.TID).trackCommon(fillAdParamsToBundleForShowAndDeeplink(info, bundle), null).submit();
        }

        /**
         * deeplink应用拉起成功上报
         *
         * @param info
         */
        public static void trackDeeplink(AdsDTO info) {
            Bundle bundle = new Bundle();
            //成功拉起的deeplink链接
            bundle.putInt("called_url_type", info.getCalledUrlType());
            bundle.putString("app_name", info.getPslinkAppName());
            new AthenaCust(PostConstant.EVENT_DEEPLINK, PostConstant.TID).trackCommon(fillAdParamsToBundleForShowAndDeeplink(info, bundle), null).submit();
        }

        /**
         * ad_ssp_show和deeplink共有的埋点参数设置
         *
         * @param info
         * @param params
         * @return
         */
        private static Bundle fillAdParamsToBundleForShowAndDeeplink(AdsDTO info, Bundle params) {
            //公参 SDK自行上报
            Bundle bundle = AthenaUtil.getBundle(params);

            //事件参数
            bundle.putString("request_id", info.getRid());
            bundle.putString("code_seat_id", info.getCodeSeatId());
            bundle.putInt("code_seat_type", info.getCodeSeatType());
            bundle.putInt("cache_time", info.getCacheTime());//缓存时长：开屏-4、其他-1 （小时）
            bundle.putInt("id", info.getId());
            bundle.putLong("advertiser_id", info.getAdvertiserId());//广告主id
            bundle.putLong("plan_id", info.getPlanId());//计划id
            bundle.putLong("ad_group_id", info.getAdGroupId());//广告组id
            bundle.putLong("ad_creative_id", info.getAdCreativeId());//广告创意id
            bundle.putString("tracking_secret_key", info.getShowTrackingSecretKey());//曝光加密串
            bundle.putLong("login_time", System.currentTimeMillis());//日志时间戳
            bundle.putInt("actual_show_rate", info.getActualShowRate());//广告素材实际曝光比例
            bundle.putLong("show_ts", System.currentTimeMillis());//广告曝光时时间戳
            bundle.putInt("is_effective_show", info.getIsEffectiveShow());//是否有效曝光 1/0 1=有效 0=无效
            bundle.putString("app_id", AdManager.AppId);

            if (info.getStoreDeeplink() != null && info.getStoreDeeplink().size() > 0) {
                bundle.putString("click_urls", info.getStoreDeeplink().toString());
            }
            bundle.putInt("is_test_request", AdManager.isTestRequest() ? 1 : 0);// 是否测试请求   1=是 0=否        int

            //20211028 配和abtest
            if (info.getAbTest() != null) {
                bundle.putString("abTest", GsonUtil.toJson(info.getAbTest()));
            }
            bundle.putString("extInfo", info.getExtInfo());
            if (info.getImpBeanRequest() != null) {
                bundle.putInt("request_type", info.getImpBeanRequest().requestType);
            }
            bundle.putLong("is_offline_ad", info.isOfflineAd() ? 1 : 0);//是否离线广告"0. 在线广告1. 离线广告"
            bundle.putInt("ad_trigger_status", info.getSource() == Constants.FillingSource.OFFLINE_CACHE_AD ? 1 : 0);
            bundle.putLong("event_ts", System.currentTimeMillis());
            return bundle;
        }

        /**
         * SSP SDK 物料加载日志
         *
         * @param info        广告详情
         * @param downloadWay 下载方式 1.HttpUrlConnection 2.Okhttp  int
         * @param mStatus     物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
         * @param errorCode   失败原因 string
         * @param mType       物料类型 1=logo 2=大图 int
         * @param cdn
         */
        public static void trackImageDownload(AdsDTO info,
                                              int requestType,
                                              int downloadWay,
                                              int mStatus,
                                              int errorCode,
                                              int mType,
                                              String cdn,
                                              long timeConsuming,
                                              int fileSize,
                                              int isOfflineAd) {

            if (null == info) {
                return;
            }

            //公参 SDK自行上报
            Bundle bundle = AthenaUtil.getBundle(null);

            //事件参数
            bundle.putString("request_id", info.getRid());
            bundle.putString("code_seat_id", info.getCodeSeatId());
            bundle.putInt("code_seat_type", info.getCodeSeatType());
            bundle.putLong("advertiser_id", info.getAdvertiserId());
            bundle.putLong("plan_id", info.getPlanId());
            bundle.putLong("ad_group_id", info.getAdGroupId());
            bundle.putLong("ad_creative_id", info.getAdCreativeId());
            // bundle.putString("package_name", info.getPackageName());

            //日志时间戳
            bundle.putLong("login_time", System.currentTimeMillis());
            bundle.putLong("event_ts", System.currentTimeMillis());

            // 自定义字段
            // 下载方式 1.HttpUrlConnection 2.Okhttp  int
            bundle.putInt("download_way", downloadWay);
            // 物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
            bundle.putInt("m_status", mStatus);
            // 失败原因 string      1330 修改类型 string --> int
            bundle.putInt("error_code", errorCode);
            // 物料类型 1=logo 2=大图 int
            bundle.putInt("m_type", mType);
            // 1322 新增字段
            bundle.putString("x_response_cdn", cdn);

            //1. 从网络获取；2. 从本地缓存获取
            bundle.putInt("load_type", requestType);

            // 1330 新增字段
            // 网络请求耗时
            bundle.putLong("time_consuming", timeConsuming);
            // 文件大小 byte数组长度
            bundle.putInt("file_size", fileSize);

            // 是否是adm广告类型
            bundle.putInt("is_adm_ad", TextUtils.isEmpty(info.getAdm()) ? NO_ADM_AD : ADM_AD);
            //是否离线
            bundle.putInt("is_offline_ad", isOfflineAd);

            new AthenaCust(PostConstant.EVENT_IMG, PostConstant.TID).trackCommon(bundle, null).submit();
        }

        /**
         * 请求广告埋点
         *
         * @param info
         */
        public static void trackSspRequest(AdxImpBean info) {
            //公参 SDK自行上报
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putInt("request_type", info.requestType);
            bundle.putLong("request_ts", info.getRequestTs());
            bundle.putString("request_id", info.requestId);
            bundle.putLong("event_ts", info.getRequestTs());
            bundle.putInt("is_offline_ad", info.offlineAd ? 1 : 0);
            bundle.putInt("ad_type", info.adt);
            bundle.putString("trigger_id",info.triggerId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", info.pmid);
            bundle.putInt("ad_count", info.mAdCount);
            bundle.putInt("is_retreatad", 0);
            bundle.putInt("request_num", info.mAdCount);//重复
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_SSP_REQUEST, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * 返回广告埋点
         */
        public static void trackSspReturn(List<AdsDTO> adsDTOList, TaErrorCode adError, AdxImpBean adxImpBean) {
            //公参 SDK自行上报
            Bundle bundle = AthenaUtil.getBundle(null);
            AdsDTO info = null;
            if (adsDTOList != null && adsDTOList.size() > 0) {
                info = adsDTOList.get(0);
                List<String> adCreateIds = new ArrayList<>();
                for (AdsDTO adsDTO : adsDTOList) {
                    if (adsDTO != null) {
                        adCreateIds.add(adsDTO.getAdCreativeId() + "");
                    }
                }
                bundle.putString("ad_creative_ids", GsonUtil.toJson(adCreateIds));
            }
            if (info != null && info.getImpBeanRequest() != null && adxImpBean == null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean != null) {
                bundle.putInt("request_type", adxImpBean.requestType);
                bundle.putLong("request_ts", adxImpBean.getRequestTs());
                bundle.putString("request_id", adxImpBean.requestId);
                bundle.putString("trigger_id", adxImpBean.triggerId);
                bundle.putInt("ad_type", adxImpBean.adt);
                bundle.putString("code_seat_id", adxImpBean.pmid);
                bundle.putInt("ad_count", adxImpBean.mAdCount);
                if (adxImpBean.getRequestTs() != 0) {
                    bundle.putInt("return_time", (int) (System.currentTimeMillis() - adxImpBean.getRequestTs()));
                }
                bundle.putInt("is_timeout", adxImpBean.isTimeOut);
                //142 新增
                bundle.putInt("request_num", adxImpBean.mAdCount);
                bundle.putInt("is_offline_ad", adxImpBean.offlineAd ? 1 : 0);
                bundle.putLong("event_ts", adxImpBean.getRequestTs());
            }

            bundle.putString("app_id", AdManager.AppId);
            bundle.putLong("return_ts", System.currentTimeMillis());

            //请求成功时，不会上报
            if (adError != null) {
                bundle.putString("error_code", adError.getErrorCode() + "");
                bundle.putString("error_message", adError.getErrorMessage());
            }
            if (info != null) {
                bundle.putDouble("bidding_price", info.getFirstPrice());
                bundle.putLong("advertiser_id", info.getAdvertiserId());//广告主id
                bundle.putLong("plan_id", info.getPlanId());//计划id
                bundle.putLong("ad_group_id", info.getAdGroupId());//广告组id
                bundle.putLong("ad_creative_id", info.getAdCreativeId());//广告创意id
                //是否是adm广告
                bundle.putInt("is_adm_ad", TextUtils.isEmpty(info.getAdm()) ? NO_ADM_AD : ADM_AD);
                bundle.putInt("is_pslink_ad", info.getIsPslinkAd());
            }
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_SSP_RETURN, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * 请求PS素材
         *
         * @param info
         * @param gplink
         */
        public static void trackSspRequestPs(AdsDTO info, String gplink) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) return;
            bundle.putString("gplink", gplink);
            bundle.putString("request_id", adxImpBean.requestId);
            info.setRequestPsTs(System.currentTimeMillis());
            bundle.putLong("request_ts", info.getRequestPsTs());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_SSP_REQUEST_PS, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * 返回PS素材
         */
        public static void trackSspReturnPs(AdsDTO info, List<String> gplinks, List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS, TaErrorCode adError) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) return;
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putString("gplink_list", GsonUtil.toJson(gplinks));
            bundle.putString("pslink_list", GsonUtil.toJson(psLinkListDTOS));
            bundle.putLong("request_ts", info.getRequestPsTs());
            info.setReturnPsTs(System.currentTimeMillis());
            bundle.putLong("return_ts", info.getReturnPsTs());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            //请求成功时，不会上报
            if (adError != null) {
                bundle.putString("error_code", adError.getErrorCode() + "");
                bundle.putString("error_message", adError.getErrorMessage());
            }
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_SSP_RETURN_PS, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * ps弹窗展现
         */
        public static void trackPsPopupImp(AdsDTO info, final List<String> gplinks, List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null && adxImpBean == null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) return;
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putString("gplink_list", GsonUtil.toJson(gplinks));
            bundle.putString("pslink_list", GsonUtil.toJson(psLinkListDTOS));
            bundle.putLong("request_ts", info.getRequestPsTs());
            bundle.putLong("return_ts", info.getReturnPsTs());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putLong("popup_imp_ts", System.currentTimeMillis());
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_PS_POPUP_IMP, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * ps弹窗点击
         */
        public static void trackPsPopupClick(AdsDTO info, int clickContentType) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) return;
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putLong("popup_click_ts", System.currentTimeMillis());
            bundle.putInt("click_content_type", clickContentType);
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_PS_POPUP_CLICK, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * webview重定向埋点
         */
        public static void trackWebViewRedirect(AdsDTO info) {
            if (info == null) {
                return;
            }
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) return;
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("request_type", adxImpBean.requestType);
            bundle.putLong("ad_creative_id", info.getAdCreativeId());//广告创意id
            bundle.putLong("advertiser_id", info.getAdvertiserId());//广告主id
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("code_seat_type", info.getCodeSeatType());
            bundle.putString("web_url", info.getClickUrl());
            if (info.getClickUrlTs() != 0) {
                bundle.putInt("web_duration", (int) (System.currentTimeMillis() - info.getClickUrlTs()));
            }
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_WEBVIEW_REDIRECT, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * ssp云控请求埋点
         *
         * @param triggerType 请求时机
         * @param requestId   requestId
         */
        public static void trackConfigRequest(int triggerType, String requestId) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("trigger_type", triggerType);
            bundle.putString("cld_request_id", requestId);
            new AthenaCust(PostConstant.EVENT_CLD_REQUEST, PostConstant.TID).trackCommon(bundle, null).submit();
        }

        /**
         * ssp云控返回埋点
         *
         * @param triggerType 请求时机
         * @param requestId   requestId
         * @param requestTime 请求耗时
         * @param code        状态吗 0成功 1失败
         * @param message     状态信息
         * @param version     云控版本号
         */
        public static void trackConfigResponse(int triggerType, String requestId,
                                               int requestTime, int code, String message, String version) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putInt("trigger_type", triggerType);
            bundle.putString("cld_request_id", requestId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("cld_return_time_interval", requestTime);
            bundle.putInt("code", code);
            bundle.putString("message", message);
            bundle.putString("cld_version", version);
            new AthenaCust(PostConstant.EVENT_CLD_RETURN, PostConstant.TID).trackCommon(bundle, null).submit();
        }

        /**
         * form表单离线提交数据
         */
        public static void trackFormInfoSet(AdsDTO info, FormBean formBean) {
            if (info == null || formBean == null) {
                return;
            }
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) return;
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("is_offline_ad", 1);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("code_seat_type", info.getCodeSeatType());
            bundle.putString("advertiser_id", info.getAdvertiserId().toString());//广告主id
            bundle.putString("plan_id", info.getPlanId().toString());//计划id
            bundle.putString("ad_group_id", info.getAdGroupId().toString());//广告组id
            bundle.putString("ad_creative_id", info.getAdCreativeId().toString());//广告创意id
            bundle.putString("form_info", GsonUtil.getGson().toJson(formBean));
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_FORM_INFO_SET, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * 离线点击上报
         */
        public static void trackOfflineWebClick(String eventDataSet) {
            if (TextUtils.isEmpty(eventDataSet)) {
                return;
            }
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("event_data_set", eventDataSet);
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_SSP_CLICK, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * 媒体调用请求
         */
        public static void trackMediaCallRequest(int adType,String mTriggerId,String mPlacementId,int adCount, int triggerNetState) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putInt("ad_type",adType);
            bundle.putString("trigger_id", mTriggerId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", mPlacementId);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("ad_count", adCount);
            bundle.putInt("ad_trigger_status",triggerNetState);
            bundle.putInt("is_retreatad", 0);//isretreatad，标识当次启动是冷启动还是热启动
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_MEDIA_CALL_REQUEST, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        /**
         * 填充结果
         */
        public static void trackAdFillingResult(AdsDTO info,String triggerId,int mTriggerNetState) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("trigger_id", triggerId);
            if (info == null) {
                bundle.putInt("filling_result", Constants.FillingResult.FILL_FAIL);//填充结果，1.填充成功 2.填充失败
                bundle.putLong("event_ts", System.currentTimeMillis());
                bundle.putInt("ad_trigger_status", mTriggerNetState);
            }else {
                AdxImpBean adxImpBean = null;
                if (info != null && info.getImpBeanRequest() != null) {
                    adxImpBean = info.getImpBeanRequest();
                }
                if (adxImpBean == null) return;
                bundle.putInt("filling_result", Constants.FillingResult.FILL_SUCCESS);//填充结果，1.填充成功 2.填充失败
                bundle.putInt("source", info.getSource());
                bundle.putInt("ad_trigger_status", mTriggerNetState);
                bundle.putInt("is_offline_ad", info.isOfflineAd() ? 1 : 0);
                bundle.putString("request_id", adxImpBean.requestId);
                bundle.putString("code_seat_id", adxImpBean.pmid);
                bundle.putInt("code_seat_type", info.getCodeSeatType());
                bundle.putString("advertiser_id", info.getAdvertiserId().toString());//广告主id
                bundle.putLong("event_ts", System.currentTimeMillis());
                bundle.putString("plan_id", info.getPlanId().toString());//计划id
                bundle.putString("ad_group_id", info.getAdGroupId().toString());//广告组id
                bundle.putString("ad_creative_id", info.getAdCreativeId().toString());//广告创意id
            }
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_FILLING_RESULT, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }
        /**
         * 关闭广告
         */
        public static void trackSspCloseAd(AdsDTO info) {
            if (info == null) {
                return;
            }
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) return;
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("request_type", adxImpBean.requestType);
            bundle.putInt("is_offline_ad", info.isOfflineAd() ? 1 : 0);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("code_seat_type", info.getCodeSeatType());
            bundle.putInt("cache_time", info.getCacheTime());
            bundle.putString("id", info.getId().toString());
            bundle.putString("advertiser_id", info.getAdvertiserId().toString());//广告主id
            bundle.putString("plan_id", info.getPlanId().toString());//计划id
            bundle.putString("ad_group_id", info.getAdGroupId().toString());//广告组id
            bundle.putString("ad_creative_id", info.getAdCreativeId().toString());//广告创意id
            bundle.putLong("show_times", info.getShowNum());
            bundle.putLong("show_duration", info.getActualShowTime());
            bundle.putString("show_area", info.getShowArea());
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_SSP_CLOSE_AD, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }

        public static void offLineWebComplete(AdsDTO info,long webDuration){
            if (info == null || !info.isOfflineAd()){
                return;
            }
            Bundle bundle = getBundle(null);
            AdxImpBean impBean = info.getImpBeanRequest();
            if (impBean != null) {
                bundle.putString("request_id", impBean.requestId);
                bundle.putInt("request_type", impBean.requestType);
                bundle.putString("code_seat_id", impBean.pmid);
            }
            bundle.putString("web_url", info.getOfflineH5Url());
            bundle.putLong("web_duration", webDuration);
            bundle.putLong("ad_creative_id", info.getAdCreativeId());//广告创意id
            bundle.putLong("advertiser_id", info.getAdvertiserId());//广告主id
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("is_offline_ad", info.isOfflineAd() ? 1 : 0);
            bundle.putInt("code_seat_type", info.getCodeSeatType());
            if (bundle != null) {
                new AthenaCust(PostConstant.EVENT_AD_WEB_COMPLETE, PostConstant.TID).trackCommon(bundle, null).submit();
            }
        }
    }
}
