package com.cloud.hisavana.sdk.common.bean;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.callback.INativeBridge;

/**
 * 反馈给开发者的广告数据
 * 由于广告来源有多种，针对每一种广告来源提取单独的广告数据（根据需求定）
 *
 * @author $罗文竞
 * @data 2021/08/11
 * ========================================
 * CopyRight (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public final class TaNativeInfo{

    /**
     * 请求时生成的Id，用于串联一条广告业务
     */
    private String sequenceId;
    private String ver;
    private AdImage iconImage;
    // TODO 将List<Image>修改为了Image，后期需要还原为List  大图需要显示多个image
    private AdImage image;
    private String title;
    private String descriptionText;
    private String buttonText;
    private String rating;
    private String price;
    /**
     * adx adchoices
     */
    public String acImageUrl;
    public String acClickUrl;

    public boolean isACReady;
    public boolean clicked;
    public INativeBridge nativeBridge;
    public String uuid;
    private double bidPrice;
    private double secondPrice;
    private String adSeatType;//1.4.2新增 广告位标识
    /**
     * 埋点用的
     */
    public AdsDTO adItem;

    public String advSeatType;//1.5版本新增 广告位类型
    public String materialStyle;//1.5版本新增 广告样式
    public String requestId;//1.5版本新增 广告样式
    public boolean isOfflineAd;

    public boolean isMediaCached() {
        return image != null && image.isCached();
    }

    public String getVer() {
        return ver;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    public AdImage getIconImage() {
        return iconImage;
    }

    public void setIconImage(AdImage iconImage) {
        this.iconImage = iconImage;
    }

    public AdImage getImage() {
        return image;
    }

    public void setImage(AdImage image) {
        this.image = image;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return descriptionText;
    }

    public void setDescription(String description) {
        this.descriptionText = description;
    }

    public String getCtatext() {
        return buttonText;
    }

    public void setCtatext(String ctatext) {
        this.buttonText = ctatext;
    }

    public String getRating() {
        return rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getSequenceId() {
        return sequenceId;
    }

    public void setSequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void destroy(){
        if(nativeBridge != null){
            nativeBridge.onNativeInfoDestroy(this);
            nativeBridge = null;
        }
    }

    public boolean isAdValid() {
        if(nativeBridge != null){
            return nativeBridge.isAdValid(this);
        }
        return false;
    }

    public double getBidPrice(){
        return bidPrice;
    }

    public void setSecondPrice(double secondPrice){
        this.secondPrice = secondPrice;
    }

    public double getSecondPrice() {
        return secondPrice;
    }

    public void setBidPrice(double price){
        this.bidPrice = price;
    }

    public String getAdSeatType() {
        return adItem == null?"":adItem.getAdSeatType();
    }

    public Long getAdCreateId(){
        return adItem == null?0:adItem.getAdCreativeId();
    }

    public boolean isOfflineAd() {
        return isOfflineAd;
    }

    public void setOfflineAd(boolean offlineAd) {
        isOfflineAd = offlineAd;
    }
}
