package com.cloud.hisavana.sdk.common.http;

import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.sign.HttpSigner;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.impl.StringCallback;

import java.util.List;
import java.util.Map;

import javax.net.ssl.SSLSocketFactory;


/**
 * Created by peng.sun on 2017/6/19.
 */

public class AdServerRequest extends RequestBase<CommonResponseListener> {
    private String mPlacementid = "0";
    private String mUrl = "";
    private boolean mIsDebug = false;
    private SSLSocketFactory mSSLSocketFactory = null;
    private IAdPostBody mPostBody = null;
    private static String lastCloudCtrlVersion = null;
    private static String lastHisavanaCloudCtrlVersion = null;
    private static boolean ctrlVersionChanged = false;
    private String isOfflineAd = "0";//"0"在线 "1"离线
    //用去ad_ssp_request埋点
    private AdxImpBean adxImpBean;

    public AdServerRequest setAdxImpBean(AdxImpBean adxImpBean) {
        this.adxImpBean = adxImpBean;
        return this;
    }

    public AdServerRequest setIsOfflineAd(boolean isOfflineAd) {
        this.isOfflineAd = isOfflineAd ? "1" : "0";
        return this;
    }

    public AdServerRequest setPostBody(IAdPostBody postBody) {
        this.mPostBody = postBody;
        return this;
    }

    public AdServerRequest setListener(CommonResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public AdServerRequest setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public AdServerRequest setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
        return this;
    }

    public AdServerRequest setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.mSSLSocketFactory = sslSocketFactory;
        return this;
    }

    public AdServerRequest setPlacementId(String pid) {
        this.mPlacementid = pid;
        return this;
    }

    @Override
    protected void netRequestPosExecute() {
        TranssionPoolManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                /**
                 * 发起网络请求
                 */
                sendRequestToServer();
//                sendRequestToServer_OkHttp();
            }
        });
    }

    public interface IAdPostBody {
        String getPostBody();
    }

    /**
     * 发送数据
     */

    private void sendRequestToServer() {
        String postBodyString = mPostBody.getPostBody();
        if (TextUtils.isEmpty(postBodyString)) {
            if (mListener != null) {
                mListener.onServerRequestFailure(-1, "TextUtils.isEmpty(postBodyString) == true ", null);
            }
            AdLogUtil.netLog("sendRequestToServer() --> TextUtils.isEmpty(postBodyString) == true ");
        }
        if (adxImpBean != null) {
            adxImpBean.requestTs = System.currentTimeMillis();
            //上报请求埋点
            AthenaTracker.trackSspRequest(adxImpBean);
        }

        try {
            //AdLogUtil.netLog("full url:=" + mUrl);
            //AdLogUtil.netLog("postBodyString == ");
            //AdLogUtil.netLog(postBodyString.trim());
            // 日志简化
            final String str = "----- full url = " + mUrl + "\n ----- postBodyString = " + postBodyString.trim();

            String cloudControlVersion = AdxPreferencesHelper.getInstance().getString(Constants.CLOUD_CONTROL_VERSION, null);
            //2.0.0新增，ssp的云控版本号
            String cloudControlOfflineVersion = AdxPreferencesHelper.getInstance().getString(Constants.HISAVANA_CLOUD_CONTROL_VERSION, null);
            if (!TextUtils.isEmpty(mUrl)) {
                if (mListener != null) {
                    mListener.onServerRequestStart(Constants.LoadType.NET);
                }
                HttpSigner.setTest(AdxServerConfig.getAppModle() != AdxServerConfig.RELEASE);
                String signStr = HttpSigner.doSign("post", "", "application/json", mUrl, postBodyString);
                HttpClient.postJson()  //必须方法体
                        .log(mIsDebug)
                        .sslSocketFactory(mSSLSocketFactory)  //Tan 需要私有证书校验,Adx不需要
                        .content(postBodyString) //必须方法体，上传的String类型的数据文本，目前只提供上传String接口
                        .connectTimeout(TIMEOUT_IN_MILLIONS)   //网络连接超时时间，单位毫秒，非必须默认10s
                        .readTimeout(TIMEOUT_IN_MILLIONS)      //读取数据超时时间，单位毫秒，非必须默认10s
                        .addHeader("x-tr-signature", signStr)
                        .addHeader("cloudControlVersion", cloudControlVersion)
                        .addHeader("cloudControlOfflineVersion", cloudControlOfflineVersion)
                        // 142 新增需求  ssp广告接口，增加一个header， 字段名：defaultAd，取值 1，表示打底，其他取值表示非打底
                        .addHeader("defaultAd", Constants.REQUEST_HEADER_DEFAULT_AD_2)
                        .addHeader("offlineAd", isOfflineAd)
                        .url(mUrl)
                        .addHeader("Accept-Timezone", "UTC")
                        .build()
                        .execute(new StringCallback(true) {
                                     @Override
                                     public void onSuccess(final int statusCode, String response) {
                                         //AdLogUtil.netLog("*----> status code:=" + statusCode + "  mUrl =" + mUrl + "  response = ");
                                         //AdLogUtil.netLog(response);
                                         AdLogUtil.netLog(str
                                                 + "\n ----- status code = " + statusCode
                                                 + "\n ----- response = " + response);

                                         if (!TextUtils.isEmpty(response)) {
                                             if (mListener != null) {
                                                 mListener.onServerRequestSuccess(statusCode, response);
                                             }
                                         } else {
                                             if (mListener != null) {
                                                 mListener.onServerRequestFailure(TaErrorCode.HTTP_RESPONSE_ERROR.getErrorCode(), TaErrorCode.HTTP_RESPONSE_ERROR.getErrorMessage(), null);
                                             }
                                             AdLogUtil.netLog("TextUtils.isEmpty(response) == true ,  response is null ");
                                         }
                                     }

                                     @Override
                                     public void onResponseHeader(Map<String, List<String>> map) {
                                         if (map != null) {
                                             List<String> list = map.get(Constants.CLOUD_CONTROL_VERSION);
                                             if (list != null && list.size() > 0) {
                                                 String ctrlVersion = list.get(0);
                                                 if (!TextUtils.isEmpty(ctrlVersion) && !ctrlVersion.equals(lastCloudCtrlVersion)) {
                                                     lastCloudCtrlVersion = ctrlVersion;
                                                     ctrlVersionChanged = true;
                                                     AdLogUtil.netLog("get new cloud control version from header,version: " + ctrlVersion);
                                                     AdxPreferencesHelper.getInstance().putString(Constants.PREF_NEW_CLOUD_CONTROL_VERSION, ctrlVersion);
                                                 }
                                             }
                                             List<String> hisavanaVer = map.get(Constants.CLOUD_CONTROL_HISAVANA_VERSION);
                                             if (hisavanaVer != null && hisavanaVer.size() > 0) {
                                                 String hisavanaCtrlVersion = hisavanaVer.get(0);
                                                 if (!TextUtils.isEmpty(hisavanaCtrlVersion) && !hisavanaCtrlVersion.equals(lastHisavanaCloudCtrlVersion)) {
                                                     lastHisavanaCloudCtrlVersion = hisavanaCtrlVersion;
                                                     AdLogUtil.netLog("get new hisavana cloud control version from header,version: " + hisavanaCtrlVersion);
                                                     AdxPreferencesHelper.getInstance().putString(Constants.PREF_NEW_HISAVANA_CLOUD_CONTROL_VERSION, hisavanaCtrlVersion);
                                                 }
                                             }
                                         }
                                     }

                                     @Override
                                     public void onFailure(int statusCode, String response, Throwable throwable) {
                                         boolean isNeedRetry = HttpSigner.needRetryForTimeIssue(statusCode, response);
                                         if (isNeedRetry) {
                                             sendRequestToServer();
                                             return;
                                         }

                                         if (null != throwable) {
                                             //AdLogUtil.netLog("error statusCode:=" + statusCode + " ,"
                                             //                + "reponse: = " + response + ",error message = " + throwable.getMessage());
                                             AdLogUtil.netLog(str
                                                     + " ----- error statusCode = " + statusCode
                                                     + " ----- error message = " + throwable.getMessage()
                                                     + " ----- response = " + response
                                             );
                                         }

                                         if (mListener != null) {
                                             mListener.onServerRequestFailure(statusCode, response, throwable);
                                         }
                                     }
                                 }

                        );
            }

        } catch (Throwable e) {
            AdLogUtil.netLog("AdServerRequest --> " + Log.getStackTraceString(e));

            if (mListener != null) {
                mListener.onServerRequestFailure(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE, e.getMessage()));
            }
        }
    }
}
