package com.cloud.hisavana.sdk.common.tracking;


import static com.cloud.sdk.commonutil.util.CommonLogUtil.MEASURE_TAG;

import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;


/**
 * 广告曝光 统一处理
 */
public class ADExposureManager {

    /**
     * 有效曝光 --> 上报服务器
     */
    public static void exposureValid(AdsDTO info) {
        if (null == info) {
            AdLogUtil.Log().d(MEASURE_TAG,"exposureInvalid --> null == info");
            return;
        }
        info.setIsEffectiveShow(1);
        AdLogUtil.Log().d(MEASURE_TAG,"valid exposure --> to server info = " + info);
        AthenaTracker.trackShow(info);
    }

    /**
     * 无效曝光 --> 上报服务器
     */
    public static void exposureInvalid(AdsDTO info) {
        if (null == info) {
            AdLogUtil.Log().d(MEASURE_TAG,"exposureInvalid --> null == info");
            return;
        }
        info.setIsEffectiveShow(0);
        AdLogUtil.Log().d(MEASURE_TAG,"invalid exposure --> to server info = " + info);
        AthenaTracker.trackShow(info);
    }

}
