package com.cloud.hisavana.sdk.data.bean.response;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.ps.PsRequestManager;
import com.cloud.hisavana.sdk.common.util.OfflineAdExpiredUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.google.gson.JsonSyntaxException;

import java.util.List;

/**
 * @author: wenjing.luo
 * @date: 2022/3/20
 * 自定义的广告数据bean
 */
public class AdsDTO extends AdsProtocolBean {
    private AdxImpBean impBeanRequest;
    private Long fill_ts;//刚请求回数据的时间
    private String uuid;//在native广告中用到
    //广告过期时间配置 (分钟)
    private Integer splashCountTime = 4; // 倒计时 5S 第4 秒开始才可以点击跳转
    private Boolean isACReady;//adchoice是否预加载成功
    //图片是否下载成功
    private Boolean imageIsDownload;

    //1.3.0新增
    private String deepLinkUrlFirst; //deepLinkUrl中的第一个可拉起的应用深链接地址
    private Long actualShowTime;//广告素材实际曝光时间
    private Integer actualShowRate = 0;//广告素材实际曝光比例
    private String showArea = "0*0";//广告素材曝光面积，宽*高

    private Integer isEffectiveShow;//是否有效曝光 1/0 1=有效 0=无效
    private Integer showReportTimeType;//展现上报时机类型 1. 展现时上报 2. 达标时上报 3. 离开时上报
    //1.4.0新增
    //pslink下载情况
    private Integer adPsType = Constants.AD_PS_TYPE.NO_PS_AD;
    //被调起的url类型
    private int calledUrlType = Constants.CALLED_URL_TYPE.CLICKURLS;
    //pslink的name
    private String pslinkAppName;
    //宏替换的clickid
    private String clickid;
    //请求ps素材的时间
    private long requestPsTs;
    //返回ps素材的时间
    private long returnPsTs;
    //曝光串
    private String impressionUrl;
    //落地页点击时间
    private long clickUrlTs;
    private PsRequestManager psRequestManager;
    private String adSeatType;
    private ViewJson viewJsonData;
    //离线广告文件夹地址
    private String filePath;
    //展示时当天零点时间
    private long showDate;
    //数据库表id
    private int tableId;
    private int source;//填充来源"1.实时请求 2.在线缓存 3. 离线缓存"
    private Integer showNum = 0;//当日展现次数
    Long offlineAdStartDateLong;//离线广告开始投放日期   long
    String offlineAdLaunchDateStr;//离线广告状态 bitmap（近30天）str
    Long offlineAdExpireTime;//广告过期时间
    public ViewJson getViewJsonData(){
        if(viewJson == null){
            return null;
        }
        if(viewJsonData == null){
            try {
                viewJsonData =  GsonUtil.fromJson(viewJson,ViewJson.class);
            }catch (GsonUtil.GsonParseException e){
            }
        }
        return viewJsonData;
    }

    /**
     * @return 获取离线时需要下载的H5 url
     */
    public String getOfflineH5Url() {
        ViewJson data = getViewJsonData();
        if(data == null){
            return "";
        }
        if(data.getDialogType() == 1 && data.getDialogJson()!=null){
            return data.getDialogJson().getUrl();
        }
        if (getViewJsonData() == null || getViewJsonData().getOffline() == null) {
            return "";
        }
        String res = getViewJsonData().getOffline().getRes();
        return TextUtils.isEmpty(res) ? getViewJsonData().getOffline().getZipRes() : res;
    }

    /**
     * @return 离线的h5资源是否为zip
     */
    public boolean isH5Zip() {
        ViewJson data = getViewJsonData();
        if(data == null){
            return false;
        }
        if(data.getDialogType() == 1 && data.getDialogJson()!=null ){
            return false;
        }
        if (getViewJsonData() == null || getViewJsonData().getOffline() == null) {
            return false;
        }
        return TextUtils.isEmpty(getViewJsonData().getOffline().getRes())
                && !TextUtils.isEmpty(getViewJsonData().getOffline().getZipRes());
    }

    /**
     * @return 离线广告的当日展示次数上限
     */
    public int getMaxShowCount() {
        if (getViewJsonData() == null || getViewJsonData().getOffline() == null) {
            return 0;
        }
        return getViewJsonData().getOffline().getMaxShowPPPD();
    }



    public PsRequestManager getPsRequestManager() {
        return psRequestManager;
    }

    public void setPsRequestManager(PsRequestManager psRequestManager) {
        this.psRequestManager = psRequestManager;
    }

    public long getClickUrlTs() {
        return clickUrlTs;
    }

    public void setClickUrlTs(long clickUrlTs) {
        this.clickUrlTs = clickUrlTs;
    }

    public int getRequestType() {
        if (impBeanRequest != null){
            return impBeanRequest.requestType;
        }
        return -1;
    }

    public String getDeepLinkUrlFirst() {
        return deepLinkUrlFirst == null ? "" : deepLinkUrlFirst;
    }

    public void setDeepLinkUrlFirst(String deepLinkUrlFirst) {
        this.deepLinkUrlFirst = deepLinkUrlFirst;
    }

    public String getImpressionUrl() {
        return impressionUrl;
    }

    public void setImpressionUrl(String impressionUrl) {
        this.impressionUrl = impressionUrl;
    }

    public long getRequestPsTs() {
        return requestPsTs;
    }

    public void setRequestPsTs(long requestPsTs) {
        this.requestPsTs = requestPsTs;
    }

    public long getReturnPsTs() {
        return returnPsTs;
    }

    public void setReturnPsTs(long returnPsTs) {
        this.returnPsTs = returnPsTs;
    }

    public String getClickid() {
        return clickid;
    }

    public void setClickid(String clickid) {
        this.clickid = clickid;
    }

    public Integer getAdPsType() {
        return adPsType;
    }

    public void setAdPsType(Integer adPsType) {
        this.adPsType = adPsType;
    }

    public int getCalledUrlType() {
        return calledUrlType;
    }

    public void setCalledUrlType(int calledUrlType) {
        this.calledUrlType = calledUrlType;
    }

    public String getPslinkAppName() {
        return pslinkAppName;
    }

    public void setPslinkAppName(String pslinkAppName) {
        this.pslinkAppName = pslinkAppName;
    }

    public AdxImpBean getImpBeanRequest() {
        return impBeanRequest;
    }

    public void setImpBeanRequest(AdxImpBean impBeanRequest) {
        this.impBeanRequest = impBeanRequest;
    }

    public String getCodeSeatId() {
        if (impBeanRequest != null){
            return impBeanRequest.pmid;
        }
        return "";
    }

    public Integer getCodeSeatType() {
        if (impBeanRequest != null){
            return impBeanRequest.adt;
        }
        return -1;
    }

    public String getRid() {
        if (impBeanRequest != null){
            return impBeanRequest.requestId;
        }
        return "";
    }

    public void setTriggerId(String triggerId) {
        if (impBeanRequest != null && isOfflineAd()){
            impBeanRequest.triggerId = triggerId;
        }
    }
    public Long getFill_ts() {
        return fill_ts == null ? 0 : fill_ts;
    }

    public Integer getSplashCountTime() {
        return splashCountTime == null ? 0 : splashCountTime;
    }

    public Boolean getACReady() {
        return isACReady == null ? false : isACReady;
    }

    public Boolean getImageIsDownload() {
        return imageIsDownload == null ? false : imageIsDownload;
    }
    public Integer getActualShowRate() {
        return actualShowRate == null ? 0 : actualShowRate;
    }

    public Long getActualShowTime() {
        return actualShowTime == null ? 0L : actualShowTime;
    }

    public Integer getIsEffectiveShow() {
        return isEffectiveShow == null ? 0 : isEffectiveShow;
    }

    public String getUuid() {
        return null == uuid ? "" : uuid;
    }

    public Integer getShowReportTimeType() {
        return showReportTimeType == null ? 1 : showReportTimeType;
    }

    public void setShowReportTimeType(Integer showReportTimeType) {
        this.showReportTimeType = showReportTimeType;
    }

    public String getShowArea() {
        return showArea;
    }

    public void setShowArea(String showArea) {
        this.showArea = showArea;
    }

    public void setFill_ts(Long fill_ts) {
        this.fill_ts = fill_ts;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setSplashCountTime(Integer splashCountTime) {
        this.splashCountTime = splashCountTime;
    }

    public void setACReady(Boolean ACReady) {
        isACReady = ACReady;
    }

    public void setImageIsDownload(Boolean imageIsDownload) {
        this.imageIsDownload = imageIsDownload;
    }

    public void setActualShowRate(Integer actualShowRate) {
        this.actualShowRate = actualShowRate;
    }

    public void setActualShowTime(Long actualShowTime) {
        this.actualShowTime = actualShowTime;
    }

    public void setIsEffectiveShow(Integer isEffectiveShow) {
        this.isEffectiveShow = isEffectiveShow;
    }

    public void setAdSeatType(String adSeatType) {
        this.adSeatType = adSeatType;
    }

    public String getAdSeatType() {
        return adSeatType;
    }

    public Integer getShowNum() {
        return showNum == null ? 0 : showNum;
    }

    public void setShowNum(Integer showNum) {
        this.showNum = showNum;
    }

    //是否超过单日展示次数上线true:超过
    public boolean isReachedDisplayTimes(){
        ViewJson data = getViewJsonData();
        if(data == null){
            return true;
        }
        if (data.getOffline() == null){
            return true;
        }
        AdLogUtil.Log().d(OfflineAdExpiredUtil.TAG, "id：" + id + "，showNum：" + showNum +"，data.getOffline().getMaxShowPPPD()"+ data.getOffline().getMaxShowPPPD());
        if (getShowNum() + 1 > data.getOffline().getMaxShowPPPD()){
            return true;
        }
        AdLogUtil.Log().d(OfflineAdExpiredUtil.TAG, "adsDTO isReachedDisplayTimes false");
        return false;
    }

    public Long getOfflineAdStartDateLong() {
        return offlineAdStartDateLong == null ? 0 : offlineAdStartDateLong;
    }

    public void setOfflineAdStartDateLong(Long offlineAdStartDateLong) {
        this.offlineAdStartDateLong = offlineAdStartDateLong;
    }

    public String getOfflineAdLaunchDateStr() {
        AdLogUtil.Log().d(OfflineAdExpiredUtil.TAG, "adsDTO idOfflineAdExpired binaryStr: "+ offlineAdLaunchDateStr);
        return offlineAdLaunchDateStr;
    }

    public void setOfflineAdLaunchDateStr(String offlineAdLaunchDateStr) {
        this.offlineAdLaunchDateStr = offlineAdLaunchDateStr;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getShowDate() {
        return showDate;
    }

    public void setShowDate(long showDate) {
        this.showDate = showDate;
    }

    public int getTableId() {
        return tableId;
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public int getSource() {
        return source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public Long getOfflineAdExpireTime() {
        return offlineAdExpireTime == null ? 0: offlineAdExpireTime;
    }

    public void setOfflineAdExpireTime(Long offlineAdExpireTime) {
        this.offlineAdExpireTime = offlineAdExpireTime;
    }

    @Override
    public String toString() {
        return "AdsDTO{" +

                "impBeanRequest=" + impBeanRequest +
                ", adCreativeId=" + adCreativeId +
                ", fill_ts=" + fill_ts +
                ", uuid='" + uuid + '\'' +
                ", splashCountTime=" + splashCountTime +
                ", isACReady=" + isACReady +
                ", imageIsDownload=" + imageIsDownload +
                ", deepLinkUrlFirst='" + deepLinkUrlFirst + '\'' +
                ", actualShowTime=" + actualShowTime +
                ", actualShowRate=" + actualShowRate +
                ", showArea='" + showArea + '\'' +
                ", isEffectiveShow=" + isEffectiveShow +
                ", showReportTimeType=" + showReportTimeType +
                ", adPsType=" + adPsType +
                ", calledUrlType=" + calledUrlType +
                ", pslinkAppName='" + pslinkAppName + '\'' +
                ", clickid='" + clickid + '\'' +
                ", requestPsTs=" + requestPsTs +
                ", returnPsTs=" + returnPsTs +
                ", impressionUrl='" + impressionUrl + '\'' +
                ", clickUrlTs=" + clickUrlTs +
                ", psRequestManager=" + psRequestManager +
                ", adSeatType='" + adSeatType + '\'' +
                ", viewJsonData=" + viewJsonData +
                ", filePath='" + filePath + '\'' +
                ", showDate='" + showDate + '\'' +
                ", tableId=" + tableId +
                ", source=" + source +
                ", showNum=" + showNum +
                ", offlineAdStartDateLong=" + offlineAdStartDateLong +
                ", offlineAdLaunchDateStr='" + offlineAdLaunchDateStr + '\'' +
                ", offlineAdExpireTime=" + offlineAdExpireTime +
                ", viewJson=" + viewJson +
                '}';
    }
}
