package com.cloud.hisavana.sdk.data.bean.response;

import android.text.TextUtils;

public class ConfigCodeSeatDTO {
    private String applicationId;//应用id
    private String codeSeatId;//代码位id
    private Integer codeSeatType;//代码位类型: 1-native、2-banner、3-插屏、4-开屏、 5-激励视频
    private String adSeatType;//sdk1.4.2新增广告位类型     枚举值 feeds、lockScreen、Hotapps
    private boolean offlineAdEnable;//是否支持离线广告
    private Integer offlineAdCacheCount;//最大缓存数量(离线广告)
    private Integer offlineAdRequestCount;//单次请求广告数量(离线广告)
    private Integer offlineAdRequestTimeInterval;//请求间隔（s）(离线广告)
    private Integer offlineAdRequestTimeIntervalNoAd;//请求间隔（小时）(离线广告)（服务端无广告返回场景）
    private boolean isAdRequestFail = true;//服务端广告返回情况,true：接口未成功返回、接口成功返回广告，false：接口成功返回结果，但是无广告
    private Integer adShowCountLimit;//单用户各广告位每天最大可展示广告次数（不区分在线、离线）
    private Integer currentShowTimes;//当天已经展示次数
    private String date;//当天零点时间
    private int showIndex;//展示标记位置
    private int tempIndex;//临时标记位置
    private long lastRequestAdTime;//上次请求广告时间

    @Override
    public String toString() {
        return "ConfigCodeSeatDTO{" +
                "applicationId='" + applicationId + '\'' +
                ", codeSeatId='" + codeSeatId + '\'' +
                ", codeSeatType=" + codeSeatType +
                ", adSeatType='" + adSeatType + '\'' +
                ", offlineAdEnable=" + offlineAdEnable +
                ", offlineAdCacheCount=" + offlineAdCacheCount +
                ", offlineAdRequestCount=" + offlineAdRequestCount +
                ", offlineAdRequestTimeInterval=" + offlineAdRequestTimeInterval +
                ", adShowCountLimit=" + adShowCountLimit +
                ", currentShowTimes=" + currentShowTimes +
                ", date='" + date + '\'' +
                ", showIndex=" + showIndex +
                ", tempIndex=" + tempIndex +
                ", lastRequestAdTime=" + lastRequestAdTime +
                '}';
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getCodeSeatId() {
        return codeSeatId;
    }

    public void setCodeSeatId(String codeSeatId) {
        this.codeSeatId = codeSeatId;
    }

    public Integer getCodeSeatType() {
        return codeSeatType == null ? 0 : codeSeatType;
    }

    public void setCodeSeatType(Integer codeSeatType) {
        this.codeSeatType = codeSeatType;
    }

    public String getAdSeatType() {
        return adSeatType;
    }

    public void setAdSeatType(String adSeatType) {
        this.adSeatType = adSeatType;
    }

    public boolean isOfflineAdEnable() {
        return offlineAdEnable;
    }

    public void setOfflineAdEnable(boolean offlineAdEnable) {
        this.offlineAdEnable = offlineAdEnable;
    }

    public Integer getOfflineAdRequestCount() {
        return offlineAdRequestCount == null ? 0 : offlineAdRequestCount;
    }

    public void setOfflineAdRequestCount(Integer offlineAdRequestCount) {
        this.offlineAdRequestCount = offlineAdRequestCount;
    }

    public Integer getOfflineAdRequestTimeInterval() {
        return offlineAdRequestTimeInterval == null ? 0 : offlineAdRequestTimeInterval;
    }

    public void setOfflineAdRequestTimeInterval(Integer offlineAdRequestTimeInterval) {
        this.offlineAdRequestTimeInterval = offlineAdRequestTimeInterval;
    }

    public Integer getOfflineAdRequestTimeIntervalNoAd() {
        return offlineAdRequestTimeIntervalNoAd == null ? 0 : offlineAdRequestTimeIntervalNoAd * 60 * 60;
    }

    public void setOfflineAdRequestTimeIntervalNoAd(Integer offlineAdRequestTimeIntervalNoAd) {
        this.offlineAdRequestTimeIntervalNoAd = offlineAdRequestTimeIntervalNoAd;
    }

    public boolean isAdRequestFail() {
        return isAdRequestFail;
    }

    public void setAdRequestFail(boolean adRequestFail) {
        this.isAdRequestFail = adRequestFail;
    }

    public Integer getAdShowCountLimit() {
        return adShowCountLimit == null ? 0 : adShowCountLimit;
    }

    public void setAdShowCountLimit(Integer adShowCountLimit) {
        this.adShowCountLimit = adShowCountLimit;
    }

    public Integer getCurrentShowTimes() {
        return currentShowTimes == null ? 0 : currentShowTimes;
    }

    public void setCurrentShowTimes(Integer currentShowTimes) {
        this.currentShowTimes = currentShowTimes;
    }

    public String getDate() {
        return TextUtils.isEmpty(date) ? "0" : date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public int getShowIndex() {
        return showIndex;
    }

    public void setShowIndex(int showIndex) {
        this.showIndex = showIndex;
    }

    public int getTempIndex() {
        return tempIndex;
    }

    public void setTempIndex(int tempIndex) {
        this.tempIndex = tempIndex;
    }

    public Integer getOfflineAdCacheCount() {
        return offlineAdCacheCount == null ? 0 : offlineAdCacheCount;
    }

    public void setOfflineAdCacheCount(Integer offlineAdCacheCount) {
        this.offlineAdCacheCount = offlineAdCacheCount;
    }

    public long getLastRequestAdTime() {
        return lastRequestAdTime;
    }

    public void setLastRequestAdTime(long lastRequestAdTime) {
        this.lastRequestAdTime = lastRequestAdTime;
    }
}
