package com.cloud.hisavana.sdk.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;


/**
 * 云控数据用 数据库保存
 */
public class HisavanaDatabaseHelper extends SQLiteOpenHelper {

    /**
     * 数据库的名字
     */
    private static final String DB_NAME = "hisavana.db";

    /**
     * Initialize Database version
     */
    private static final int DB_VERSION = 2;

    /**
     *  Initialize Table Name
     */
   public static final String CLOUD_TABLE = "cloudList";
   public static final String AD_DATA_TABLE = "adList";

    /**
     *  Initialize Table from(Columns)
     */
    public static final String _ID = "_id";
    public static final String CODE_SEAT_ID = "codeSeatId";
    public static final String CODE_SEAT_BEAN = "code_seat_bean";
    public static final String CURRENT_CODESEAT_SHOW_TIMES = "current_codeseat_show_times";
    public static final String CODESEAT_SHOW_TIME_LIMIT = "show_time_limit";
    public static final String DATETIME = "datetime";
    public static final String ENABLE_OFFLINEAD = "enableOffLineAd";//离线广告位是否开启 0 false 1 true
    public static final String CURRENT_INDEX = "currentIndex";//广告展示到第几个 index计数
    public static final String AD_ID = "ad_creative_id";//广告创意id
    public static final String AD_BEAN = "ad_bean";//广告
    public static final String FILE_PATH = "file_path";//离线广告落地页地址 文件夹
    public static final String PRICE = "price";//广告价格 double


    /**
     * Creating table query
     */
    private static final String CREATE_CONFIG_TABLE = "CREATE TABLE " + CLOUD_TABLE + "(" + CODE_SEAT_ID
            + " VARCHAR(20) PRIMARY KEY, " + CODE_SEAT_BEAN + " TEXT);";


    private static final String CREATE_AD_DATA_TABLE = "CREATE TABLE " + AD_DATA_TABLE + "(" + _ID
            + " INTEGER PRIMARY KEY AUTOINCREMENT," + AD_ID + " VARCHAR(20), " + CODE_SEAT_ID + " VARCHAR(20),"
            + FILE_PATH + " VARCHAR(20)," + PRICE + " DOUBLE," + AD_BEAN + " TEXT);";


    // =============================================================================================


    /**
     * 构造函数
     *
     * @param context 上下文
     */
    public HisavanaDatabaseHelper(Context context) {
        super(context, DB_NAME, null, DB_VERSION);
    }


    // =============================================================================================


    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_CONFIG_TABLE);
        db.execSQL(CREATE_AD_DATA_TABLE);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(CREATE_CONFIG_TABLE);
        db.execSQL(CREATE_AD_DATA_TABLE);
    }
}
