package com.cloud.hisavana.sdk.internal.interstitial;
/* Top Secret */


import com.cloud.hisavana.sdk.ad.base.OnlineAdFetch;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.BidInfo;
import com.cloud.hisavana.sdk.internal.base.BaseAd;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.Preconditions;

import java.util.List;

/**
 * 插屏广告
 *
 * @author 孙志刚.
 * @date 2016/12/8.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class TranInterstitial extends BaseAd {

    private final InterstitialGemini mPlatform;

    private final OnlineAdFetch mOnlineAdFetch;
    private AdsDTO mAdBean = null;


    // =============================================================================================


    /**
     * 构造方法
     *
     * @param placementId
     */
    public TranInterstitial(String placementId) {
        super(Constants.AdType.INTERSTITIAL, placementId);

        mOnlineAdFetch = new OnlineAdFetch(placementId,Constants.AdType.INTERSTITIAL);
        mOnlineAdFetch.setAdListener(mInternalListener);
        mPlatform = new InterstitialGemini(this);
    }


    // =============================================================================================


    @Override
    protected boolean loadPolyAd() {
        return isLoading =  mOnlineAdFetch.loadAd(mRequestId,requestType,mTriggerId);
    }

    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mOnlineAdFetch.setPlacementId(placementId);
    }

    @Override
    protected void onAdResponseStub(List<AdsDTO> adBeanList) {
        mAdBean = adBeanList.get(0);
        if (mAdBean == null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"mAdBean is null,terminate flow");
            return;
        }
        AdLogUtil.Log().d(CommonLogUtil.TAG,"loadPlatformAd on start load ad ");
        if (isBidding) {
            biddingCallback(adBeanList != null && !adBeanList.isEmpty() ? adBeanList.get(0) : null);
        } else {
            mPlatform.loadAd();
        }
    }


    // =============================================================================================

    /**
     * 返回当前广告是否为离线
     */
    public boolean isOfflineAd() {
        if (mAdBean == null) {
            return false;
        }
        return mAdBean.isOfflineAd();
    }

    /**
     * 竞价成功后加载素材
     */
    public void loadPlatformAd(BidInfo bidInfo) {
        mPlatform.loadAd();
    }


    public boolean isAdValid() {
        return AdsConfig.isAdValid(mAdBean);
    }

    public double getBidPrice() {
        if (mAdBean != null) {
            return mAdBean.getFirstPrice();
        }
        return 0;
    }
    public void setSecondPrice(double secondPrice) {
        if (mAdBean != null) {
            mAdBean.setSecondPrice(secondPrice);
        }
    }

    AdsDTO adBean() {
        return mAdBean;
    }

    public void show() {
        Preconditions.checkIsOnMainThread();
        if (mAdBean == null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"adBean = null");
            return;
        }
        boolean isAdValid = isAdValid();
        if (isAdValid && !mShowed) {
            if (mLoaded) {
                mPlatform.show();
            }
        } else {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"ad not condition to use");
        }
    }

    public boolean isLoaded() {
        return mLoaded;
    }

    public boolean isReady(){
        return isLoaded() && !mShowed && isAdValid();
    }
    @Override
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                mOnlineAdFetch.destroy();
                TranInterstitial.super.destroy();
                mPlatform.destroy();
            }
        });
    }

    @Override
    protected AdsDTO getAdBean() {
        return mAdBean;
    }

    @Override
    public int getAdType() {
        return Constants.AdType.INTERSTITIAL;
    }

}
