package com.cloud.hisavana.sdk.internal.native_;

import static com.cloud.hisavana.sdk.common.constant.Constants.ImageLoadType.IMAGE_DISK_INCLUDED;
import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.INVALID_URL;

import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.api.config.AdsConfig.DownloadType;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.EmptyUtil;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.manager.ConfigProviderManager;
import com.cloud.hisavana.sdk.manager.OfflineProviderManager;
import com.cloud.sdk.commonutil.util.CommonLogUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 传音原生广告
 *
 * @author 孙志刚.
 * @date 2016/12/12.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class NativeGemini {
    private static final String TAG = "NativeGemini";
    private long oldTime;
    private static final long DOUBLECLICK = 2 * 1000;

    private final TranNative mNative;
    private List<AdsDTO> mAdBeans;
    private List<TaNativeInfo> nativeInfos = null;
    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;
    /**
     * 保存当前所有广告和View信息
     */
    private final Map<TaNativeInfo, List<View>> mViewMap = new HashMap<>();

    // =============================================================================================


    NativeGemini(TranNative tranNative) {
        this.mNative = tranNative;
    }


    // =============================================================================================


    public boolean loadAd() {
        this.mAdBeans = mNative.adBeans();
//        if (mAdBeans.size() > 0){
//            for (AdsDTO mAdBean : mAdBeans) {
//                //获取ps中间页素材
//                PsRequestManager psRequestManager = new PsRequestManager(mAdBean);
//                psRequestManager.getRecommendItemIist();
//                mAdBean.setPsRequestManager(psRequestManager);
//            }
//        }
        boolean isResetTimer = false;
        if (EmptyUtil.isCollectionNotEmpty(mAdBeans)) {

            // TODO  数据类型 转换 从这里开始 数据类型就变了 ==============================================
            nativeInfos = PlatformUtil.getTadNativeInfoList(mAdBeans);
            if (EmptyUtil.isCollectionNotEmpty(nativeInfos)) {
                if (mNative.isUnifiedCallback()) {
                    unifiedDownload(); //目前Native不支持多条，只开放这种方式
                } else {
                    singleDownload();
                }
                isResetTimer = true;
            } else {
                if (mNative.adListener() != null) {
                    mNative.adListener().onError(
                            new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_2, "PlatformUtil.getTadNativeInfoList(mAdBeans) return is empty"));
                }
            }
        } else {
            if (mNative.adListener() != null) {
                mNative.adListener().onError(TaErrorCode.RESPONSE_AD_IS_EMPTY);
            }
        }
        return isResetTimer;
    }

    private void unifiedDownload() {
        switch (mNative.getFillType()) {
            case AdsConfig.FillType.ALL:
                // 下载图片
                unifiedPreCacheImageList(getImages(nativeInfos),getImageListener());
                break;

            case AdsConfig.FillType.ICON:
                unifiedPreCacheImageList(getImages(nativeInfos, false, true),getImageListener());
                break;

            case AdsConfig.FillType.IMAGE:
            default:
                unifiedPreCacheImageList(getImages(nativeInfos, true, false),getImageListener());
//                preCacheNativeImageList(getImages(nativeInfos, false, true), null, true);
                unifiedPreCacheImageList(getImages(nativeInfos,false,true),null);
                break;
        }
        if (!DownLoadRequest.IS_HAD_AD_CHOICE && nativeInfos != null && !nativeInfos.isEmpty()) {
            downloadAdChoice(nativeInfos.get(0));
        }else {
            for (TaNativeInfo nativeInfo : nativeInfos){
                nativeInfo.isACReady = true;
            }
        }
    }

//    private void downloadUnifiedMedia(List<AdImage> images) {
//        preCacheNativeImageList(images, getImageListener(), true);
//    }

    private void singleDownload() {
        final AtomicInteger counter = new AtomicInteger(nativeInfos.size());
        List<TaNativeInfo> infoList = new ArrayList<>();
        for (final TaNativeInfo nativeInfo : nativeInfos) {
            switch (mNative.getFillType()) {
                case AdsConfig.FillType.ALL:
                    infoList.clear();
                    infoList.add(nativeInfo);
                    singleCacheImageList(getImages(infoList), getImageListener(nativeInfo, counter, DownloadType.SINGLE));
                    break;

                case AdsConfig.FillType.ICON:
                    downloadSingleMedia(counter, nativeInfo, nativeInfo.getIconImage());
                    break;

                case AdsConfig.FillType.IMAGE:
                default:
                    if (nativeInfo.getImage() != null) {
                        nativeInfo.getImage().preCache = IMAGE_DISK_INCLUDED;
                    }
                    preCacheImage(nativeInfo.getIconImage(), null);
                    downloadSingleMedia(counter, nativeInfo, nativeInfo.getImage());
                    break;
            }

            downloadAdChoice(nativeInfo);
        }
    }

    private void downloadSingleMedia(AtomicInteger counter, TaNativeInfo nativeInfo, AdImage image) {

        preCacheImage(image, getImageListener(nativeInfo, counter, DownloadType.SINGLE));
    }

    void downloadMedia(final TaNativeInfo ad) {
        if (mNative == null || ad == null || EmptyUtil.isCollectionNotEmpty(mAdBeans)) {
            return;
        }
        preCacheImage(ad.getImage(), getImageListener(ad, DownloadType.MEDIA));
    }

    private void downloadAdChoice(final TaNativeInfo nativeInfo) {
        if (!containAdChoice(nativeInfo)) {
            return;
        }
        DownLoadRequest.downloadImage(nativeInfo.acImageUrl, nativeInfo.adItem, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, new DrawableResponseListener() {
            @Override
            public void onRequestSuccess(int statusCode, AdImage mediaBean) {
                if (nativeInfo != null){
                    nativeInfo.isACReady = true;
                }
            }

            @Override
            public void onRequestError(TaErrorCode adError) {
                if (nativeInfo != null) {
                    nativeInfo.isACReady = false;
                }
            }
        });
    }

    private DownLoadRequest.CacheListener getImageListener() {
        return getImageListener(null, null, DownloadType.UNIFIED);
    }

    private DownLoadRequest.CacheListener getImageListener(TaNativeInfo nativeInfo, int downloadType) {
        return getImageListener(nativeInfo, null, downloadType);
    }

    private DownLoadRequest.CacheListener getImageListener(final TaNativeInfo nativeInfo,
                                                      final AtomicInteger counter, final int downloadType) {
        return new DownLoadRequest.CacheListener() {
            @Override
            public void onError(TaErrorCode adError) {
                switch (downloadType) {
                    case DownloadType.UNIFIED:
                        mNative.setLoading(false);
                        break;

                    case DownloadType.ADCHOICE:
                        if (nativeInfo != null) {
                            nativeInfo.isACReady = false;
                        }
                        break;

                    case DownloadType.MEDIA:
                        break;

                    case DownloadType.SINGLE:
                    default:
                        if (counter.decrementAndGet() == 0) {
                            mNative.setLoading(false);
                        }
                        break;
                }

                if (mNative.adListener() != null && DownloadType.ADCHOICE != downloadType) {
                    mNative.setOneByOne(DownloadType.SINGLE == downloadType
                            && nativeInfos != null && nativeInfos.size() > 1);
                    mNative.adListener().onError(adError);
                }
            }

            @Override
            public void onSuccess() {
                switch (downloadType) {
                    case AdsConfig.DownloadType.UNIFIED:
                        mNative.setLoading(false);
                        if (mNative.adListener() != null) {
                            mNative.adListener().onAdLoaded(nativeInfos);
                            PlatformUtil.downLoadFormUrl(nativeInfos);
                        }
                        break;

                    case DownloadType.ADCHOICE:
                        if (nativeInfo != null) {
                            nativeInfo.isACReady = true;
                        }
                        break;

                    case DownloadType.MEDIA:
                        if (mNative.adListener() != null) {
                            mNative.adListener().onMediaDownloaded(nativeInfo);
                        }
                        break;

                    case DownloadType.SINGLE:
                    default:
                        if (counter.decrementAndGet() == 0) {
                            mNative.loadFinished();
                        }

                        if (mNative.adListener() != null) {
                            mNative.setOneByOne(nativeInfos != null && nativeInfos.size() > 1);
                            mNative.adListener().onAdLoaded(nativeInfos);
                        }
                        break;
                }
            }
        };
    }

    private boolean containAdChoice(TaNativeInfo nativeInfo) {
        return null != nativeInfo && !TextUtils.isEmpty(nativeInfo.acImageUrl);
    }

    List<TaNativeInfo> getNativeInfos() {
        return nativeInfos;
    }

    void adImpression(final AdsDTO adsDTO) {
        if (mNative.adListener() != null) {
            mNative.adListener().onAdShow();
            if (adsDTO != null && adsDTO.getImpBeanRequest() != null) {
                ConfigProviderManager.getInstance().updateConfigShowTimes(adsDTO.getImpBeanRequest().pmid);
                if (adsDTO.isOfflineAd()) {
                    adsDTO.setShowNum(adsDTO.getShowNum() + 1);
                    OfflineProviderManager.getInstance().updateShowTimes(adsDTO);
                }
            }
        }
    }

    /**
     * View 点击事件 注册
     */
    void registerViewForInteraction(View view, List<View> adContains, TaNativeInfo nativeInfo, AdsDTO adBean) {
        if (adContains != null) {
            Iterator iterator = adContains.iterator();
            mViewMap.put(nativeInfo, adContains);
            TChildViewOnTouchListener onTouchListener = new TChildViewOnTouchListener();
            TChildViewOnClickListener clickListener = new TChildViewOnClickListener(adBean, nativeInfo);
            if (view != null) {
                view.setOnTouchListener(onTouchListener);
                view.setOnClickListener(clickListener);
            }
            while (iterator.hasNext()) {
                View child = (View) iterator.next();
                if (child == null) {
                    continue;
                }
                if (getTagContinue(child)) {
                    continue;
                }
                if (child instanceof AdChoicesView) {
                    continue;
                }
                child.setOnClickListener(clickListener);
            }
        }
    }

    private boolean getTagContinue(View v) {
        if (v == null || v.getTag() == null) {
            return false;
        }
        return v.getTag().equals(Constants.ImageTag.ADX_CHOICE)
                || v.getTag().equals(Constants.ImageTag.IMAGE_WEBVIEW);
    }

    private void unregisterView() {
        for (Map.Entry entry : mViewMap.entrySet()) {
            List<View> views = (List<View>) entry.getValue();
            if (views == null) {
                continue;
            }
            for (View view : views) {
                view.setOnClickListener(null);
                view.setOnTouchListener(null);
            }
        }
        mViewMap.clear();
    }

    void unregisterView(TaNativeInfo adNativeInfo) {
        if (adNativeInfo == null) {
            return;
        }
        List<View> adContains = mViewMap.get(adNativeInfo);
        if (EmptyUtil.isCollectionNotEmpty(adContains)) {
            for (View view : adContains) {
                view.setOnClickListener(null);
                view.setOnTouchListener(null);
            }
            mViewMap.remove(adNativeInfo);
        }
    }

    public void destroy() {
        unregisterView();
        AdLogUtil.Log().d(CommonLogUtil.TAG, "destroy");
    }

    private class TChildViewOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;

                default:
                    break;
            }
            return false;
        }
    }

    private class TChildViewOnClickListener implements View.OnClickListener {
        private final AdsDTO adBean;
        private final TaNativeInfo nativeInfo;

        TChildViewOnClickListener(AdsDTO adBean, TaNativeInfo nativeInfo) {
            this.adBean = adBean;
            this.nativeInfo = nativeInfo;
        }

        @Override
        public void onClick(View v) {

            if (v != null && adBean != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - oldTime > DOUBLECLICK) {
                    try {
//                        SLogUtil.Log().d(AdLogUtil.TAG,"*----> NativeGemini asyncAction mAdBean.getAdPsType() = " + adBean.getAdPsType());
//                        //1.4.0ps中间页
//                        if (adBean.getAdPsType() == Constants.AD_PS_TYPE.PS_MATERIAL_DOWNLOAD_SUCCESS && adBean.getPsRequestManager() != null){
//                            adBean.getPsRequestManager().psAdDialog(v.getContext());
//                            //服务端点击上报
//                            TrackingManager.reportServerClick(new DownUpPointBean(downX, downY, upX, upY,
//                                    v.getMeasuredHeight(), v.getMeasuredWidth()),adBean);
//                        }else {
                        PlatformUtil.startLandingPage(v.getContext(), adBean,
                                new DownUpPointBean(downX, downY, upX, upY,
                                        v.getMeasuredHeight(), v.getMeasuredWidth()));
//                        }
                        if (mNative.adListener() != null) {
                            mNative.adListener().onAdClicked(new DownUpPointBean(downX, downY, upX, upY,
                                    v.getMeasuredHeight(), v.getMeasuredWidth()));
                        }
                        oldTime = currentTime;
                    } catch (Throwable e) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e));
                    }
                }
            }
        }
    }

    private List<AdImage> getImages(List<TaNativeInfo> nativeInfos) {
        return getImages(nativeInfos, true, true);
    }

    private List<AdImage> getImages(List<TaNativeInfo> nativeInfos,
                                    boolean witchImage, boolean withIcon) {
        final List<AdImage> images = new ArrayList<>();
        for (TaNativeInfo nativeInfo : nativeInfos) {
            if (nativeInfo == null) {
                continue;
            }


            if (nativeInfo.getImage() != null && witchImage) {
                nativeInfo.getImage().preCache = IMAGE_DISK_INCLUDED;

                // 埋点用的
                nativeInfo.getImage().adsDTO = nativeInfo.adItem;
                images.add(nativeInfo.getImage());
            }
            if (nativeInfo.getIconImage() != null && withIcon) {
                nativeInfo.getIconImage().preCache = Constants.ImageLoadType.IMAGE_RAM_INCLUDED;

                // 埋点用的
                nativeInfo.getIconImage().adsDTO = nativeInfo.adItem;
                nativeInfo.getIconImage().setmType(AthenaTracker.M_TYPE_LOGO);
                images.add(nativeInfo.getIconImage());
            }
        }
        return images;
    }

    private void unifiedPreCacheImageList(List<AdImage> images, final DownLoadRequest.CacheListener imageListener){
        final AtomicInteger imageCounter = new AtomicInteger(images.size());
        for (AdImage image : images) {
            preCacheImage(image, new DownLoadRequest.CacheListener() {
                @Override
                public void onError(TaErrorCode adError) {
                    final int count = imageCounter.decrementAndGet();
                    if (count == 0 && imageListener != null) {
                        imageListener.onError(adError);
                    }
                }

                @Override
                public void onSuccess() {
                    final int count = imageCounter.decrementAndGet();
                    if (count == 0 && imageListener != null) {
                        imageListener.onSuccess();
                    }
                }
            });
        }
    }

    private void singleCacheImageList(List<AdImage> images, final DownLoadRequest.CacheListener imageListener){
        final AtomicInteger imageCounter = new AtomicInteger(images.size());
        final boolean[] stop = {false};
        for (AdImage image : images) {
            if (stop[0]) {
                break;
            }
            preCacheImage(image, new DownLoadRequest.CacheListener() {
                @Override
                public void onError(TaErrorCode adError) {
                    stop[0] = true;
                    if (imageListener != null) {
                        imageListener.onError(adError);
                    }
                }

                @Override
                public void onSuccess() {
                    final int count = imageCounter.decrementAndGet();
                    if (count == 0 && imageListener != null) {
                        imageListener.onSuccess();
                    }
                }
            });
        }
    }

    /**
     * 图片预加载
     *
     * @param image    图片url信息
     * @param listener 回调接口
     */
    private void preCacheImage(final AdImage image, final DownLoadRequest.CacheListener listener) {
        if (image == null || TextUtils.isEmpty(image.getImgUrl())) {
            AdLogUtil.Log().d(TAG, "image url is null");
            if (listener != null) {
                listener.onError(INVALID_URL);
            }
            return;
        }
        final String url = image.getImgUrl();
        DownLoadRequest.downloadImage(url, image.adsDTO, image.getmType(), new DrawableResponseListener() {
                    @Override
                    public void onRequestSuccess(int statusCode, AdImage mediaBean) {
                        if (image.preCache == IMAGE_DISK_INCLUDED && mediaBean != null) {
                            if (image.getMime() != Constants.MIME.VIDEO) {
                                image.setMime(mediaBean.getMime());
                            }
                        }
                        image.setCached(true);
                        if (listener != null) {
                            listener.onSuccess();
                        }
                    }

                    @Override
                    public void onRequestError(TaErrorCode adError) {
                        if (listener != null) {
                            listener.onError(adError);
                        }
                    }
                });
    }
}