/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.athena;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.a;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.request.FormBean;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.athena.AthenaUtil;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.transsion.athenacust.AthenaCust;
import com.transsion.ga.AthenaAnalytics;
import java.util.ArrayList;
import java.util.List;

public class AthenaTracker {
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;
    public static final int M_TYPE_AD_PS = 4;
    public static final int M_TYPE_AD_WEB = 5;
    private static boolean isInited = false;

    public static void init(boolean isDebug, Context context) {
        if (!isInited) {
            AthenaAnalytics.init((Context)context, (String)"SSP", (int)2411, (boolean)isDebug, (boolean)false);
            AthenaAnalytics.setTest((boolean)isDebug);
            isInited = true;
        }
    }

    public static Bundle getBundle(Bundle bundle) {
        return AthenaUtil.getBundle((Bundle)bundle);
    }

    public static void trackShow(final AdsDTO info) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackShow(info);
            }
        });
    }

    public static void trackDeeplink(final AdsDTO info) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackDeeplink(info);
            }
        });
    }

    public static void trackImageDownload(final AdsDTO info, final int requestType, final int downloadWay, final int mStatus, final int errorCode, final int mType, final String cdn, final long timeConsuming, final int fileSize, final int isOfflineAd) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackImageDownload(info, requestType, downloadWay, mStatus, errorCode, mType, cdn, timeConsuming, fileSize, isOfflineAd);
            }
        });
    }

    public static void trackImageDownload(AdsDTO info, int download_way, int m_status, String errorcode, int m_type, long timeConsuming) {
        AthenaTracker.trackImageDownload(info, 1, download_way, m_status, 1, m_type, "", timeConsuming, 1, 0);
    }

    public static void trackConfigRequest(final int triggerType, final String requestId) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackConfigRequest(triggerType, requestId);
            }
        });
    }

    public static void trackConfigResponse(final int triggerType, final String requestId, final int requestTime, final int code, final String message, final String version) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackConfigResponse(triggerType, requestId, requestTime, code, message, version);
            }
        });
    }

    public static void trackSspRequest(final AdxImpBean info) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequest(info);
            }
        });
    }

    public static void trackSspReturn(List<AdsDTO> infos, final TaErrorCode adError, final AdxImpBean adxImpBean) {
        final ArrayList<AdsDTO> adsDTOs = new ArrayList<AdsDTO>();
        if (infos != null) {
            for (AdsDTO adsDTO : infos) {
                adsDTOs.add(adsDTO);
            }
        }
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturn(adsDTOs, adError, adxImpBean);
            }
        });
    }

    public static void trackSspRequestPs(final AdsDTO info, final String gplink) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequestPs(info, gplink);
            }
        });
    }

    public static void trackSspReturnPs(final AdsDTO info, final List<String> gplinks, final List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS, final TaErrorCode adError) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturnPs(info, gplinks, psLinkListDTOS, adError);
            }
        });
    }

    public static void trackPsPopupImp(final AdsDTO info, final List<String> gplinks, final List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupImp(info, gplinks, psLinkListDTOS);
            }
        });
    }

    public static void trackPsPopupClick(final AdsDTO info, final int clickContentType) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupClick(info, clickContentType);
            }
        });
    }

    public static void trackWebViewRedirect(final AdsDTO info) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackWebViewRedirect(info);
            }
        });
    }

    public static void trackFormInfoSet(final AdsDTO info, final FormBean formBean) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackFormInfoSet(info, formBean);
            }
        });
    }

    public static void trackOfflineWebClick(final String eventDataSet) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackOfflineWebClick(eventDataSet);
            }
        });
    }

    public static void trackMediaCallRequest(final int adType, final String mTriggerId, final String mPlacementId, final int adCount, final int triggerNetState) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackMediaCallRequest(adType, mTriggerId, mPlacementId, adCount, triggerNetState);
            }
        });
    }

    public static void trackAdFillingResult(final AdsDTO info, final String triggerId, final int mTriggerNetState) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackAdFillingResult(info, triggerId, mTriggerNetState);
            }
        });
    }

    public static void trackSspCloseAd(final AdsDTO info) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspCloseAd(info);
            }
        });
    }

    public static void offLineWebComplete(final AdsDTO info, final long webDuration) {
        AthenaUtil.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.offLineWebComplete(info, webDuration);
            }
        });
    }

    private static class AthenaTrackerInvoker {
        private AthenaTrackerInvoker() {
        }

        public static void trackShow(AdsDTO info) {
            if (info == null) {
                return;
            }
            a.a().d("ssp", "currentThread().getId()" + Thread.currentThread().getId());
            Bundle bundle = new Bundle();
            bundle.putDouble("price", info.getFirstPrice().doubleValue());
            bundle.putString("new_price", info.getNewPrice());
            bundle.putInt("popularize_app_install_status", info.getInstallApk());
            bundle.putLong("show_duration", info.getActualShowTime().longValue());
            bundle.putString("show_area", info.getShowArea());
            bundle.putLong("show_report_time_type", (long)info.getShowReportTimeType().intValue());
            bundle.putInt("is_adm_ad", TextUtils.isEmpty((CharSequence)info.getAdm()) ? 1 : 2);
            ArrayList<String> adCreateIds = new ArrayList<String>();
            adCreateIds.add(info.getAdCreativeId() + "");
            bundle.putString("ad_creative_ids", GsonUtil.toJson(adCreateIds));
            if (info.isOfflineAd()) {
                bundle.putLong("ad_expire_time", info.getOfflineAdExpireTime().longValue());
            }
            bundle.putInt("show_times", info.getShowNum().intValue());
            bundle.putInt("source", info.getSource());
            if (info.getImpBeanRequest() != null) {
                bundle.putString("trigger_id", info.getImpBeanRequest().triggerId);
            }
            bundle.putInt("image_width", info.getAdImageWidth().intValue());
            bundle.putInt("image_height", info.getAdImageHeight().intValue());
            bundle.putString("package_name", info.getPackageName());
            bundle.putString("click_url", info.getClickUrl());
            bundle.putInt("is_default_ad", 0);
            bundle.putInt("is_default_ad_first_show", 0);
            new AthenaCust("ad_ssp_show", 2411).trackCommon(AthenaTrackerInvoker.fillAdParamsToBundleForShowAndDeeplink(info, bundle), null).submit();
        }

        public static void trackDeeplink(AdsDTO info) {
            Bundle bundle = new Bundle();
            bundle.putInt("called_url_type", info.getCalledUrlType());
            bundle.putString("app_name", info.getPslinkAppName());
            new AthenaCust("deeplink", 2411).trackCommon(AthenaTrackerInvoker.fillAdParamsToBundleForShowAndDeeplink(info, bundle), null).submit();
        }

        private static Bundle fillAdParamsToBundleForShowAndDeeplink(AdsDTO info, Bundle params) {
            Bundle bundle = AthenaUtil.getBundle((Bundle)params);
            bundle.putString("request_id", info.getRid());
            bundle.putString("code_seat_id", info.getCodeSeatId());
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
            bundle.putInt("cache_time", info.getCacheTime().intValue());
            bundle.putInt("id", info.getId().intValue());
            bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
            bundle.putLong("plan_id", info.getPlanId().longValue());
            bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
            bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
            bundle.putString("tracking_secret_key", info.getShowTrackingSecretKey());
            bundle.putLong("login_time", System.currentTimeMillis());
            bundle.putInt("actual_show_rate", info.getActualShowRate().intValue());
            bundle.putLong("show_ts", System.currentTimeMillis());
            bundle.putInt("is_effective_show", info.getIsEffectiveShow().intValue());
            bundle.putString("app_id", AdManager.AppId);
            if (info.getStoreDeeplink() != null && info.getStoreDeeplink().size() > 0) {
                bundle.putString("click_urls", info.getStoreDeeplink().toString());
            }
            bundle.putInt("is_test_request", AdManager.isTestRequest() ? 1 : 0);
            if (info.getAbTest() != null) {
                bundle.putString("abTest", GsonUtil.toJson(info.getAbTest()));
            }
            bundle.putString("extInfo", info.getExtInfo());
            if (info.getImpBeanRequest() != null) {
                bundle.putInt("request_type", info.getImpBeanRequest().requestType);
            }
            bundle.putLong("is_offline_ad", info.isOfflineAd() ? 1L : 0L);
            bundle.putInt("ad_trigger_status", info.getSource() == 3 ? 1 : 0);
            bundle.putLong("event_ts", System.currentTimeMillis());
            return bundle;
        }

        public static void trackImageDownload(AdsDTO info, int requestType, int downloadWay, int mStatus, int errorCode, int mType, String cdn, long timeConsuming, int fileSize, int isOfflineAd) {
            if (null == info) {
                return;
            }
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("request_id", info.getRid());
            bundle.putString("code_seat_id", info.getCodeSeatId());
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
            bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
            bundle.putLong("plan_id", info.getPlanId().longValue());
            bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
            bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
            bundle.putLong("login_time", System.currentTimeMillis());
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("download_way", downloadWay);
            bundle.putInt("m_status", mStatus);
            bundle.putInt("error_code", errorCode);
            bundle.putInt("m_type", mType);
            bundle.putString("x_response_cdn", cdn);
            bundle.putInt("load_type", requestType);
            bundle.putLong("time_consuming", timeConsuming);
            bundle.putInt("file_size", fileSize);
            bundle.putInt("is_adm_ad", TextUtils.isEmpty((CharSequence)info.getAdm()) ? 1 : 2);
            bundle.putInt("is_offline_ad", isOfflineAd);
            new AthenaCust("material_load", 2411).trackCommon(bundle, null).submit();
        }

        public static void trackSspRequest(AdxImpBean info) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putInt("request_type", info.requestType);
            bundle.putLong("request_ts", info.getRequestTs().longValue());
            bundle.putString("request_id", info.requestId);
            bundle.putLong("event_ts", info.getRequestTs().longValue());
            bundle.putInt("is_offline_ad", info.offlineAd ? 1 : 0);
            bundle.putInt("ad_type", info.adt);
            bundle.putString("trigger_id", info.triggerId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", info.pmid);
            bundle.putInt("ad_count", info.mAdCount);
            bundle.putInt("is_retreatad", 0);
            bundle.putInt("request_num", info.mAdCount);
            if (bundle != null) {
                new AthenaCust("ad_ssp_request", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackSspReturn(List<AdsDTO> adsDTOList, TaErrorCode adError, AdxImpBean adxImpBean) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdsDTO info = null;
            if (adsDTOList != null && adsDTOList.size() > 0) {
                info = adsDTOList.get(0);
                ArrayList<String> adCreateIds = new ArrayList<String>();
                for (AdsDTO adsDTO : adsDTOList) {
                    if (adsDTO == null) continue;
                    adCreateIds.add(adsDTO.getAdCreativeId() + "");
                }
                bundle.putString("ad_creative_ids", GsonUtil.toJson(adCreateIds));
            }
            if (info != null && info.getImpBeanRequest() != null && adxImpBean == null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean != null) {
                bundle.putInt("request_type", adxImpBean.requestType);
                bundle.putLong("request_ts", adxImpBean.getRequestTs().longValue());
                bundle.putString("request_id", adxImpBean.requestId);
                bundle.putString("trigger_id", adxImpBean.triggerId);
                bundle.putInt("ad_type", adxImpBean.adt);
                bundle.putString("code_seat_id", adxImpBean.pmid);
                bundle.putInt("ad_count", adxImpBean.mAdCount);
                if (adxImpBean.getRequestTs() != 0L) {
                    bundle.putInt("return_time", (int)(System.currentTimeMillis() - adxImpBean.getRequestTs()));
                }
                bundle.putInt("is_timeout", adxImpBean.isTimeOut);
                bundle.putInt("request_num", adxImpBean.mAdCount);
                bundle.putInt("is_offline_ad", adxImpBean.offlineAd ? 1 : 0);
                bundle.putLong("event_ts", adxImpBean.getRequestTs().longValue());
            }
            bundle.putString("app_id", AdManager.AppId);
            bundle.putLong("return_ts", System.currentTimeMillis());
            if (adError != null) {
                bundle.putString("error_code", adError.getErrorCode() + "");
                bundle.putString("error_message", adError.getErrorMessage());
            }
            if (info != null) {
                bundle.putDouble("bidding_price", info.getFirstPrice().doubleValue());
                bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
                bundle.putLong("plan_id", info.getPlanId().longValue());
                bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
                bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
                bundle.putInt("is_adm_ad", TextUtils.isEmpty((CharSequence)info.getAdm()) ? 1 : 2);
                bundle.putInt("is_pslink_ad", info.getIsPslinkAd());
            }
            if (bundle != null) {
                new AthenaCust("ad_ssp_return", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackSspRequestPs(AdsDTO info, String gplink) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) {
                return;
            }
            bundle.putString("gplink", gplink);
            bundle.putString("request_id", adxImpBean.requestId);
            info.setRequestPsTs(System.currentTimeMillis());
            bundle.putLong("request_ts", info.getRequestPsTs());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            if (bundle != null) {
                new AthenaCust("ad_ssp_request_ps_material", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackSspReturnPs(AdsDTO info, List<String> gplinks, List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS, TaErrorCode adError) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) {
                return;
            }
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putString("gplink_list", GsonUtil.toJson(gplinks));
            bundle.putString("pslink_list", GsonUtil.toJson(psLinkListDTOS));
            bundle.putLong("request_ts", info.getRequestPsTs());
            info.setReturnPsTs(System.currentTimeMillis());
            bundle.putLong("return_ts", info.getReturnPsTs());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            if (adError != null) {
                bundle.putString("error_code", adError.getErrorCode() + "");
                bundle.putString("error_message", adError.getErrorMessage());
            }
            if (bundle != null) {
                new AthenaCust("ad_ssp_return_ps_material", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackPsPopupImp(AdsDTO info, List<String> gplinks, List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null && adxImpBean == null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) {
                return;
            }
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putString("gplink_list", GsonUtil.toJson(gplinks));
            bundle.putString("pslink_list", GsonUtil.toJson(psLinkListDTOS));
            bundle.putLong("request_ts", info.getRequestPsTs());
            bundle.putLong("return_ts", info.getReturnPsTs());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putLong("popup_imp_ts", System.currentTimeMillis());
            if (bundle != null) {
                new AthenaCust("popup_imp", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackPsPopupClick(AdsDTO info, int clickContentType) {
            Bundle bundle = AthenaUtil.getBundle(null);
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) {
                return;
            }
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putLong("popup_click_ts", System.currentTimeMillis());
            bundle.putInt("click_content_type", clickContentType);
            if (bundle != null) {
                new AthenaCust("popup_click", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackWebViewRedirect(AdsDTO info) {
            if (info == null) {
                return;
            }
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) {
                return;
            }
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("request_type", adxImpBean.requestType);
            bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
            bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
            bundle.putString("web_url", info.getClickUrl());
            if (info.getClickUrlTs() != 0L) {
                bundle.putInt("web_duration", (int)(System.currentTimeMillis() - info.getClickUrlTs()));
            }
            if (bundle != null) {
                new AthenaCust("ad_web_callback", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackConfigRequest(int triggerType, String requestId) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("trigger_type", triggerType);
            bundle.putString("cld_request_id", requestId);
            new AthenaCust("ad_cld_request", 2411).trackCommon(bundle, null).submit();
        }

        public static void trackConfigResponse(int triggerType, String requestId, int requestTime, int code, String message, String version) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putInt("trigger_type", triggerType);
            bundle.putString("cld_request_id", requestId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("cld_return_time_interval", requestTime);
            bundle.putInt("code", code);
            bundle.putString("message", message);
            bundle.putString("cld_version", version);
            new AthenaCust("ad_cld_return", 2411).trackCommon(bundle, null).submit();
        }

        public static void trackFormInfoSet(AdsDTO info, FormBean formBean) {
            if (info == null || formBean == null) {
                return;
            }
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) {
                return;
            }
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("is_offline_ad", 1);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
            bundle.putString("advertiser_id", info.getAdvertiserId().toString());
            bundle.putString("plan_id", info.getPlanId().toString());
            bundle.putString("ad_group_id", info.getAdGroupId().toString());
            bundle.putString("ad_creative_id", info.getAdCreativeId().toString());
            bundle.putString("form_info", GsonUtil.getGson().toJson((Object)formBean));
            if (bundle != null) {
                new AthenaCust("form_infor_set", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackOfflineWebClick(String eventDataSet) {
            if (TextUtils.isEmpty((CharSequence)eventDataSet)) {
                return;
            }
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("event_data_set", eventDataSet);
            if (bundle != null) {
                new AthenaCust("ad_ssp_click", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackMediaCallRequest(int adType, String mTriggerId, String mPlacementId, int adCount, int triggerNetState) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putInt("ad_type", adType);
            bundle.putString("trigger_id", mTriggerId);
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", mPlacementId);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("ad_count", adCount);
            bundle.putInt("ad_trigger_status", triggerNetState);
            bundle.putInt("is_retreatad", 0);
            if (bundle != null) {
                new AthenaCust("media_call_request", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackAdFillingResult(AdsDTO info, String triggerId, int mTriggerNetState) {
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("trigger_id", triggerId);
            if (info == null) {
                bundle.putInt("filling_result", 2);
                bundle.putLong("event_ts", System.currentTimeMillis());
                bundle.putInt("ad_trigger_status", mTriggerNetState);
            } else {
                AdxImpBean adxImpBean = null;
                if (info != null && info.getImpBeanRequest() != null) {
                    adxImpBean = info.getImpBeanRequest();
                }
                if (adxImpBean == null) {
                    return;
                }
                bundle.putInt("filling_result", 1);
                bundle.putInt("source", info.getSource());
                bundle.putInt("ad_trigger_status", mTriggerNetState);
                bundle.putInt("is_offline_ad", info.isOfflineAd() ? 1 : 0);
                bundle.putString("request_id", adxImpBean.requestId);
                bundle.putString("code_seat_id", adxImpBean.pmid);
                bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
                bundle.putString("advertiser_id", info.getAdvertiserId().toString());
                bundle.putLong("event_ts", System.currentTimeMillis());
                bundle.putString("plan_id", info.getPlanId().toString());
                bundle.putString("ad_group_id", info.getAdGroupId().toString());
                bundle.putString("ad_creative_id", info.getAdCreativeId().toString());
            }
            if (bundle != null) {
                new AthenaCust("ad_filling_result", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void trackSspCloseAd(AdsDTO info) {
            if (info == null) {
                return;
            }
            AdxImpBean adxImpBean = null;
            if (info != null && info.getImpBeanRequest() != null) {
                adxImpBean = info.getImpBeanRequest();
            }
            if (adxImpBean == null) {
                return;
            }
            Bundle bundle = AthenaUtil.getBundle(null);
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("request_type", adxImpBean.requestType);
            bundle.putInt("is_offline_ad", info.isOfflineAd() ? 1 : 0);
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putString("app_id", AdManager.AppId);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
            bundle.putInt("cache_time", info.getCacheTime().intValue());
            bundle.putString("id", info.getId().toString());
            bundle.putString("advertiser_id", info.getAdvertiserId().toString());
            bundle.putString("plan_id", info.getPlanId().toString());
            bundle.putString("ad_group_id", info.getAdGroupId().toString());
            bundle.putString("ad_creative_id", info.getAdCreativeId().toString());
            bundle.putLong("show_times", (long)info.getShowNum().intValue());
            bundle.putLong("show_duration", info.getActualShowTime().longValue());
            bundle.putString("show_area", info.getShowArea());
            if (bundle != null) {
                new AthenaCust("ad_ssp_close_ad", 2411).trackCommon(bundle, null).submit();
            }
        }

        public static void offLineWebComplete(AdsDTO info, long webDuration) {
            if (info == null || !info.isOfflineAd()) {
                return;
            }
            Bundle bundle = AthenaTracker.getBundle(null);
            AdxImpBean impBean = info.getImpBeanRequest();
            if (impBean != null) {
                bundle.putString("request_id", impBean.requestId);
                bundle.putInt("request_type", impBean.requestType);
                bundle.putString("code_seat_id", impBean.pmid);
            }
            bundle.putString("web_url", info.getOfflineH5Url());
            bundle.putLong("web_duration", webDuration);
            bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
            bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
            bundle.putLong("event_ts", System.currentTimeMillis());
            bundle.putInt("is_offline_ad", info.isOfflineAd() ? 1 : 0);
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
            if (bundle != null) {
                new AthenaCust("ad_web_complete", 2411).trackCommon(bundle, null).submit();
            }
        }
    }
}

