/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.sdk.common.a;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.RequestBase;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.sign.c;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.builder.PostJsonBuilder;
import com.transsion.http.impl.IHttpCallback;
import com.transsion.http.impl.StringCallback;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class AdServerRequest
extends RequestBase<CommonResponseListener> {
    private String mPlacementid = "0";
    private String mUrl = "";
    private boolean mIsDebug = false;
    private SSLSocketFactory mSSLSocketFactory = null;
    private IAdPostBody mPostBody = null;
    private static String lastCloudCtrlVersion = null;
    private static String lastHisavanaCloudCtrlVersion = null;
    private static boolean ctrlVersionChanged = false;
    private String isOfflineAd = "0";
    private AdxImpBean adxImpBean;

    public AdServerRequest setAdxImpBean(AdxImpBean adxImpBean) {
        this.adxImpBean = adxImpBean;
        return this;
    }

    public AdServerRequest setIsOfflineAd(boolean isOfflineAd) {
        this.isOfflineAd = isOfflineAd ? "1" : "0";
        return this;
    }

    public AdServerRequest setPostBody(IAdPostBody postBody) {
        this.mPostBody = postBody;
        return this;
    }

    public AdServerRequest setListener(CommonResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public AdServerRequest setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public AdServerRequest setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
        return this;
    }

    public AdServerRequest setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.mSSLSocketFactory = sslSocketFactory;
        return this;
    }

    public AdServerRequest setPlacementId(String pid) {
        this.mPlacementid = pid;
        return this;
    }

    @Override
    protected void netRequestPosExecute() {
        TranssionPoolManager.getInstance().addTask(new Runnable(){

            @Override
            public void run() {
                AdServerRequest.this.sendRequestToServer();
            }
        });
    }

    private void sendRequestToServer() {
        block7: {
            String postBodyString = this.mPostBody.getPostBody();
            if (TextUtils.isEmpty((CharSequence)postBodyString)) {
                if (this.mListener != null) {
                    ((CommonResponseListener)this.mListener).onServerRequestFailure(-1, "TextUtils.isEmpty(postBodyString) == true ", null);
                }
                a.netLog((String)"sendRequestToServer() --> TextUtils.isEmpty(postBodyString) == true ");
            }
            if (this.adxImpBean != null) {
                this.adxImpBean.requestTs = System.currentTimeMillis();
                AthenaTracker.trackSspRequest(this.adxImpBean);
            }
            try {
                final String str = "----- full url = " + this.mUrl + "\n ----- postBodyString = " + postBodyString.trim();
                String cloudControlVersion = AdxPreferencesHelper.getInstance().getString("cloudControlVersion", null);
                String cloudControlOfflineVersion = AdxPreferencesHelper.getInstance().getString("hisavanaCurrentCloudControlVersion", null);
                if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
                    if (this.mListener != null) {
                        ((CommonResponseListener)this.mListener).onServerRequestStart(1);
                    }
                    c.a(AdxServerConfig.getAppModle() != 0);
                    String signStr = c.a("post", "", "application/json", this.mUrl, postBodyString);
                    ((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)HttpClient.postJson().log(this.mIsDebug)).sslSocketFactory(this.mSSLSocketFactory)).content(postBodyString).connectTimeout(15000)).readTimeout(15000)).addHeader("x-tr-signature", signStr)).addHeader("cloudControlVersion", cloudControlVersion)).addHeader("cloudControlOfflineVersion", cloudControlOfflineVersion)).addHeader("defaultAd", "2")).addHeader("offlineAd", this.isOfflineAd)).url(this.mUrl)).addHeader("Accept-Timezone", "UTC")).build().execute((IHttpCallback)new StringCallback(true){

                        public void onSuccess(int statusCode, String response) {
                            a.netLog((String)(str + "\n ----- status code = " + statusCode + "\n ----- response = " + response));
                            if (!TextUtils.isEmpty((CharSequence)response)) {
                                if (AdServerRequest.this.mListener != null) {
                                    ((CommonResponseListener)AdServerRequest.this.mListener).onServerRequestSuccess(statusCode, response);
                                }
                            } else {
                                if (AdServerRequest.this.mListener != null) {
                                    ((CommonResponseListener)AdServerRequest.this.mListener).onServerRequestFailure(TaErrorCode.HTTP_RESPONSE_ERROR.getErrorCode(), TaErrorCode.HTTP_RESPONSE_ERROR.getErrorMessage(), null);
                                }
                                a.netLog((String)"TextUtils.isEmpty(response) == true ,  response is null ");
                            }
                        }

                        public void onResponseHeader(Map<String, List<String>> map) {
                            if (map != null) {
                                String hisavanaCtrlVersion;
                                List<String> hisavanaVer;
                                String ctrlVersion;
                                List<String> list = map.get("cloudControlVersion");
                                if (list != null && list.size() > 0 && !TextUtils.isEmpty((CharSequence)(ctrlVersion = list.get(0))) && !ctrlVersion.equals(lastCloudCtrlVersion)) {
                                    lastCloudCtrlVersion = ctrlVersion;
                                    ctrlVersionChanged = true;
                                    a.netLog((String)("get new cloud control version from header,version: " + ctrlVersion));
                                    AdxPreferencesHelper.getInstance().putString("new_config_ver", ctrlVersion);
                                }
                                if ((hisavanaVer = map.get("cloudControlOfflineVersion")) != null && hisavanaVer.size() > 0 && !TextUtils.isEmpty((CharSequence)(hisavanaCtrlVersion = hisavanaVer.get(0))) && !hisavanaCtrlVersion.equals(lastHisavanaCloudCtrlVersion)) {
                                    lastHisavanaCloudCtrlVersion = hisavanaCtrlVersion;
                                    a.netLog((String)("get new hisavana cloud control version from header,version: " + hisavanaCtrlVersion));
                                    AdxPreferencesHelper.getInstance().putString("new_hisavana_ver", hisavanaCtrlVersion);
                                }
                            }
                        }

                        public void onFailure(int statusCode, String response, Throwable throwable) {
                            boolean isNeedRetry = c.a(statusCode, response);
                            if (isNeedRetry) {
                                AdServerRequest.this.sendRequestToServer();
                                return;
                            }
                            if (null != throwable) {
                                a.netLog((String)(str + " ----- error statusCode = " + statusCode + " ----- error message = " + throwable.getMessage() + " ----- response = " + response));
                            }
                            if (AdServerRequest.this.mListener != null) {
                                ((CommonResponseListener)AdServerRequest.this.mListener).onServerRequestFailure(statusCode, response, throwable);
                            }
                        }
                    });
                }
            }
            catch (Throwable e2) {
                a.netLog((String)("AdServerRequest --> " + Log.getStackTraceString((Throwable)e2)));
                if (this.mListener == null) break block7;
                ((CommonResponseListener)this.mListener).onServerRequestFailure(new TaErrorCode(10000, e2.getMessage()));
            }
        }
    }

    public static interface IAdPostBody {
        public String getPostBody();
    }
}

