/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.a;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.RequestBase;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.builder.ImageRequestBuilder;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.IHttpCallback;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class DownLoadRequest
extends RequestBase<DrawableResponseListener> {
    private static final String TAG = "DownLoadRequest";
    public static boolean IS_HAD_AD_CHOICE = false;
    private static final int HTTP_CACHE_SUCCESS = 250;
    private static final int HTTP_CACHE_FAIL = 256;
    long fileSize = 0L;
    String cdn = "";
    long startTime = 0L;
    int errorCode = -1;
    int downloadWay = 1;
    private AdsDTO adsDTO;
    private int mType;
    private int requestType = 1;
    private boolean isFetch = false;
    private boolean isOffline = false;
    private boolean isUsePool = true;
    private String url = "";
    private int isPreCache = 1;

    public static void downloadImage(@NonNull String url, AdsDTO adsDTO, int materialType, DrawableResponseListener listener) {
        DownLoadRequest.downloadImage(url, 3, adsDTO, materialType, false, false, listener);
    }

    public static void getImage(@NonNull String url, AdsDTO adsDTO, int materialType, DrawableResponseListener listener) {
        DownLoadRequest.downloadImage(url, 1, adsDTO, materialType, false, false, listener);
    }

    public static void downloadFile(@NonNull String url, int isPreCache, AdsDTO adsDTO, int materialType, boolean isFetch, DrawableResponseListener listener) {
        DownLoadRequest.downloadImage(url, isPreCache, adsDTO, materialType, isFetch, false, listener);
    }

    public static void downloadImage(@NonNull String url, int isPreCache, AdsDTO adsDTO, int materialType, boolean isFetch, boolean usePool, DrawableResponseListener listener) {
        DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(isPreCache).setListener(listener).setUrl(url).setUsePool(usePool).setAdsDTO(adsDTO, materialType).setFetch(isFetch);
        downLoadRequest.netRequestPreExecute();
    }

    public static void renderImageView(@NonNull String url, final @NonNull ImageView imageView, AdsDTO adsDTO, int materialType) {
        DownLoadRequest.getImage(url, adsDTO, materialType, new DrawableResponseListener(){

            @Override
            public void onRequestError(TaErrorCode adError) {
                a.a().e(DownLoadRequest.TAG, "loadImageView " + adError);
            }

            @Override
            public void onRequestSuccess(int statusCode, AdImage mediaBean) {
                if (mediaBean == null) {
                    return;
                }
                mediaBean.attachView(imageView);
            }
        });
    }

    private DownLoadRequest() {
    }

    public DownLoadRequest setAdsDTO(AdsDTO ads, int type) {
        this.adsDTO = ads;
        if (ads != null) {
            this.isOffline = ads.isOfflineAd();
        }
        this.mType = type;
        return this;
    }

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    public DownLoadRequest setFetch(boolean isFectch) {
        this.isFetch = isFectch;
        return this;
    }

    public DownLoadRequest setUsePool(boolean usePool) {
        this.isUsePool = usePool;
        return this;
    }

    @Override
    public void netRequestPreExecute() {
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            a.a().e("ssp", "url is empty");
            return;
        }
        this.netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        try {
            RequestCall requestCall = ((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)HttpClient.image((Context)CoreUtil.getContext()).log(false)).cache(true).fetchFilePath(this.isFetch)).useOffLineCache(this.isOffline).connectTimeout(15000)).readTimeout(20000)).url(this.url)).build();
            this.startTime = System.currentTimeMillis();
            ImageURL imageURL = new ImageURL(this.url);
            String md5Url = imageURL.toMD5();
            a.a().d(TAG, md5Url);
            requestCall.execute((IHttpCallback)new HttpCallbackImpl(this.isUsePool){

                public void onSuccess(int statusCode, byte[] data) {
                    a.a().d(DownLoadRequest.TAG, "DownLoadRequest --> onSuccess statusCode " + statusCode + " url " + DownLoadRequest.this.url);
                    DownLoadRequest.this.requestType = statusCode == 250 ? 2 : 1;
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, data, null);
                    }
                    if (null != data) {
                        DownLoadRequest.this.fileSize = data.length;
                    }
                    if (DownLoadRequest.this.mType == 3) {
                        IS_HAD_AD_CHOICE = true;
                    }
                    DownLoadRequest.this.downloadTrack(2);
                }

                public void onResponseHeader(Map<String, List<String>> map) {
                    List<String> strings;
                    super.onResponseHeader(map);
                    if (null != map && !map.isEmpty() && null != (strings = map.get("x-response-cdn")) && !strings.isEmpty()) {
                        DownLoadRequest.this.cdn = strings.get(0);
                    }
                }

                public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                    a.a().d("ssp", "DownLoadRequest --> onFailure statusCode " + statusCode + " e" + throwable + " url " + DownLoadRequest.this.url);
                    DownLoadRequest.this.requestType = statusCode == 256 ? 2 : 1;
                    if (DownLoadRequest.this.mListener != null) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestFailure(statusCode, bytes, throwable);
                    }
                    DownLoadRequest.this.errorCode = statusCode;
                    DownLoadRequest.this.downloadTrack(3);
                }

                public void onSuccess(int statusCode, byte[] responseBody, String filePath) {
                    a.a().d("ssp", "DownLoadRequest --> onSuccess statusCode " + statusCode + " filePath " + filePath + " url" + DownLoadRequest.this.url);
                    DownLoadRequest.this.requestType = statusCode == 250 ? 2 : 1;
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, responseBody, filePath);
                    }
                    if (null != responseBody) {
                        DownLoadRequest.this.fileSize = responseBody.length;
                    }
                    if (DownLoadRequest.this.mType == 3) {
                        IS_HAD_AD_CHOICE = true;
                    }
                    DownLoadRequest.this.downloadTrack(2);
                }
            });
        }
        catch (Throwable e2) {
            a.a().e(Log.getStackTraceString((Throwable)e2));
            this.errorCode = 101;
            this.downloadTrack(3);
        }
    }

    private void downloadTrack(int mStatus) {
        if (this.mType == 3) {
            return;
        }
        AthenaTracker.trackImageDownload(this.adsDTO, this.requestType, this.downloadWay, mStatus, this.errorCode, this.mType, this.cdn, System.currentTimeMillis() - this.startTime, this.getSize(this.fileSize), this.isOffline ? 1 : 0);
    }

    private int getSize(long byteSize) {
        int size = 0;
        try {
            BigDecimal sizeNew = new BigDecimal(byteSize);
            size = sizeNew.divide(BigDecimal.valueOf(1024L), 0, 4).intValue();
        }
        catch (Exception e2) {
            a.a().d("ssp", Log.getStackTraceString((Throwable)e2));
        }
        return size;
    }

    public static interface CacheListener {
        public void onSuccess();

        public void onError(TaErrorCode var1);
    }
}

