/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http.listener;

import android.os.Handler;
import android.os.Looper;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;

public abstract class ResponseBaseListener {
    protected Handler handler = null;
    private static final int SUCCESS = 200;

    public ResponseBaseListener() {
        this(Looper.myLooper());
    }

    protected ResponseBaseListener(boolean usePool) {
        this(usePool ? null : Looper.myLooper());
    }

    private ResponseBaseListener(Looper looper) {
        this.handler = looper != null ? new ResponderHandler(looper) : null;
    }

    public void onServerRequestFailure(int statusCode, String responseBody, Throwable throwable) {
        this.onServerRequestFailure(new TaErrorCode(statusCode, "erro msg = " + responseBody));
    }

    public void onServerRequestFailure(int statusCode, byte[] responseBody, Throwable throwable) {
        this.onServerRequestFailure(new TaErrorCode(statusCode, "erro msg = " + responseBody));
    }

    public void onServerRequestFailure(final TaErrorCode adError) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestError(adError);
                }
            });
        } else {
            this.onRequestError(adError);
        }
    }

    public void onServerRequestStart(final int type) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestStart(type);
                }
            });
        } else {
            this.onRequestStart(type);
        }
    }

    public abstract void onRequestError(TaErrorCode var1);

    public void onRequestStart(int type) {
    }

    private class ResponderHandler
    extends Handler {
        ResponderHandler(Looper looper) {
            super(looper);
        }
    }
}

