/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.api.config.AdManager;
import com.cloud.hisavana.sdk.common.a;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.PermissionUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    public static File getAppDateFilePath() {
        Context context = CoreUtil.getContext();
        if (PermissionUtil.lacksPermissions((String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"})) {
            return null;
        }
        return context.getExternalFilesDir(null);
    }

    public static File getAppDateCachePath() {
        Context context = CoreUtil.getContext();
        return context.getExternalCacheDir();
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    public static void saveBitmapToFile(File dirFile, Bitmap bm, String fileName) throws IOException {
        if (dirFile == null || bm == null || TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        File myCaptureFile = new File(dirFile + File.separator + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
        bm.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
        bos.flush();
        bos.close();
    }

    public static void saveBytesToFile(File dir, byte[] bytes, String fileName) throws IOException {
        if (dir == null || bytes == null || bytes.length == 0 || TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        File myCaptureFile = new File(dir + File.separator + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
        bos.write(bytes);
        bos.flush();
        bos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStrFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            char[] bt = new char[1024];
            StringBuffer sb = new StringBuffer();
            int len = 0;
            while ((len = fileReader.read(bt)) != -1) {
                sb.append(bt, 0, len);
            }
            if (sb.length() == 0) {
                String string2 = null;
                return string2;
            }
            a.a().d("ssp", AdManager.isDebug() ? sb.toString() : "");
            fileReader.close();
            String string3 = sb.toString();
            return string3;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            String string4 = null;
            return string4;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public static void deleteFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            FileUtil.deleteFile(file);
        }
        dir.delete();
    }

    public static String getAppFilePath(Context context) {
        File appCacheDir;
        String externalStorageState;
        try {
            externalStorageState = Environment.getExternalStorageState();
        }
        catch (NullPointerException e2) {
            externalStorageState = "";
        }
        catch (IncompatibleClassChangeError e3) {
            externalStorageState = "";
        }
        if ("mounted".equals(externalStorageState) && (appCacheDir = context.getExternalFilesDir(null)) != null && appCacheDir.exists()) {
            return appCacheDir.getAbsolutePath();
        }
        appCacheDir = context.getFilesDir();
        if (appCacheDir != null && !appCacheDir.exists()) {
            return appCacheDir.getAbsolutePath();
        }
        return "";
    }
}

