/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;
import com.cloud.hisavana.sdk.a.a.b;
import com.cloud.hisavana.sdk.common.a;
import com.cloud.hisavana.sdk.common.util.FileUtil;
import com.cloud.hisavana.sdk.common.util.MD5Utils;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;
import java.io.File;
import java.text.SimpleDateFormat;

public class OfflineAdExpiredUtil {
    public static final String TAG = "OfflineAdExpiredUtil";

    public static boolean idOfflineAdExpired(AdsDTO adsDTO) {
        if (OfflineAdExpiredUtil.idOfflineAdEnd(adsDTO) || !OfflineAdExpiredUtil.isOfflineAdDownloaded(adsDTO)) {
            return false;
        }
        try {
            int day = (int)((System.currentTimeMillis() - adsDTO.getOfflineAdStartDateLong()) / 86400000L);
            return adsDTO.getOfflineAdLaunchDateStr().charAt(day) == '1' && !adsDTO.isReachedDisplayTimes();
        }
        catch (Exception e2) {
            a.a().e(TAG, e2.getMessage());
            return false;
        }
    }

    public static boolean isOfflineAdDownloaded(AdsDTO adsDTO) {
        boolean status;
        if (adsDTO == null) {
            return false;
        }
        String imgUrl = adsDTO.getAdImgUrl();
        if (adsDTO.getImpBeanRequest() != null && adsDTO.getImpBeanRequest().adt == 2 && (TextUtils.equals((CharSequence)adsDTO.getMaterialStyle(), (CharSequence)"B20301") || TextUtils.equals((CharSequence)adsDTO.getMaterialStyle(), (CharSequence)"B20302") || TextUtils.equals((CharSequence)adsDTO.getMaterialStyle(), (CharSequence)"B20303"))) {
            imgUrl = adsDTO.getLogoUrl();
        }
        if (!b.b(imgUrl, adsDTO.isOfflineAd())) {
            a.a().d(TAG, "adsDTO MainImages download fail");
            return false;
        }
        String h5Url = adsDTO.getOfflineH5Url();
        if (TextUtils.isEmpty((CharSequence)h5Url)) {
            return true;
        }
        if (adsDTO.isH5Zip()) {
            String outPutPath = FileUtil.getAppFilePath(CoreUtil.getContext()) + File.separator + "offline_zip" + File.separator + MD5Utils.toMd5(h5Url);
            File file = new File(outPutPath);
            status = file.exists();
            a.a().d(TAG, "adsDTO offline zip download status: " + status);
        } else {
            status = !TextUtils.isEmpty((CharSequence)h5Url) && b.b(h5Url, adsDTO.isOfflineAd());
            a.a().d(TAG, "adsDTO offline res download status: " + status);
        }
        return status;
    }

    public static boolean idOfflineAdEnd(AdsDTO adsDTO) {
        if (adsDTO == null || adsDTO.getOfflineAdStartDate() == null || adsDTO.getOfflineAdLaunchDate() == null) {
            return true;
        }
        try {
            a.a().d(TAG, "idOfflineAdEnd  " + adsDTO.getId());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            long offlineAdStartDate = format.parse(adsDTO.getOfflineAdStartDate()).getTime();
            adsDTO.setOfflineAdStartDateLong(offlineAdStartDate);
            String str = Long.toBinaryString(adsDTO.getOfflineAdLaunchDate());
            adsDTO.setOfflineAdLaunchDateStr(str);
            int lastIndexValid = str.lastIndexOf("1") + 1;
            adsDTO.setOfflineAdExpireTime(offlineAdStartDate + 86400000L * (long)lastIndexValid);
            if (System.currentTimeMillis() <= adsDTO.getOfflineAdExpireTime()) {
                a.a().d(TAG, "adsDTO idOfflineAdEnd false");
                return false;
            }
        }
        catch (Exception e2) {
            a.a().e(TAG, e2.getMessage());
        }
        return true;
    }
}

